/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import org.apache.camel.Converter;

@Converter
public final class HL7Converter {
    private HL7Converter() {
    }

    @Converter
    public static String toString(Message message) throws HL7Exception {
        return HL7Converter.encode(message, true);
    }

    @Converter
    public static Message toMessage(String body) throws HL7Exception {
        return HL7Converter.parse(body, true);
    }

    static Message parse(String body, boolean validate) throws HL7Exception {
        body = body.replace('\n', '\r');
        PipeParser parser = new PipeParser();
        if (!validate) {
            parser.setValidationContext((ValidationContext)new NoValidation());
        }
        return parser.parse(body);
    }

    static String encode(Message message, boolean validate) throws HL7Exception {
        PipeParser parser = new PipeParser();
        if (!validate) {
            parser.setValidationContext((ValidationContext)new NoValidation());
        }
        return parser.encode(message);
    }
}

