/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb;

import java.io.File;
import java.io.IOException;
import org.apache.camel.Service;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelDBFile
implements Service {
    private static final transient Logger LOG = LoggerFactory.getLogger(LevelDBFile.class);
    private DB db;
    private File file;
    private int writeBufferSize = 0x400000;
    private int maxOpenFiles = 1000;
    private int blockRestartInterval = 16;
    private int blockSize = 4096;
    private String compressionType;
    private boolean verifyChecksums = true;
    private boolean paranoidChecks;
    private long cacheSize = 0x2000000L;
    private boolean sync;

    public DB getDb() {
        return this.db;
    }

    public void setFile(File file) throws IOException {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFileName(String fileName) {
        this.file = new File(fileName);
    }

    public String getFileName() throws IOException {
        return this.file.getCanonicalPath();
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public int getBlockRestartInterval() {
        return this.blockRestartInterval;
    }

    public void setBlockRestartInterval(int blockRestartInterval) {
        this.blockRestartInterval = blockRestartInterval;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public boolean isVerifyChecksums() {
        return this.verifyChecksums;
    }

    public void setVerifyChecksums(boolean verifyChecksums) {
        this.verifyChecksums = verifyChecksums;
    }

    public boolean isParanoidChecks() {
        return this.paranoidChecks;
    }

    public void setParanoidChecks(boolean paranoidChecks) {
        this.paranoidChecks = paranoidChecks;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public WriteOptions getWriteOptions() {
        WriteOptions options = new WriteOptions();
        options.sync(this.sync);
        return options;
    }

    public void start() {
        if (this.getFile() == null) {
            throw new IllegalArgumentException("A file must be configured");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting LevelDB using file: {}", (Object)this.getFile());
        }
        Options options = new Options().writeBufferSize(this.writeBufferSize).maxOpenFiles(this.maxOpenFiles).blockRestartInterval(this.blockRestartInterval).blockSize(this.blockSize).verifyChecksums(this.verifyChecksums).paranoidChecks(this.paranoidChecks).cacheSize(this.cacheSize);
        if ("snappy".equals(this.compressionType)) {
            options.compressionType(CompressionType.SNAPPY);
        } else {
            options.compressionType(CompressionType.NONE);
        }
        options.createIfMissing(true);
        try {
            this.getFile().getParentFile().mkdirs();
            this.db = JniDBFactory.factory.open(this.getFile(), options);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error opening LevelDB with file " + this.getFile(), ioe);
        }
    }

    public void stop() {
        File file = this.getFile();
        LOG.debug("Stopping LevelDB using file: {}", (Object)file);
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }
}

