/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ses;

import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.services.simpleemail.model.SendEmailResult;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.ses.SesConfiguration;
import org.apache.camel.component.aws.ses.SesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;

public class SesProducer
extends DefaultProducer {
    public SesProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        SendEmailRequest request = this.createMailRequest(exchange);
        this.log.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        SendEmailResult result = this.getEndpoint().getSESClient().sendEmail(request);
        this.log.trace("Received result [{}]", (Object)result);
        Message message = this.getMessageForResponse(exchange);
        message.setHeader("CamelAwsSesMessageId", (Object)result.getMessageId());
    }

    private SendEmailRequest createMailRequest(Exchange exchange) {
        SendEmailRequest request = new SendEmailRequest();
        request.setSource(this.determineFrom(exchange));
        request.setDestination(this.determineTo(exchange));
        request.setReturnPath(this.determineReturnPath(exchange));
        request.setReplyToAddresses(this.determineReplyToAddresses(exchange));
        request.setMessage(this.createMessage(exchange));
        return request;
    }

    private com.amazonaws.services.simpleemail.model.Message createMessage(Exchange exchange) {
        com.amazonaws.services.simpleemail.model.Message message = new com.amazonaws.services.simpleemail.model.Message();
        message.setBody(new Body(new Content((String)exchange.getIn().getBody(String.class))));
        message.setSubject(new Content(this.determineSubject(exchange)));
        return message;
    }

    private Collection<String> determineReplyToAddresses(Exchange exchange) {
        List<String> replyToAddresses = (List<String>)exchange.getIn().getHeader("CamelAwsSesReplyToAddresses", List.class);
        if (replyToAddresses == null) {
            replyToAddresses = this.getConfiguration().getReplyToAddresses();
        }
        return replyToAddresses;
    }

    private String determineReturnPath(Exchange exchange) {
        String returnPath = (String)exchange.getIn().getHeader("CamelAwsSesReturnPath", String.class);
        if (returnPath == null) {
            returnPath = this.getConfiguration().getReturnPath();
        }
        return returnPath;
    }

    private Destination determineTo(Exchange exchange) {
        List<String> to = (List<String>)exchange.getIn().getHeader("CamelAwsSesTo", List.class);
        if (to == null) {
            to = this.getConfiguration().getTo();
        }
        return new Destination(to);
    }

    private String determineFrom(Exchange exchange) {
        String from = (String)exchange.getIn().getHeader("CamelAwsSesFrom", String.class);
        if (from == null) {
            from = this.getConfiguration().getFrom();
        }
        return from;
    }

    private String determineSubject(Exchange exchange) {
        String subject = (String)exchange.getIn().getHeader("CamelAwsSesSubject", String.class);
        if (subject == null) {
            subject = this.getConfiguration().getSubject();
        }
        return subject;
    }

    private Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    protected SesConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        return "SesProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }

    public SesEndpoint getEndpoint() {
        return (SesEndpoint)super.getEndpoint();
    }
}

