/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageNotInflightException;
import com.amazonaws.services.sqs.model.ReceiptHandleIsInvalidException;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.sqs.SqsConfiguration;
import org.apache.camel.component.aws.sqs.SqsEndpoint;
import org.apache.camel.impl.ScheduledBatchPollingConsumer;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsConsumer
extends ScheduledBatchPollingConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SqsConsumer.class);
    private ScheduledExecutorService scheduledExecutor;

    public SqsConsumer(SqsEndpoint endpoint, Processor processor) throws NoFactoryAvailableException {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        ReceiveMessageRequest request = new ReceiveMessageRequest(this.getQueueUrl());
        request.setMaxNumberOfMessages(this.getMaxMessagesPerPoll() > 0 ? Integer.valueOf(this.getMaxMessagesPerPoll()) : null);
        request.setVisibilityTimeout(this.getConfiguration().getVisibilityTimeout() != null ? this.getConfiguration().getVisibilityTimeout() : null);
        request.setAttributeNames(this.getConfiguration().getAttributeNames() != null ? this.getConfiguration().getAttributeNames() : null);
        LOG.trace("Receiving messages with request [{}]...", (Object)request);
        ReceiveMessageResult messageResult = this.getClient().receiveMessage(request);
        LOG.trace("Received {} messages", (Object)messageResult.getMessages().size());
        Queue<Exchange> exchanges = this.createExchanges(messageResult.getMessages());
        return this.processBatch(CastUtils.cast(exchanges));
    }

    protected Queue<Exchange> createExchanges(List<Message> messages) {
        LOG.trace("Received {} messages in this poll", (Object)messages.size());
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        for (Message message : messages) {
            Exchange exchange = this.getEndpoint().createExchange(message);
            answer.add(exchange);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            Integer visibilityTimeout = this.getConfiguration().getVisibilityTimeout();
            if (this.scheduledExecutor != null && visibilityTimeout != null && visibilityTimeout / 2 > 0) {
                int delay = visibilityTimeout / 2;
                int period = visibilityTimeout;
                LOG.debug("Scheduled TimeoutExtender task to start after {} delay, and run with {} period (seconds) to extend exchangeId: {}", new Object[]{delay, period, exchange.getExchangeId()});
                int repeatSeconds = new Double(visibilityTimeout.doubleValue() * 1.5).intValue();
                LOG.debug("period :" + period);
                LOG.debug("repeatSeconds :" + repeatSeconds);
                final ScheduledFuture<?> scheduledFuture = this.scheduledExecutor.scheduleAtFixedRate(new TimeoutExtender(exchange, repeatSeconds), delay, period, TimeUnit.SECONDS);
                exchange.addOnCompletion(new Synchronization(){

                    public void onComplete(Exchange exchange) {
                        this.cancelExtender(exchange);
                    }

                    public void onFailure(Exchange exchange) {
                        this.cancelExtender(exchange);
                    }

                    private void cancelExtender(Exchange exchange) {
                        LOG.trace("Processing done so cancelling TimeoutExtender task for exchangeId: {}", (Object)exchange.getExchangeId());
                        scheduledFuture.cancel(true);
                    }
                });
            }
            exchange.addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    SqsConsumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    SqsConsumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "SqsConsumerOnCompletion";
                }
            });
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            try {
                this.getProcessor().process(exchange);
                continue;
            }
            finally {
                LOG.trace("Processing exchange [{}] done.", (Object)exchange);
            }
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            if (this.getConfiguration().isDeleteAfterRead().booleanValue()) {
                String receiptHandle = (String)exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class);
                DeleteMessageRequest deleteRequest = new DeleteMessageRequest(this.getQueueUrl(), receiptHandle);
                LOG.trace("Deleting message with receipt handle {}...", (Object)receiptHandle);
                this.getClient().deleteMessage(deleteRequest);
                LOG.trace("Message deleted");
            }
        }
        catch (AmazonClientException e) {
            this.getExceptionHandler().handleException("Error occurred during deleting message.", (Throwable)e);
        }
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            LOG.warn("Exchange failed, so rolling back message status: " + exchange, (Throwable)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    protected SqsConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected AmazonSQSClient getClient() {
        return this.getEndpoint().getClient();
    }

    protected String getQueueUrl() {
        return this.getEndpoint().getQueueUrl();
    }

    public SqsEndpoint getEndpoint() {
        return (SqsEndpoint)super.getEndpoint();
    }

    public String toString() {
        return "SqsConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getConfiguration().isExtendMessageVisibility() && this.scheduledExecutor == null) {
            this.scheduledExecutor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "SqsTimeoutExtender");
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.scheduledExecutor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.scheduledExecutor);
            this.scheduledExecutor = null;
        }
    }

    private class TimeoutExtender
    implements Runnable {
        private final Exchange exchange;
        private final int repeatSeconds;

        public TimeoutExtender(Exchange exchange, int repeatSeconds) {
            this.exchange = exchange;
            this.repeatSeconds = repeatSeconds;
        }

        @Override
        public void run() {
            ChangeMessageVisibilityRequest request = new ChangeMessageVisibilityRequest(SqsConsumer.this.getQueueUrl(), (String)this.exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class), Integer.valueOf(this.repeatSeconds));
            try {
                LOG.trace("Extending visibility window by {} seconds for exchange {}", (Object)this.repeatSeconds, (Object)this.exchange);
                SqsConsumer.this.getEndpoint().getClient().changeMessageVisibility(request);
                LOG.debug("Extended visibility window by {} seconds for exchange {}", (Object)this.repeatSeconds, (Object)this.exchange);
            }
            catch (ReceiptHandleIsInvalidException e) {
            }
            catch (MessageNotInflightException e) {
            }
            catch (Exception e) {
                LOG.warn("Extending visibility window failed for exchange " + this.exchange + ". Will not attempt to extend visibility further. This exception will be ignored.", (Throwable)e);
            }
        }
    }
}

