/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.overrides;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ClassOverridesNetwork;
import org.eclipse.recommenders.internal.completion.rcp.overrides.OverridesRecommendation;
import org.eclipse.recommenders.internal.rcp.models.IModelArchiveStore;
import org.eclipse.recommenders.internal.utils.codestructs.MethodDeclaration;
import org.eclipse.recommenders.internal.utils.codestructs.TypeDeclaration;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.recommenders.utils.rcp.JdtUtils;

public class OverridesRecommender {
    private final double MIN_PROBABILITY_THRESHOLD = 0.1;
    private IModelArchiveStore<IType, ClassOverridesNetwork> modelStore;
    private final JavaElementResolver jdtCache;
    private IType enclosingType;
    private IType supertype;
    private List<OverridesRecommendation> recommendations = Collections.emptyList();
    private ClassOverridesNetwork model;
    private IRecommendersCompletionContext ctx;

    @Inject
    public OverridesRecommender(IModelArchiveStore<IType, ClassOverridesNetwork> modelStore, JavaElementResolver jdtCache) {
        this.modelStore = modelStore;
        this.jdtCache = jdtCache;
    }

    public void startSession(IRecommendersCompletionContext context) throws JavaModelException {
        this.ctx = context;
        if (this.findEnclosingType() && this.findSuperclass() && this.hasModel()) {
            try {
                this.computeRecommendations();
            }
            finally {
                this.releaseModel();
            }
        }
    }

    private boolean findEnclosingType() {
        this.enclosingType = (IType)this.ctx.getEnclosingType().orNull();
        return this.enclosingType != null;
    }

    private boolean findSuperclass() {
        this.supertype = (IType)JdtUtils.findSuperclass((IType)this.enclosingType).orNull();
        return this.supertype != null;
    }

    private boolean hasModel() {
        this.model = (ClassOverridesNetwork)this.modelStore.aquireModel((Object)this.supertype).orNull();
        return this.model != null;
    }

    private void computeRecommendations() throws JavaModelException {
        TypeDeclaration query = this.computeQuery();
        for (MethodDeclaration method : query.methods) {
            this.model.observeMethodNode(method.superDeclaration);
        }
        this.recommendations = this.readRecommendations();
    }

    private TypeDeclaration computeQuery() throws JavaModelException {
        TypeDeclaration query = TypeDeclaration.create(null, (ITypeName)this.jdtCache.toRecType(this.supertype));
        IMethod[] iMethodArray = this.enclosingType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            Optional superMethod = JdtUtils.findOverriddenMethod((IMethod)m);
            if (superMethod.isPresent()) {
                IMethodName recMethod = (IMethodName)this.jdtCache.toRecMethod(m).or((Object)VmMethodName.NULL);
                IMethodName recSuperMethod = (IMethodName)this.jdtCache.toRecMethod((IMethod)superMethod.get()).or((Object)VmMethodName.NULL);
                MethodDeclaration create = MethodDeclaration.create((IMethodName)recMethod);
                create.superDeclaration = recSuperMethod;
                query.methods.add(create);
            }
            ++n2;
        }
        return query;
    }

    private List<OverridesRecommendation> readRecommendations() {
        LinkedList res = Lists.newLinkedList();
        for (Tuple tuple : this.model.getRecommendedMethodOverrides(0.1, 5)) {
            IMethodName method = (IMethodName)tuple.getFirst();
            Double probability = (Double)tuple.getSecond();
            OverridesRecommendation recommendation = new OverridesRecommendation(method, probability);
            res.add(recommendation);
        }
        return res;
    }

    public List<OverridesRecommendation> getRecommendations() {
        return this.recommendations;
    }

    private void releaseModel() {
        if (this.model != null) {
            this.modelStore.releaseModel((Object)this.model);
        }
    }
}

