/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.ErrorDetail;
import org.mvel2.Operator;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.AssertNode;
import org.mvel2.ast.AssignmentNode;
import org.mvel2.ast.BooleanNode;
import org.mvel2.ast.DeclTypedVarNode;
import org.mvel2.ast.DeepAssignmentNode;
import org.mvel2.ast.DoNode;
import org.mvel2.ast.DoUntilNode;
import org.mvel2.ast.EndOfStatement;
import org.mvel2.ast.Fold;
import org.mvel2.ast.ForEachNode;
import org.mvel2.ast.ForNode;
import org.mvel2.ast.Function;
import org.mvel2.ast.IfNode;
import org.mvel2.ast.ImportNode;
import org.mvel2.ast.IndexedAssignmentNode;
import org.mvel2.ast.IndexedDeclTypedVarNode;
import org.mvel2.ast.IndexedOperativeAssign;
import org.mvel2.ast.IndexedPostFixDecNode;
import org.mvel2.ast.IndexedPostFixIncNode;
import org.mvel2.ast.IndexedPreFixDecNode;
import org.mvel2.ast.IndexedPreFixIncNode;
import org.mvel2.ast.InlineCollectionNode;
import org.mvel2.ast.InterceptorWrapper;
import org.mvel2.ast.Invert;
import org.mvel2.ast.IsDef;
import org.mvel2.ast.LineLabel;
import org.mvel2.ast.LiteralDeepPropertyNode;
import org.mvel2.ast.LiteralNode;
import org.mvel2.ast.Negation;
import org.mvel2.ast.NewObjectNode;
import org.mvel2.ast.OperativeAssign;
import org.mvel2.ast.OperatorNode;
import org.mvel2.ast.PostFixDecNode;
import org.mvel2.ast.PostFixIncNode;
import org.mvel2.ast.PreFixDecNode;
import org.mvel2.ast.PreFixIncNode;
import org.mvel2.ast.RegExMatch;
import org.mvel2.ast.ReturnNode;
import org.mvel2.ast.Sign;
import org.mvel2.ast.StaticImportNode;
import org.mvel2.ast.Substatement;
import org.mvel2.ast.ThisWithNode;
import org.mvel2.ast.TypeCast;
import org.mvel2.ast.TypeDescriptor;
import org.mvel2.ast.TypedVarNode;
import org.mvel2.ast.Union;
import org.mvel2.ast.UntilNode;
import org.mvel2.ast.WhileNode;
import org.mvel2.ast.WithNode;
import org.mvel2.compiler.BlankLiteral;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.FunctionParser;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.Soundex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractParser
implements Serializable {
    protected char[] expr;
    protected int cursor;
    protected int start;
    protected int length;
    protected int fields;
    protected static final int OP_OVERFLOW = -2;
    protected static final int OP_TERMINATE = -1;
    protected static final int OP_RESET_FRAME = 0;
    protected static final int OP_CONTINUE = 1;
    protected boolean greedy = true;
    protected boolean lastWasIdentifier = false;
    protected boolean lastWasLineLabel = false;
    protected boolean lastWasComment = false;
    protected boolean compileMode = false;
    protected int literalOnly = -1;
    protected int lastLineStart = 0;
    protected int line = 0;
    protected ASTNode lastNode;
    private static final WeakHashMap<String, char[]> EX_PRECACHE = new WeakHashMap(15);
    public static final HashMap<String, Object> LITERALS = new HashMap(70, 0.4f);
    public static final HashMap<String, Integer> OPERATORS = new HashMap(50, 0.4f);
    protected ExecutionStack stk;
    protected ExecutionStack splitAccumulator = new ExecutionStack();
    protected final ParserContext pCtx;
    protected ExecutionStack dStack;
    protected Object ctx;
    protected VariableResolverFactory variableFactory;
    protected final boolean debugSymbols;
    protected static final int SET = 0;
    protected static final int REMOVE = 1;
    protected static final int GET = 2;
    protected static final int GET_OR_CREATE = 3;
    public static final int LEVEL_5_CONTROL_FLOW = 5;
    public static final int LEVEL_4_ASSIGNMENT = 4;
    public static final int LEVEL_3_ITERATION = 3;
    public static final int LEVEL_2_MULTI_STATEMENT = 2;
    public static final int LEVEL_1_BASIC_LANG = 1;
    public static final int LEVEL_0_PROPERTY_ONLY = 0;

    static {
        LITERALS.put("true", Boolean.TRUE);
        LITERALS.put("false", Boolean.FALSE);
        LITERALS.put("null", null);
        LITERALS.put("nil", null);
        LITERALS.put("empty", BlankLiteral.INSTANCE);
        LITERALS.put("System", System.class);
        LITERALS.put("String", String.class);
        LITERALS.put("CharSequence", CharSequence.class);
        LITERALS.put("Integer", Integer.class);
        LITERALS.put("int", Integer.class);
        LITERALS.put("Long", Long.class);
        LITERALS.put("long", Long.class);
        LITERALS.put("Boolean", Boolean.class);
        LITERALS.put("boolean", Boolean.class);
        LITERALS.put("Short", Short.class);
        LITERALS.put("short", Short.class);
        LITERALS.put("Character", Character.class);
        LITERALS.put("char", Character.class);
        LITERALS.put("Double", Double.class);
        LITERALS.put("double", Double.class);
        LITERALS.put("Float", Float.class);
        LITERALS.put("float", Float.class);
        LITERALS.put("Byte", Byte.class);
        LITERALS.put("byte", Byte.class);
        LITERALS.put("Math", Math.class);
        LITERALS.put("Void", Void.class);
        LITERALS.put("Object", Object.class);
        LITERALS.put("Class", Class.class);
        LITERALS.put("ClassLoader", ClassLoader.class);
        LITERALS.put("Runtime", Runtime.class);
        LITERALS.put("Thread", Thread.class);
        LITERALS.put("Compiler", Compiler.class);
        LITERALS.put("StringBuffer", StringBuffer.class);
        LITERALS.put("StringBuilder", StringBuilder.class);
        LITERALS.put("ThreadLocal", ThreadLocal.class);
        LITERALS.put("SecurityManager", SecurityManager.class);
        LITERALS.put("StrictMath", StrictMath.class);
        LITERALS.put("Array", Array.class);
        AbstractParser.setLanguageLevel(Boolean.getBoolean("mvel.future.lang.support") ? 6 : 5);
    }

    public AbstractParser(ParserContext parserContext) {
        this.pCtx = parserContext;
        this.debugSymbols = this.pCtx.isDebugSymbols();
    }

    protected ASTNode nextTokenSkipSymbols() {
        ASTNode n = this.nextToken();
        if (n != null && n.getFields() == -1) {
            n = this.nextToken();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    protected ASTNode nextToken() {
        block183: {
            block182: {
                if (!this.splitAccumulator.isEmpty()) {
                    this.lastNode = (ASTNode)this.splitAccumulator.pop();
                    if (this.cursor >= this.length && this.lastNode instanceof EndOfStatement) {
                        return this.nextToken();
                    }
                    return this.lastNode;
                }
                if (this.cursor < this.length) break block182;
                return null;
            }
            this.start = this.cursor;
            capture = false;
            union = false;
            if (this.debugSymbols) {
                if (!this.lastWasLineLabel) {
                    if (this.pCtx.getSourceFile() == null) {
                        throw new CompileException("unable to produce debugging symbols: source name must be provided.");
                    }
                    this.line = this.pCtx.getLineCount();
                    this.skipWhitespace();
                    if (!this.pCtx.isKnownLine(this.pCtx.getSourceFile(), this.pCtx.setLineCount(this.line)) && !this.pCtx.isBlockSymbols()) {
                        this.lastWasLineLabel = true;
                        this.pCtx.setLineAndOffset(this.line, this.cursor);
                        this.lastNode = this.pCtx.setLastLineLabel(new LineLabel(this.pCtx.getSourceFile(), this.line, this.pCtx));
                        return this.lastNode;
                    }
                } else {
                    this.lastWasLineLabel = false;
                    this.lastWasComment = false;
                }
            }
            this.skipWhitespace();
            this.start = this.cursor;
            block88: while (this.cursor != this.length) {
                block184: {
                    if (ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                        capture = true;
                        ++this.cursor;
                        while (this.cursor != this.length && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                            ++this.cursor;
                        }
                    }
                    if (!capture) break block184;
                    t = new String(this.expr, this.start, this.cursor - this.start);
                    if (!AbstractParser.OPERATORS.containsKey(t)) ** GOTO lbl-1000
                    switch (AbstractParser.OPERATORS.get(t)) {
                        case 34: {
                            this.start = this.cursor = this.trimRight(this.cursor);
                            if (!ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                                throw new CompileException("unexpected character (expected identifier): " + this.expr[this.cursor], this.expr, this.cursor);
                            }
                            do {
                                this.captureToNextTokenJunction();
                                this.skipWhitespace();
                            } while (this.cursor < this.length && this.expr[this.cursor] == '[');
                            if (this.cursor < this.length && !this.lastNonWhite(']')) {
                                this.captureToEOT();
                            }
                            descr = new TypeDescriptor(this.subArray(this.start, this.cursor), this.fields, this.pCtx);
                            this.lastNode = new NewObjectNode(descr, this.fields, this.pCtx);
                            this.skipWhitespace();
                            if (this.cursor != this.length && this.expr[this.cursor] == '{') {
                                if (!((NewObjectNode)this.lastNode).getTypeDescr().isUndimensionedArray()) {
                                    throw new CompileException("conflicting syntax: dimensioned array with initializer block", this.expr, this.cursor);
                                }
                                this.start = this.cursor;
                                egressType = this.lastNode.getEgressType();
                                if (egressType == null) {
                                    try {
                                        egressType = TypeDescriptor.getClassReference(this.pCtx, descr);
                                    }
                                    catch (ClassNotFoundException e) {
                                        throw new CompileException("could not instantiate class", e);
                                    }
                                }
                                this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.expr[this.cursor], this.pCtx) + 1;
                                if (this.tokenContinues()) {
                                    this.start = this.cursor;
                                    this.lastNode = new InlineCollectionNode(this.expr, this.start, this.start, this.fields, egressType, this.pCtx);
                                    this.captureToEOT();
                                    this.lastNode = new Union(this.expr, this.start + 1, this.cursor, this.fields, this.lastNode);
                                    return this.lastNode;
                                }
                                this.lastNode = new InlineCollectionNode(this.expr, this.start, this.cursor, this.fields, egressType, this.pCtx);
                                return this.lastNode;
                            }
                            if (((NewObjectNode)this.lastNode).getTypeDescr().isUndimensionedArray()) {
                                throw new CompileException("array initializer expected", this.expr, this.cursor);
                            }
                            return this.lastNode;
                        }
                        case 97: {
                            this.start = this.cursor = this.trimRight(this.cursor);
                            this.captureToEOS();
                            this.lastNode = new AssertNode(this.subArray(this.start, this.cursor--), this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        case 99: {
                            this.start = this.cursor = this.trimRight(this.cursor);
                            this.captureToEOS();
                            this.lastNode = new ReturnNode(this.subArray(this.start, this.cursor), this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        case 39: {
                            return this.captureCodeBlock(2048);
                        }
                        case 40: {
                            throw new CompileException("else without if", this.cursor);
                        }
                        case 38: {
                            return this.captureCodeBlock(4096);
                        }
                        case 41: {
                            return this.captureCodeBlock(32768);
                        }
                        case 42: {
                            return this.captureCodeBlock(16384);
                        }
                        case 43: {
                            return this.captureCodeBlock(262144);
                        }
                        case 46: {
                            return this.captureCodeBlock(8192);
                        }
                        case 45: {
                            return this.captureCodeBlock(65536);
                        }
                        case 47: {
                            this.start = this.cursor = this.trimRight(this.cursor);
                            this.captureToNextTokenJunction();
                            this.lastNode = new IsDef(this.subArray(this.start, this.cursor), this.pCtx);
                            return this.lastNode;
                        }
                        case 96: {
                            this.start = this.cursor = this.trimRight(this.cursor);
                            this.captureToEOS();
                            importNode = new ImportNode(this.pCtx, this.subArray(this.start, this.cursor));
                            if (importNode.isPackageImport()) {
                                this.pCtx.addPackageImport(importNode.getPackageImport());
                            } else {
                                this.pCtx.addImport(importNode.getImportClass().getSimpleName(), importNode.getImportClass());
                            }
                            this.lastNode = importNode;
                            return this.lastNode;
                        }
                        case 95: {
                            this.start = this.cursor = this.trimRight(this.cursor);
                            this.captureToEOS();
                            this.lastNode = new StaticImportNode(this.pCtx, this.subArray(this.start, this.cursor));
                            return this.lastNode;
                        }
                        case 100: {
                            this.lastNode = this.captureCodeBlock(100);
                            this.start = this.cursor + 1;
                            return this.lastNode;
                        }
                        case 98: {
                            this.start = this.cursor + 1;
                            while (true) {
                                this.captureToEOT();
                                end = this.cursor;
                                this.skipWhitespace();
                                if (this.cursor != this.length && this.expr[this.cursor] == '=') {
                                    this.cursor = this.start;
                                    if (end != this.cursor) continue block88;
                                    throw new CompileException("illegal use of reserved word: var");
                                }
                                name = new String(this.subArray(this.start, end));
                                if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                    this.lastNode = new IndexedDeclTypedVarNode(idx, Object.class, this.pCtx);
                                    this.splitAccumulator.add(this.lastNode);
                                } else {
                                    this.lastNode = new DeclTypedVarNode(name, Object.class, this.fields, this.pCtx);
                                    this.splitAccumulator.add(this.lastNode);
                                }
                                if (this.cursor == this.length || this.expr[this.cursor] != ',') break;
                                this.skipWhitespace();
                                this.start = ++this.cursor;
                            }
                            return (ASTNode)this.splitAccumulator.pop();
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            this.skipWhitespace();
                            if (this.cursor != this.length && this.expr[this.cursor] == '(') {
                                this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, '(', this.pCtx) + 1;
                            }
                            block92: while (this.cursor != this.length) {
                                switch (this.expr[this.cursor]) {
                                    case '.': {
                                        union = true;
                                        ++this.cursor;
                                        this.skipWhitespace();
                                        break;
                                    }
                                    case '?': {
                                        if (this.lookToLast() != '.') break block92;
                                        union = true;
                                        ++this.cursor;
                                        break;
                                    }
                                    case '+': {
                                        switch (this.lookAhead()) {
                                            case '+': {
                                                name = new String(this.subArray(this.start, this.trimLeft(this.cursor)));
                                                this.lastNode = this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1 ? new IndexedPostFixIncNode(idx, this.pCtx) : new PostFixIncNode(name, this.pCtx);
                                                this.cursor += 2;
                                                this.expectEOS();
                                                return this.lastNode;
                                            }
                                            case '=': {
                                                name = ParseTools.createStringTrimmed(this.expr, this.start, this.cursor - this.start);
                                                this.start = this.cursor += 2;
                                                this.captureToEOS();
                                                if (union) {
                                                    this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 0, name, this.pCtx);
                                                    return this.lastNode;
                                                }
                                                if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                                    this.lastNode = new IndexedAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 0, name, idx, this.pCtx);
                                                    return this.lastNode;
                                                }
                                                this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 0, this.fields, this.pCtx);
                                                return this.lastNode;
                                            }
                                        }
                                        if (!ParseTools.isDigit(this.lookAhead()) || this.cursor <= 1 || this.expr[this.cursor - 1] != 'E' && this.expr[this.cursor - 1] != 'e' || !ParseTools.isDigit(this.expr[this.cursor - 2])) break block92;
                                        ++this.cursor;
                                        continue block88;
                                    }
                                    case '-': {
                                        switch (this.lookAhead()) {
                                            case '-': {
                                                name = new String(this.subArray(this.start, this.trimLeft(this.cursor)));
                                                this.lastNode = this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1 ? new IndexedPostFixDecNode(idx, this.pCtx) : new PostFixDecNode(name, this.pCtx);
                                                this.cursor += 2;
                                                this.expectEOS();
                                                return this.lastNode;
                                            }
                                            case '=': {
                                                name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                                this.start = this.cursor += 2;
                                                this.captureToEOS();
                                                if (union) {
                                                    this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 1, t, this.pCtx);
                                                    return this.lastNode;
                                                }
                                                if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                                    this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 1, idx, this.fields, this.pCtx);
                                                    return this.lastNode;
                                                }
                                                this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 1, this.fields, this.pCtx);
                                                return this.lastNode;
                                            }
                                        }
                                        if (!ParseTools.isDigit(this.lookAhead()) || this.cursor <= 1 || this.expr[this.cursor - 1] != 'E' && this.expr[this.cursor - 1] != 'e' || !ParseTools.isDigit(this.expr[this.cursor - 2])) break block92;
                                        ++this.cursor;
                                        capture = true;
                                        continue block88;
                                    }
                                    case '!': 
                                    case '\"': 
                                    case '\'': 
                                    case ',': 
                                    case ':': 
                                    case ';': {
                                        break block92;
                                    }
                                    case '%': 
                                    case '&': 
                                    case '*': 
                                    case '/': 
                                    case '^': 
                                    case '|': 
                                    case '\u00ab': 
                                    case '\u00ac': 
                                    case '\u00bb': {
                                        op = this.expr[this.cursor];
                                        if (this.lookAhead() != '=') break block92;
                                        name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                        this.start = this.cursor += 2;
                                        this.captureToEOS();
                                        if (union) {
                                            this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, ParseTools.opLookup(op), t, this.pCtx);
                                            return this.lastNode;
                                        }
                                        if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                            this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), ParseTools.opLookup(op), idx, this.fields, this.pCtx);
                                            return this.lastNode;
                                        }
                                        this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), ParseTools.opLookup(op), this.fields, this.pCtx);
                                        return this.lastNode;
                                    }
                                    case '<': {
                                        if (this.lookAhead() != '<' || this.lookAhead(2) != '=') break block92;
                                        name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                        this.start = this.cursor += 3;
                                        this.captureToEOS();
                                        if (union) {
                                            this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 10, t, this.pCtx);
                                            return this.lastNode;
                                        }
                                        if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                            this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 10, idx, this.fields, this.pCtx);
                                            return this.lastNode;
                                        }
                                        this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 10, this.fields, this.pCtx);
                                        return this.lastNode;
                                    }
                                    case '>': {
                                        if (this.lookAhead() != '>') break block92;
                                        if (this.lookAhead(2) == '=') {
                                            name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                            this.start = this.cursor += 3;
                                            this.captureToEOS();
                                            if (union) {
                                                this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 9, t, this.pCtx);
                                                return this.lastNode;
                                            }
                                            if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                                this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 9, idx, this.fields, this.pCtx);
                                                return this.lastNode;
                                            }
                                            this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 9, this.fields, this.pCtx);
                                            return this.lastNode;
                                        }
                                        if (this.lookAhead(2) != '>' || this.lookAhead(3) != '=') break block92;
                                        name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                        this.start = this.cursor += 4;
                                        this.captureToEOS();
                                        if (union) {
                                            this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 11, t, this.pCtx);
                                            return this.lastNode;
                                        }
                                        if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                            this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 11, idx, this.fields, this.pCtx);
                                            return this.lastNode;
                                        }
                                        this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 11, this.fields, this.pCtx);
                                        return this.lastNode;
                                    }
                                    case '(': {
                                        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, '(', this.pCtx) + 1;
                                        break;
                                    }
                                    case '[': {
                                        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, '[', this.pCtx) + 1;
                                        break;
                                    }
                                    case '{': {
                                        if (!union) break block92;
                                        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, '{', this.pCtx) + 1;
                                        break;
                                    }
                                    case '~': {
                                        if (this.lookAhead() != '=') break block92;
                                        tmp = this.subArray(this.start, this.trimLeft(this.cursor));
                                        this.start = this.cursor += 2;
                                        if (!this.isNextIdentifierOrLiteral()) {
                                            throw new CompileException("unexpected symbol '" + this.expr[this.cursor] + "'", this.expr, this.cursor);
                                        }
                                        this.captureToEOT();
                                        this.lastNode = new RegExMatch(tmp, this.fields, this.subArray(this.start, this.cursor), this.pCtx);
                                        return this.lastNode;
                                    }
                                    case '=': {
                                        if (this.lookAhead() == '+') {
                                            name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                            this.start = this.cursor += 2;
                                            if (!this.isNextIdentifierOrLiteral()) {
                                                throw new CompileException("unexpected symbol '" + this.expr[this.cursor] + "'", this.expr, this.cursor);
                                            }
                                            this.captureToEOS();
                                            if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                                this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 0, idx, this.fields, this.pCtx);
                                                return this.lastNode;
                                            }
                                            this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 0, this.fields, this.pCtx);
                                            return this.lastNode;
                                        }
                                        if (this.lookAhead() == '-') {
                                            name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                            this.start = this.cursor += 2;
                                            if (!this.isNextIdentifierOrLiteral()) {
                                                throw new CompileException("unexpected symbol '" + this.expr[this.cursor] + "'", this.expr, this.cursor);
                                            }
                                            this.captureToEOS();
                                            if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                                this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 1, idx, this.fields, this.pCtx);
                                                return this.lastNode;
                                            }
                                            this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 1, this.fields, this.pCtx);
                                            return this.lastNode;
                                        }
                                        if (!this.greedy || this.lookAhead() == '=') break block92;
                                        ++this.cursor;
                                        if (union) {
                                            this.captureToEOS();
                                            this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields | 128, this.pCtx);
                                            return this.lastNode;
                                        }
                                        if (this.lastWasIdentifier) {
                                            return this.procTypedNode(false);
                                        }
                                        if (this.pCtx != null && ((idx = this.pCtx.variableIndexOf(t)) != -1 || this.pCtx.isIndexAllocation())) {
                                            this.captureToEOS();
                                            ian = new IndexedAssignmentNode(this.subArray(this.start, this.cursor), 128, idx, this.pCtx);
                                            if (idx == -1) {
                                                t = ian.getAssignmentVar();
                                                this.pCtx.addIndexedVariable(t);
                                                ian.setRegister(this.pCtx.variableIndexOf(t));
                                            }
                                            this.lastNode = ian;
                                            return this.lastNode;
                                        }
                                        this.captureToEOS();
                                        this.lastNode = new AssignmentNode(this.subArray(this.start, this.cursor), this.fields | 128, this.pCtx);
                                        return this.lastNode;
                                    }
                                    default: {
                                        if (this.cursor == this.length) break block92;
                                        if (ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                                            if (!union) break block92;
                                            ++this.cursor;
                                            while (this.cursor != this.length && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                                                ++this.cursor;
                                            }
                                            continue block92;
                                        }
                                        if (this.cursor + 1 != this.length && ParseTools.isIdentifierPart(this.expr[this.cursor + 1])) break block92;
                                        ++this.cursor;
                                    }
                                }
                            }
                            this.trimWhitespace();
                            return this.createPropertyToken(this.start, this.cursor);
                        }
                    }
                }
                switch (this.expr[this.cursor]) {
                    case '.': {
                        ++this.cursor;
                        if (ParseTools.isDigit(this.expr[this.cursor])) {
                            capture = true;
                            break;
                        }
                        this.expectNextChar_IW('{');
                        this.start = this.cursor;
                        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.start, '{', this.pCtx) + 1;
                        this.lastNode = new ThisWithNode(this.subArray(this.start, this.cursor - 1), this.subArray(this.cursor + 1, this.cursor - 1), this.fields, this.pCtx);
                        return this.lastNode;
                    }
                    case '@': {
                        ++this.start;
                        this.captureToEOT();
                        if (this.pCtx == null || this.pCtx.getInterceptors() == null) ** GOTO lbl361
                        name = new String(this.expr, this.start, this.cursor - this.start);
                        if (this.pCtx.getInterceptors().containsKey(name)) ** GOTO lbl362
lbl361:
                        // 2 sources

                        throw new CompileException("reference to undefined interceptor: " + new String(this.expr, this.start, this.cursor - this.start), this.expr, this.cursor);
lbl362:
                        // 1 sources

                        this.lastNode = new InterceptorWrapper(this.pCtx.getInterceptors().get(name), this.nextToken());
                        return this.lastNode;
                    }
                    case '=': {
                        return this.createOperator(this.expr, this.start, this.cursor += 2);
                    }
                    case '-': {
                        if (this.lookAhead() == '-') {
                            this.cursor += 2;
                            this.skipWhitespace();
                            this.start = this.cursor;
                            this.captureIdentifier();
                            name = new String(this.subArray(this.start, this.cursor));
                            if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                this.lastNode = new IndexedPreFixDecNode(idx, this.pCtx);
                                return this.lastNode;
                            }
                            this.lastNode = new PreFixDecNode(name, this.pCtx);
                            return this.lastNode;
                        }
                        if ((this.cursor == 0 || this.lastNode != null && (this.lastNode instanceof BooleanNode || this.lastNode.isOperator())) && !ParseTools.isDigit(this.lookAhead())) {
                            this.captureToEOT();
                            return new Sign(this.expr, this.start, this.cursor, this.fields, this.pCtx);
                        }
                        if (this.cursor != 0 && !ParseTools.isWhitespace(this.expr[this.cursor - 1]) && (this.lastNode == null || !(this.lastNode instanceof BooleanNode) && !this.lastNode.isOperator()) || !ParseTools.isDigit(this.lookAhead())) {
                            return this.createOperator(this.expr, this.start, this.cursor++ + 1);
                        }
                        if (this.cursor - 1 != 0 || !ParseTools.isDigit(this.expr[this.cursor - 1]) && ParseTools.isDigit(this.lookAhead())) {
                            ++this.cursor;
                            break;
                        }
                        throw new CompileException("not a statement", this.expr, this.cursor);
                    }
                    case '+': {
                        if (this.lookAhead() == '+') {
                            this.cursor += 2;
                            this.skipWhitespace();
                            this.start = this.cursor;
                            this.captureIdentifier();
                            name = new String(this.subArray(this.start, this.cursor));
                            if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                this.lastNode = new IndexedPreFixIncNode(idx, this.pCtx);
                                return this.lastNode;
                            }
                            this.lastNode = new PreFixIncNode(name, this.pCtx);
                            return this.lastNode;
                        }
                        return this.createOperator(this.expr, this.start, this.cursor++ + 1);
                    }
                    case '*': {
                        if (this.lookAhead() == '*') {
                            ++this.cursor;
                        }
                        return this.createOperator(this.expr, this.start, this.cursor++ + 1);
                    }
                    case ';': {
                        ++this.cursor;
                        this.lastWasIdentifier = false;
                        this.lastNode = new EndOfStatement(this.pCtx);
                        return this.lastNode;
                    }
                    case '#': 
                    case '%': 
                    case '/': 
                    case ':': 
                    case '?': 
                    case '^': {
                        return this.createOperator(this.expr, this.start, this.cursor++ + 1);
                    }
                    case '(': {
                        ++this.cursor;
                        singleToken = true;
                        lastWS = false;
                        this.skipWhitespace();
                        brace = 1;
                        while (this.cursor != this.length && brace != 0) {
                            block66 : switch (this.expr[this.cursor]) {
                                case '(': {
                                    ++brace;
                                    break;
                                }
                                case ')': {
                                    --brace;
                                    break;
                                }
                                case '\'': {
                                    this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length);
                                    break;
                                }
                                case '\"': {
                                    this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.length);
                                    break;
                                }
                                case 'i': {
                                    if (brace != 1 || this.lookAhead() != 'n' || !ParseTools.isWhitespace(this.lookAhead(2))) break;
                                    level = brace;
                                    while (this.cursor != this.length) {
                                        switch (this.expr[this.cursor]) {
                                            case '(': {
                                                ++brace;
                                                break;
                                            }
                                            case ')': {
                                                if (--brace >= level) break;
                                                ++this.cursor;
                                                if (this.tokenContinues()) {
                                                    this.lastNode = new Fold(ParseTools.subset(this.expr, this.trimRight(this.start + 1), this.cursor - this.start - 2), this.fields, this.pCtx);
                                                    this.start = this.cursor;
                                                    if (this.expr[this.start] == '.') {
                                                        ++this.start;
                                                    }
                                                    this.captureToEOT();
                                                    this.lastNode = new Union(this.expr, this.trimRight(this.start), this.cursor, this.fields, this.lastNode);
                                                    return this.lastNode;
                                                }
                                                this.lastNode = new Fold(ParseTools.subset(this.expr, this.trimRight(this.start + 1), this.cursor - this.start - 2), this.fields, this.pCtx);
                                                return this.lastNode;
                                            }
                                            case '\'': {
                                                this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length);
                                                break;
                                            }
                                            case '\"': {
                                                this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.length);
                                            }
                                        }
                                        ++this.cursor;
                                    }
                                    throw new CompileException("unterminated projection; closing parathesis required", this.expr, this.cursor);
                                }
                                default: {
                                    if (lastWS && this.expr[this.cursor] != '.') {
                                        switch (this.expr[this.cursor]) {
                                            case '[': 
                                            case ']': {
                                                break block66;
                                            }
                                        }
                                        if (ParseTools.isIdentifierPart(this.expr[this.cursor]) || this.expr[this.cursor] == '.') break;
                                        singleToken = false;
                                        break;
                                    }
                                    if (!ParseTools.isWhitespace(this.expr[this.cursor])) break;
                                    lastWS = true;
                                    this.skipWhitespace();
                                    --this.cursor;
                                }
                            }
                            ++this.cursor;
                        }
                        if (brace != 0) {
                            throw new CompileException("unbalanced braces in expression: (" + brace + "):", this.expr, this.cursor);
                        }
                        tmp = null;
                        if (singleToken) {
                            st = this.trimRight(this.start + 1);
                            tmp = ParseTools.subset(this.expr, st, this.trimLeft(this.cursor - 1) - st);
                            tDescr = new TypeDescriptor(tmp, this.fields, this.pCtx);
                            try {
                                if (tDescr.isClass() && (cls = TypeDescriptor.getClassReference(this.pCtx, tDescr)) != null) {
                                    this.start = this.cursor;
                                    this.captureToEOS();
                                    this.lastNode = new TypeCast(ParseTools.subset(this.expr, this.start, this.cursor - this.start), cls, this.fields, this.pCtx);
                                    return this.lastNode;
                                }
                            }
                            catch (ClassNotFoundException var12_29) {
                                // empty catch block
                            }
                        }
                        if (tmp != null) {
                            return this.handleUnion(this.handleSubstatement(new Substatement(tmp, this.fields, this.pCtx)));
                        }
                        this.start = this.trimRight(this.start + 1);
                        return this.handleUnion(this.handleSubstatement(new Substatement(ParseTools.subset(this.expr, this.start, this.trimLeft(this.cursor - 1) - this.start), this.fields, this.pCtx)));
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        throw new CompileException("unbalanced braces", this.expr, this.cursor);
                    }
                    case '>': {
                        if (this.expr[this.cursor + 1] == '>') {
                            if (this.expr[this.cursor += 2] == '>') {
                                ++this.cursor;
                            }
                            return this.createOperator(this.expr, this.start, this.cursor);
                        }
                        if (this.expr[this.cursor + 1] == '=') {
                            return this.createOperator(this.expr, this.start, this.cursor += 2);
                        }
                        return this.createOperator(this.expr, this.start, ++this.cursor);
                    }
                    case '<': {
                        if (this.expr[++this.cursor] == '<') {
                            if (this.expr[++this.cursor] == '<') {
                                ++this.cursor;
                            }
                            return this.createOperator(this.expr, this.start, this.cursor);
                        }
                        if (this.expr[this.cursor] == '=') {
                            return this.createOperator(this.expr, this.start, ++this.cursor);
                        }
                        return this.createOperator(this.expr, this.start, this.cursor);
                    }
                    case '\"': 
                    case '\'': {
                        this.cursor = ParseTools.captureStringLiteral(this.expr[this.cursor], this.expr, this.cursor, this.length);
                        this.lastNode = new LiteralNode(ParseTools.handleStringEscapes(ParseTools.subset(this.expr, this.start + 1, this.cursor - this.start - 1)), String.class, this.pCtx);
                        ++this.cursor;
                        if (this.tokenContinues()) {
                            this.lastNode = this.handleUnion(this.lastNode);
                            return this.lastNode;
                        }
                        return this.lastNode;
                    }
                    case '&': {
                        if (this.expr[this.cursor++ + 1] == '&') {
                            return this.createOperator(this.expr, this.start, ++this.cursor);
                        }
                        return this.createOperator(this.expr, this.start, this.cursor);
                    }
                    case '|': {
                        if (this.expr[this.cursor++ + 1] == '|') {
                            return this.createOperator(this.expr, this.start, ++this.cursor);
                        }
                        return this.createOperator(this.expr, this.start, this.cursor);
                    }
                    case '~': {
                        if ((this.cursor++ - 1 != 0 || !ParseTools.isIdentifierPart(this.lookBehind())) && ParseTools.isDigit(this.expr[this.cursor])) {
                            this.start = this.cursor;
                            this.captureToEOT();
                            this.lastNode = new Invert(ParseTools.subset(this.expr, this.start, this.cursor - this.start), this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] == '(') {
                            this.start = this.cursor--;
                            this.captureToEOT();
                            this.lastNode = new Invert(ParseTools.subset(this.expr, this.start, this.cursor - this.start), this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] == '=') {
                            ++this.cursor;
                        }
                        return this.createOperator(this.expr, this.start, this.cursor);
                    }
                    case '!': {
                        ++this.cursor;
                        if (this.isNextIdentifier()) {
                            if (this.lastNode != null && !this.lastNode.isOperator()) {
                                throw new CompileException("unexpected operator '!'", this.expr, this.cursor);
                            }
                            this.start = this.cursor;
                            this.captureToEOT();
                            name = new String(this.expr, this.start, this.cursor - this.start);
                            if ("new".equals(name) || "isdef".equals(name)) {
                                this.captureToEOT();
                                this.lastNode = new Negation(ParseTools.subset(this.expr, this.start, this.cursor - this.start), this.fields, this.pCtx);
                                return this.lastNode;
                            }
                            this.lastNode = new Negation(name.toCharArray(), this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] == '(') {
                            this.start = this.cursor--;
                            this.captureToEOT();
                            this.lastNode = new Negation(ParseTools.subset(this.expr, this.start, this.cursor - this.start), this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] != '=') {
                            throw new CompileException("unexpected operator '!'", this.expr, this.cursor, null);
                        }
                        return this.createOperator(this.expr, this.start, ++this.cursor);
                    }
                    case '[': 
                    case '{': {
                        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.expr[this.cursor], this.pCtx) + 1;
                        if (this.tokenContinues()) {
                            this.start = this.cursor;
                            this.lastNode = new InlineCollectionNode(this.expr, this.start, this.start, this.fields, this.pCtx);
                            this.captureToEOT();
                            if (this.expr[this.start] == '.') {
                                ++this.start;
                            }
                            this.lastNode = new Union(this.expr, this.start, this.cursor, this.fields, this.lastNode);
                            return this.lastNode;
                        }
                        this.lastNode = new InlineCollectionNode(this.expr, this.start, this.cursor, this.fields, this.pCtx);
                        return this.lastNode;
                    }
                    default: {
                        ++this.cursor;
                    }
                }
            }
            if (this.start != this.cursor) break block183;
            return null;
        }
        try {
            return this.createPropertyToken(this.start, this.cursor);
        }
        catch (NumberFormatException e) {
            c = new CompileException("badly formatted number: " + e.getMessage(), this.expr, this.cursor, e);
            c.setLineNumber(this.line);
            c.setColumn(this.cursor - this.lastLineStart);
            throw c;
        }
        catch (StringIndexOutOfBoundsException e) {
            c = new CompileException("unexpected end of statement", this.expr, this.cursor, e);
            c.setLineNumber(this.line);
            c.setColumn(this.cursor - this.lastLineStart);
            throw c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            c = new CompileException("unexpected end of statement", this.expr, this.cursor, e);
            c.setLineNumber(this.line);
            c.setColumn(this.cursor - this.lastLineStart);
            throw c;
        }
        catch (CompileException e) {
            e.setExpr(this.expr);
            e.setLineNumber(this.pCtx == null ? 1 : this.pCtx.getLineCount());
            e.setCursor(this.cursor);
            e.setColumn(this.cursor - (this.pCtx == null ? 0 : this.pCtx.getLineOffset()));
            throw e;
        }
    }

    public ASTNode handleSubstatement(Substatement stmt) {
        if (stmt.getStatement() != null && stmt.getStatement().isLiteralOnly()) {
            return new LiteralNode(stmt.getStatement().getValue(null, null, null), this.pCtx);
        }
        return stmt;
    }

    protected ASTNode handleUnion(ASTNode node) {
        if (this.cursor != this.length) {
            this.skipWhitespace();
            int union = -1;
            switch (this.expr[this.cursor]) {
                case '.': {
                    union = this.cursor + 1;
                    break;
                }
                case '[': {
                    union = this.cursor;
                }
            }
            if (union != -1) {
                this.captureToEOT();
                this.lastNode = new Union(this.expr, union, this.cursor, this.fields, node);
                return this.lastNode;
            }
        }
        this.lastNode = node;
        return this.lastNode;
    }

    private ASTNode createOperator(char[] expr, int start, int end) {
        this.lastWasIdentifier = false;
        this.lastNode = new OperatorNode(OPERATORS.get(new String(expr, start, end - start)), this.pCtx);
        return this.lastNode;
    }

    private char[] subArray(int start, int end) {
        if (start >= end) {
            return new char[0];
        }
        char[] newA = new char[end - start];
        int i = 0;
        while (i != newA.length) {
            newA[i] = this.expr[i + start];
            ++i;
        }
        return newA;
    }

    private ASTNode createPropertyToken(int start, int end) {
        if (ArrayTools.isLiteralOnly(this.expr, start, end)) {
            String tmp;
            if (this.pCtx != null && this.pCtx.hasImports()) {
                char[] _subset = ParseTools.subset(this.expr, start, this.cursor - start);
                int offset = ArrayTools.findFirst('.', _subset);
                if (offset != -1) {
                    String iStr = new String(_subset, 0, offset);
                    if (this.pCtx.hasImport(iStr)) {
                        this.lastWasIdentifier = true;
                        this.lastNode = new LiteralDeepPropertyNode(ParseTools.subset(_subset, offset + 1, _subset.length - offset - 1), this.fields, this.pCtx.getImport(iStr), this.pCtx);
                        return this.lastNode;
                    }
                } else {
                    tmp = new String(_subset);
                    if (this.pCtx.hasImport(tmp)) {
                        this.lastWasIdentifier = true;
                        this.lastNode = new LiteralNode(this.pCtx.getStaticOrClassImport(tmp), this.pCtx);
                        return this.lastNode;
                    }
                }
            }
            if (LITERALS.containsKey(tmp = new String(this.expr, start, end - start))) {
                this.lastWasIdentifier = true;
                this.lastNode = new LiteralNode(LITERALS.get(tmp), this.pCtx);
                return this.lastNode;
            }
            if (OPERATORS.containsKey(tmp)) {
                this.lastWasIdentifier = false;
                this.lastNode = new OperatorNode(OPERATORS.get(tmp), this.pCtx);
                return this.lastNode;
            }
            if (this.lastWasIdentifier) {
                return this.procTypedNode(true);
            }
        }
        this.lastWasIdentifier = true;
        this.lastNode = new ASTNode(this.pCtx, this.expr, start, end, this.fields);
        return this.lastNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ASTNode procTypedNode(boolean decl) {
        while (true) {
            if (this.lastNode.getLiteralValue() instanceof String) {
                TypeDescriptor tDescr = new TypeDescriptor(((String)this.lastNode.getLiteralValue()).toCharArray(), 0, this.pCtx);
                try {
                    this.lastNode.setLiteralValue(TypeDescriptor.getClassReference(this.pCtx, tDescr));
                    this.lastNode.discard();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.lastNode.isLiteral() && this.lastNode.getLiteralValue() instanceof Class) {
                this.lastNode.discard();
                this.captureToEOS();
                if (decl) {
                    this.splitAccumulator.add(new DeclTypedVarNode(new String(this.expr, this.start, this.cursor - this.start), (Class)this.lastNode.getLiteralValue(), this.fields | 0x80, this.pCtx));
                } else {
                    this.captureToEOS();
                    this.splitAccumulator.add(new TypedVarNode(this.subArray(this.start, this.cursor), this.fields | 0x80, (Class)this.lastNode.getLiteralValue(), this.pCtx));
                }
            } else {
                if ((this.fields & 0x10) != 0) throw new CompileException("unknown class or illegal statement: " + this.lastNode.getLiteralValue(), this.expr, this.cursor);
                if (!(this.stk.peek() instanceof Class)) throw new CompileException("unknown class or illegal statement: " + this.lastNode.getLiteralValue(), this.expr, this.cursor);
                this.captureToEOS();
                if (decl) {
                    this.splitAccumulator.add(new DeclTypedVarNode(new String(this.expr, this.start, this.cursor - this.start), (Class)this.stk.pop(), this.fields | 0x80, this.pCtx));
                } else {
                    this.splitAccumulator.add(new TypedVarNode(this.subArray(this.start, this.cursor), this.fields | 0x80, (Class)this.stk.pop(), this.pCtx));
                }
            }
            this.skipWhitespace();
            if (this.cursor >= this.length || this.expr[this.cursor] != ',') return (ASTNode)this.splitAccumulator.pop();
            this.start = ++this.cursor;
            this.splitAccumulator.add(new EndOfStatement(this.pCtx));
        }
    }

    private ASTNode createBlockToken(int condStart, int condEnd, int blockStart, int blockEnd, int type) {
        this.lastWasIdentifier = false;
        ++this.cursor;
        if (this.isStatementNotManuallyTerminated()) {
            this.splitAccumulator.add(new EndOfStatement(this.pCtx));
        }
        switch (type) {
            case 2048: {
                return new IfNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields, this.pCtx);
            }
            case 262144: {
                int i = condStart;
                while (i < condEnd) {
                    if (this.expr[i] == ';') {
                        return new ForNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields, this.pCtx);
                    }
                    if (this.expr[i] == ':') break;
                    ++i;
                }
            }
            case 4096: {
                return new ForEachNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields, this.pCtx);
            }
            case 32768: {
                return new WhileNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields, this.pCtx);
            }
            case 16384: {
                return new UntilNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields, this.pCtx);
            }
            case 65536: {
                return new DoNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields, this.pCtx);
            }
            case 131072: {
                return new DoUntilNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.pCtx);
            }
        }
        return new WithNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields, this.pCtx);
    }

    private ASTNode captureCodeBlock(int type) {
        boolean cond = true;
        ASTNode first = null;
        ASTNode tk = null;
        switch (type) {
            case 2048: {
                do {
                    if (tk != null) {
                        this.captureToNextTokenJunction();
                        this.skipWhitespace();
                        boolean bl = cond = this.expr[this.cursor] != '{' && this.expr[this.cursor] == 'i' && this.expr[++this.cursor] == 'f' && this.expr[this.cursor = this.incNextNonBlank()] == '(';
                    }
                    if (((IfNode)(tk = this._captureBlock(tk, this.expr, cond, type))).getElseBlock() != null) {
                        ++this.cursor;
                        return first;
                    }
                    if (first == null) {
                        first = tk;
                    }
                    if (this.cursor == this.length || this.expr[this.cursor] == ';') continue;
                    ++this.cursor;
                } while (this.ifThenElseBlockContinues());
                return first;
            }
            case 65536: {
                this.skipWhitespace();
                return this._captureBlock(null, this.expr, false, type);
            }
        }
        this.captureToNextTokenJunction();
        this.skipWhitespace();
        return this._captureBlock(null, this.expr, true, type);
    }

    private ASTNode _captureBlock(ASTNode node, char[] expr, boolean cond, int type) {
        int blockEnd;
        int blockStart;
        this.skipWhitespace();
        int startCond = 0;
        int endCond = 0;
        switch (type) {
            case 100: {
                int start = this.cursor;
                this.captureToNextTokenJunction();
                if (this.cursor == this.length) {
                    throw new CompileException("unexpected end of statement", expr, start);
                }
                startCond = this.cursor;
                String name = ParseTools.createStringTrimmed(expr, start, startCond - start);
                if (ParseTools.isReservedWord(name) || ParseTools.isNotValidNameorLabel(name)) {
                    throw new CompileException("illegal function name or use of reserved word", expr, this.cursor);
                }
                FunctionParser parser = new FunctionParser(name, this.cursor, expr.length, expr, this.pCtx, this.splitAccumulator);
                Function function = parser.parse();
                this.cursor = parser.getCursor();
                this.lastNode = function;
                return this.lastNode;
            }
        }
        if (cond) {
            if (expr[this.cursor] != '(') {
                throw new CompileException("expected '(' but encountered: " + expr[this.cursor]);
            }
            startCond = this.cursor;
            this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, startCond, '(', this.pCtx);
            endCond = this.cursor++;
            ++startCond;
        }
        this.skipWhitespace();
        if (this.cursor >= this.length) {
            throw new CompileException("unexpected end of statement", expr, this.cursor);
        }
        if (expr[this.cursor] == '{') {
            blockStart = this.cursor;
            blockEnd = this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, blockStart, '{', this.pCtx);
        } else {
            blockStart = this.cursor - 1;
            this.captureToEOSorEOL();
            blockEnd = this.cursor + 1;
        }
        if (type == 2048) {
            IfNode ifNode = (IfNode)node;
            if (node != null) {
                if (!cond) {
                    return ifNode.setElseBlock(this.subArray(this.trimRight(blockStart + 1), this.trimLeft(blockEnd - 1)));
                }
                return ifNode.setElseIf((IfNode)this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), type));
            }
            return this.createBlockToken(startCond, endCond, blockStart + 1, blockEnd, type);
        }
        if (type == 65536) {
            ++this.cursor;
            this.skipWhitespace();
            this.start = this.cursor;
            this.captureToNextTokenJunction();
            String name = new String(expr, this.start, this.cursor - this.start);
            if ("while".equals(name)) {
                this.skipWhitespace();
                startCond = this.cursor + 1;
                endCond = this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, this.cursor, '(', this.pCtx);
                return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), type);
            }
            if ("until".equals(name)) {
                this.skipWhitespace();
                startCond = this.cursor + 1;
                endCond = this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, this.cursor, '(', this.pCtx);
                return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), 131072);
            }
            throw new CompileException("expected 'while' or 'until' but encountered: " + name, expr, this.cursor);
        }
        return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), type);
    }

    protected boolean ifThenElseBlockContinues() {
        if (this.cursor + 4 < this.length) {
            if (this.expr[this.cursor] != ';') {
                --this.cursor;
            }
            this.skipWhitespace();
            return this.expr[this.cursor] == 'e' && this.expr[this.cursor + 1] == 'l' && this.expr[this.cursor + 2] == 's' && this.expr[this.cursor + 3] == 'e' && (ParseTools.isWhitespace(this.expr[this.cursor + 4]) || this.expr[this.cursor + 4] == '{');
        }
        return false;
    }

    protected boolean tokenContinues() {
        if (this.cursor == this.length) {
            return false;
        }
        if (this.expr[this.cursor] == '.' || this.expr[this.cursor] == '[') {
            return true;
        }
        if (ParseTools.isWhitespace(this.expr[this.cursor])) {
            int markCurrent = this.cursor;
            this.skipWhitespace();
            if (this.cursor != this.length && (this.expr[this.cursor] == '.' || this.expr[this.cursor] == '[')) {
                return true;
            }
            this.cursor = markCurrent;
        }
        return false;
    }

    protected void expectEOS() {
        this.skipWhitespace();
        if (this.cursor != this.length && this.expr[this.cursor] != ';') {
            switch (this.expr[this.cursor]) {
                case '&': {
                    if (this.lookAhead() != '&') break;
                    return;
                }
                case '|': {
                    if (this.lookAhead() != '|') break;
                    return;
                }
                case '!': {
                    if (this.lookAhead() != '=') break;
                    return;
                }
                case '<': 
                case '>': {
                    return;
                }
                case '=': {
                    switch (this.lookAhead()) {
                        case '*': 
                        case '+': 
                        case '-': 
                        case '=': {
                            return;
                        }
                    }
                    break;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    if (this.lookAhead() != '=') break;
                    return;
                }
            }
            throw new CompileException("expected end of statement but encountered: " + (this.cursor == this.length ? "<end of stream>" : Character.valueOf(this.expr[this.cursor])), this.expr, this.cursor);
        }
    }

    protected boolean isNextIdentifier() {
        while (this.cursor != this.length && ParseTools.isWhitespace(this.expr[this.cursor])) {
            ++this.cursor;
        }
        return this.cursor != this.length && ParseTools.isIdentifierPart(this.expr[this.cursor]);
    }

    protected void captureToEOS() {
        while (this.cursor != this.length) {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.expr[this.cursor], this.pCtx);
                    if (this.cursor < this.length) break;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.cursor = ParseTools.captureStringLiteral(this.expr[this.cursor], this.expr, this.cursor, this.length);
                    break;
                }
                case ',': 
                case ';': 
                case '}': {
                    return;
                }
            }
            ++this.cursor;
        }
    }

    protected void captureToEOSorEOL() {
        while (this.cursor != this.length && this.expr[this.cursor] != '\n' && this.expr[this.cursor] != '\r' && this.expr[this.cursor] != ';') {
            ++this.cursor;
        }
    }

    protected void captureToEOL() {
        while (this.cursor != this.length && this.expr[this.cursor] != '\n') {
            ++this.cursor;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void captureIdentifier() {
        captured = false;
        if (this.cursor != this.length) ** GOTO lbl13
        throw new CompileException("unexpected end of statement: EOF", this.expr, this.cursor);
lbl-1000:
        // 1 sources

        {
            switch (this.expr[this.cursor]) {
                case ';': {
                    return;
                }
            }
            if (!ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                if (captured) {
                    return;
                }
                throw new CompileException("unexpected symbol (was expecting an identifier): " + this.expr[this.cursor], this.expr, this.cursor);
            }
            captured = true;
            ++this.cursor;
lbl13:
            // 2 sources

            ** while (this.cursor != this.length)
        }
lbl14:
        // 1 sources

    }

    protected void captureToEOT() {
        this.skipWhitespace();
        block7: do {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.expr[this.cursor], this.pCtx);
                    if (this.cursor != -1) continue block7;
                    throw new CompileException("unbalanced braces", this.expr, this.cursor);
                }
                case '&': 
                case ',': 
                case ';': 
                case '=': 
                case '|': {
                    return;
                }
                case '.': {
                    this.skipWhitespace();
                    break;
                }
                case '\'': {
                    this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length);
                    break;
                }
                case '\"': {
                    this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.length);
                    break;
                }
                default: {
                    if (!ParseTools.isWhitespace(this.expr[this.cursor])) continue block7;
                    this.skipWhitespace();
                    if (this.cursor < this.length && this.expr[this.cursor] == '.') {
                        if (this.cursor != this.length) {
                            ++this.cursor;
                        }
                        this.skipWhitespace();
                        break;
                    }
                    this.trimWhitespace();
                    return;
                }
            }
        } while (++this.cursor != this.length);
    }

    protected boolean lastNonWhite(char c) {
        int i = this.cursor - 1;
        while (ParseTools.isWhitespace(this.expr[i])) {
            --i;
        }
        return c == this.expr[i];
    }

    protected int trimLeft(int pos) {
        if (pos > this.length) {
            pos = this.length;
        }
        while (pos > 0 && pos >= this.start && ParseTools.isWhitespace(this.expr[pos - 1])) {
            --pos;
        }
        return pos;
    }

    protected int trimRight(int pos) {
        while (pos != this.length && ParseTools.isWhitespace(this.expr[pos])) {
            ++pos;
        }
        return pos;
    }

    protected void skipWhitespace() {
        block9: while (this.cursor != this.length) {
            block0 : switch (this.expr[this.cursor]) {
                case '\n': {
                    ++this.line;
                    this.lastLineStart = this.cursor;
                }
                case '\r': {
                    ++this.cursor;
                    break;
                }
                case '/': {
                    if (this.cursor + 1 != this.length) {
                        switch (this.expr[this.cursor + 1]) {
                            case '/': {
                                this.expr[this.cursor++] = 32;
                                while (this.cursor != this.length && this.expr[this.cursor] != '\n') {
                                    this.expr[this.cursor++] = 32;
                                }
                                if (this.cursor != this.length) {
                                    this.expr[this.cursor++] = 32;
                                }
                                ++this.line;
                                this.lastLineStart = this.cursor;
                                break block0;
                            }
                            case '*': {
                                int len = this.length - 1;
                                this.expr[this.cursor++] = 32;
                                while (this.cursor != len && (this.expr[this.cursor] != '*' || this.expr[this.cursor + 1] != '/')) {
                                    if (this.expr[this.cursor] == '\n') {
                                        ++this.line;
                                        this.lastLineStart = this.cursor;
                                    }
                                    this.expr[this.cursor++] = 32;
                                }
                                if (this.cursor == len) continue block9;
                                this.expr[this.cursor++] = 32;
                                this.expr[this.cursor++] = 32;
                                break block0;
                            }
                        }
                        break block9;
                    }
                }
                default: {
                    if (!ParseTools.isWhitespace(this.expr[this.cursor])) break block9;
                    ++this.cursor;
                }
            }
        }
    }

    protected void captureToNextTokenJunction() {
        while (this.cursor != this.length) {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '{': {
                    return;
                }
                case '[': {
                    this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, '[', this.pCtx) + 1;
                    break;
                }
                default: {
                    if (ParseTools.isWhitespace(this.expr[this.cursor])) {
                        return;
                    }
                    ++this.cursor;
                }
            }
        }
    }

    protected void trimWhitespace() {
        while (this.cursor != 0 && ParseTools.isWhitespace(this.expr[this.cursor - 1])) {
            --this.cursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpression(String expression) {
        if (expression != null && expression.length() != 0) {
            WeakHashMap<String, char[]> weakHashMap = EX_PRECACHE;
            synchronized (weakHashMap) {
                this.expr = EX_PRECACHE.get(expression);
                if (this.expr == null) {
                    this.expr = expression.toCharArray();
                    this.length = this.expr.length;
                    while (this.length != 0 && ParseTools.isWhitespace(this.expr[this.length - 1])) {
                        --this.length;
                    }
                    char[] e = new char[this.length];
                    int i = 0;
                    while (i != e.length) {
                        e[i] = this.expr[i];
                        ++i;
                    }
                    EX_PRECACHE.put(expression, e);
                } else {
                    this.length = this.expr.length;
                }
            }
        }
    }

    protected void setExpression(char[] expression) {
        this.expr = expression;
        this.length = expression.length;
        while (this.length != 0 && ParseTools.isWhitespace(this.expr[this.length - 1])) {
            --this.length;
        }
    }

    protected char lookToLast() {
        if (this.cursor == 0) {
            return '\u0000';
        }
        int temp = this.cursor;
        while (temp != 0 && ParseTools.isWhitespace(this.expr[--temp])) {
        }
        return this.expr[temp];
    }

    protected char lookBehind() {
        if (this.cursor == 0) {
            return '\u0000';
        }
        return this.expr[this.cursor - 1];
    }

    protected char lookAhead() {
        if (this.cursor + 1 < this.length) {
            return this.expr[this.cursor + 1];
        }
        return '\u0000';
    }

    protected char lookAhead(int range) {
        if (this.cursor + range >= this.length) {
            return '\u0000';
        }
        return this.expr[this.cursor + range];
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isNextIdentifierOrLiteral() {
        tmp = this.cursor;
        if (tmp != this.length) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            ++tmp;
lbl5:
            // 2 sources

            ** while (tmp != this.length && ParseTools.isWhitespace((char)this.expr[tmp]))
        }
lbl6:
        // 1 sources

        if (tmp == this.length) {
            return false;
        }
        n = this.expr[tmp];
        return ParseTools.isIdentifierPart(n) != false || ParseTools.isDigit(n) != false || n == '\'' || n == '\"';
    }

    public int incNextNonBlank() {
        ++this.cursor;
        return this.nextNonBlank();
    }

    public int nextNonBlank() {
        if (this.cursor + 1 >= this.length) {
            throw new CompileException("unexpected end of statement", this.expr, this.cursor);
        }
        int i = this.cursor;
        while (i != this.length && ParseTools.isWhitespace(this.expr[i])) {
            ++i;
        }
        return i;
    }

    public void expectNextChar_IW(char c) {
        this.nextNonBlank();
        if (this.cursor == this.length) {
            throw new CompileException("unexpected end of statement", this.expr, this.cursor);
        }
        if (this.expr[this.cursor] != c) {
            throw new CompileException("unexpected character ('" + this.expr[this.cursor] + "'); was expecting: " + c);
        }
    }

    protected boolean isStatementNotManuallyTerminated() {
        if (this.cursor >= this.length) {
            return false;
        }
        int c = this.cursor;
        while (c != this.length && ParseTools.isWhitespace(this.expr[c])) {
            ++c;
        }
        return c == this.length || this.expr[c] != ';';
    }

    protected void addFatalError(String message) {
        this.pCtx.addError(new ErrorDetail(this.pCtx.getLineCount(), this.cursor - this.pCtx.getLineOffset(), true, message));
    }

    protected void addFatalError(String message, int row, int cols) {
        this.pCtx.addError(new ErrorDetail(row, cols, true, message));
    }

    protected void addWarning(String message) {
        this.pCtx.addError(new ErrorDetail(message, false));
    }

    public static void setLanguageLevel(int level) {
        OPERATORS.clear();
        OPERATORS.putAll(AbstractParser.loadLanguageFeaturesByLevel(level));
    }

    public static HashMap<String, Integer> loadLanguageFeaturesByLevel(int languageLevel) {
        HashMap<String, Integer> operatorsTable = new HashMap<String, Integer>();
        switch (languageLevel) {
            case 5: {
                operatorsTable.put("if", 39);
                operatorsTable.put("else", 40);
                operatorsTable.put("?", 29);
                operatorsTable.put("switch", 44);
                operatorsTable.put("function", 100);
                operatorsTable.put("def", 100);
            }
            case 4: {
                operatorsTable.put("=", 31);
                operatorsTable.put("var", 98);
                operatorsTable.put("+=", 52);
                operatorsTable.put("-=", 53);
                operatorsTable.put("/=", 55);
                operatorsTable.put("%=", 56);
            }
            case 3: {
                operatorsTable.put("foreach", 38);
                operatorsTable.put("while", 41);
                operatorsTable.put("until", 42);
                operatorsTable.put("for", 43);
                operatorsTable.put("do", 45);
            }
            case 2: {
                operatorsTable.put("return", 99);
                operatorsTable.put(";", 37);
            }
            case 1: {
                operatorsTable.put("+", 0);
                operatorsTable.put("-", 1);
                operatorsTable.put("*", 2);
                operatorsTable.put("**", 5);
                operatorsTable.put("/", 3);
                operatorsTable.put("%", 4);
                operatorsTable.put("==", 18);
                operatorsTable.put("!=", 19);
                operatorsTable.put(">", 15);
                operatorsTable.put(">=", 17);
                operatorsTable.put("<", 14);
                operatorsTable.put("<=", 16);
                operatorsTable.put("&&", 21);
                operatorsTable.put("and", 21);
                operatorsTable.put("||", 22);
                operatorsTable.put("or", 23);
                operatorsTable.put("~=", 24);
                operatorsTable.put("instanceof", 25);
                operatorsTable.put("is", 25);
                operatorsTable.put("contains", 26);
                operatorsTable.put("soundslike", 27);
                operatorsTable.put("strsim", 28);
                operatorsTable.put("convertable_to", 36);
                operatorsTable.put("isdef", 47);
                operatorsTable.put("#", 20);
                operatorsTable.put("&", 6);
                operatorsTable.put("|", 7);
                operatorsTable.put("^", 8);
                operatorsTable.put("<<", 10);
                operatorsTable.put("<<<", 12);
                operatorsTable.put(">>", 9);
                operatorsTable.put(">>>", 11);
                operatorsTable.put("new", 34);
                operatorsTable.put("in", 35);
                operatorsTable.put("with", 46);
                operatorsTable.put("assert", 97);
                operatorsTable.put("import", 96);
                operatorsTable.put("import_static", 95);
                operatorsTable.put("++", 50);
                operatorsTable.put("--", 51);
            }
            case 0: {
                operatorsTable.put(":", 30);
            }
        }
        return operatorsTable;
    }

    protected static boolean isArithmeticOperator(int operator) {
        return operator != -1 && operator < 6;
    }

    /*
     * Unable to fully structure code
     */
    protected int arithmeticFunctionReduction(int operator) {
        block17: {
            block18: {
                tk = this.nextToken();
                if (tk == null) break block17;
                operator2 = tk.getOperator();
                if (!AbstractParser.isArithmeticOperator(operator2) || Operator.PTABLE[operator2] <= Operator.PTABLE[operator]) break block18;
                this.stk.xswap();
                tk = this.nextToken();
                if (this.compileMode && !tk.isLiteral()) {
                    this.splitAccumulator.push(tk);
                    this.splitAccumulator.push(new OperatorNode(operator2, this.pCtx));
                    return tk instanceof Substatement != false ? -2 : -1;
                }
                operator = operator2;
                this.dStack.push(operator, tk.getReducedValue(this.ctx, this.ctx, this.variableFactory));
                while (true) {
                    block21: {
                        block19: {
                            block20: {
                                if ((tk = this.nextToken()) != null && (operator2 = tk.getOperator().intValue()) != -1 && operator2 != 37 && Operator.PTABLE[operator2] > Operator.PTABLE[operator]) {
                                    if (this.dStack.isReduceable()) {
                                        this.stk.copyx2(this.dStack);
                                    }
                                    operator = operator2;
                                    this.dStack.push(operator, this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory));
                                    continue;
                                }
                                if (tk == null || operator2 == -1 || operator2 == 37) break block19;
                                if (Operator.PTABLE[operator2] != Operator.PTABLE[operator]) ** GOTO lbl32
                                if (this.dStack.isEmpty()) ** GOTO lbl26
                                this.dreduce();
                                break block20;
lbl-1000:
                                // 1 sources

                                {
                                    this.stk.xswap_op();
lbl26:
                                    // 2 sources

                                    ** while (this.stk.isReduceable())
                                }
                            }
                            operator = operator2;
                            this.dStack.push(operator, this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory));
                            continue;
lbl-1000:
                            // 1 sources

                            {
                                this.dreduce();
lbl32:
                                // 2 sources

                                ** while (this.dStack.size() > 1)
                            }
lbl33:
                            // 1 sources

                            operator = tk.getOperator();
                            while (this.stk.size() != 1 && this.stk.peek2() instanceof Integer && (operator2 = ((Integer)this.stk.peek2()).intValue()) < Operator.PTABLE.length && Operator.PTABLE[operator2] >= Operator.PTABLE[operator]) {
                                this.stk.xswap_op();
                            }
                            break block21;
                        }
                        if (this.dStack.size() > 1) {
                            this.dreduce();
                        }
                        if (this.stk.isReduceable()) {
                            this.stk.xswap();
                        }
                        break block17;
                    }
                    tk = this.nextToken();
                    if (tk == null) continue;
                    switch (operator) {
                        case 21: {
                            if (!this.stk.peekBoolean().booleanValue()) {
                                return -1;
                            }
                            this.splitAccumulator.add(tk);
                            return 21;
                        }
                        case 22: {
                            if (this.stk.peekBoolean().booleanValue()) {
                                return -1;
                            }
                            this.splitAccumulator.add(tk);
                            return 22;
                        }
                    }
                    this.stk.push(operator, tk.getReducedValue(this.ctx, this.ctx, this.variableFactory));
                }
            }
            if (!tk.isOperator()) {
                throw new CompileException("unexpected token: " + tk.getName());
            }
            this.reduce();
            this.splitAccumulator.push(tk);
        }
        while (this.stk.isReduceable()) {
            this.reduce();
            if (!this.stk.isReduceable()) continue;
            this.stk.xswap();
        }
        return 0;
    }

    private void dreduce() {
        this.stk.copy2(this.dStack);
        this.stk.op();
    }

    protected void reduce() {
        try {
            int operator = (Integer)this.stk.pop();
            switch (operator) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.stk.op(operator);
                    break;
                }
                case 21: {
                    Object v1 = this.stk.pop();
                    this.stk.push((Boolean)this.stk.pop() != false && (Boolean)v1 != false);
                    break;
                }
                case 22: {
                    Object v1 = this.stk.pop();
                    this.stk.push((Boolean)this.stk.pop() != false || (Boolean)v1 != false);
                    break;
                }
                case 23: {
                    Object v1 = this.stk.pop();
                    Object v2 = this.stk.pop();
                    if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                        this.stk.clear();
                        this.stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                        return;
                    }
                    this.stk.push(null);
                    break;
                }
                case 24: {
                    this.stk.push(Pattern.compile(String.valueOf(this.stk.pop())).matcher(String.valueOf(this.stk.pop())).matches());
                    break;
                }
                case 25: {
                    this.stk.push(((Class)this.stk.pop()).isInstance(this.stk.pop()));
                    break;
                }
                case 36: {
                    this.stk.push(DataConversion.canConvert(this.stk.peek2().getClass(), (Class)this.stk.pop2()));
                    break;
                }
                case 26: {
                    this.stk.push(ParseTools.containsCheck(this.stk.peek2(), this.stk.pop2()));
                    break;
                }
                case 6: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) & AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 7: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) | AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 8: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) ^ AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 10: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) << AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 12: {
                    int iv2 = AbstractParser.asInt(this.stk.peek2());
                    if (iv2 < 0) {
                        iv2 *= -1;
                    }
                    this.stk.push(iv2 << AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 9: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) >> AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 11: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) >>> AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 27: {
                    this.stk.push(Soundex.soundex(String.valueOf(this.stk.pop())).equals(Soundex.soundex(String.valueOf(this.stk.pop()))));
                    break;
                }
                case 28: {
                    this.stk.push(Float.valueOf(ParseTools.similarity(String.valueOf(this.stk.pop()), String.valueOf(this.stk.pop()))));
                }
            }
        }
        catch (ClassCastException e) {
            throw new CompileException("syntax error or incompatable types", this.expr, this.cursor, e);
        }
        catch (ArithmeticException e) {
            throw new CompileException("arithmetic error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CompileException("failed to subEval expression", e);
        }
    }

    private static int asInt(Object o) {
        return (Integer)o;
    }

    public ParserContext getPCtx() {
        return this.pCtx;
    }
}

