/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.extdoc.rcp.providers;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProviderDescription;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.swt.widgets.Display;

public abstract class ExtdocProvider {
    private boolean isEnabled = true;
    private ExtdocProviderDescription description;

    public final void setDescription(ExtdocProviderDescription description) {
        this.description = description;
    }

    public ExtdocProviderDescription getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    protected final void runSyncInUiThread(final Runnable runnable) {
        final ExceptionHandler handler = new ExceptionHandler();
        final CountDownLatch latch = new CountDownLatch(1);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                    latch.countDown();
                }
                catch (Exception e) {
                    handler.setException(e);
                }
            }
        });
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {}
        handler.throwExceptionIfExistent();
    }

    public String getId() {
        return this.getClass().getName();
    }

    private static class ExceptionHandler {
        private Exception e;

        private ExceptionHandler() {
        }

        private void setException(Exception e) {
            this.e = e;
        }

        private void throwExceptionIfExistent() {
            if (this.e != null) {
                Throws.throwUnhandledException((Exception)this.e);
            }
        }
    }

    @Deprecated
    public static enum Status {
        OK,
        NOT_AVAILABLE;

    }
}

