/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.ui;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.extdoc.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.SourceCodeArea;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.Names;
import org.eclipse.recommenders.utils.TreeBag;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class ExtdocUtils {
    static final Font CODEFONT = JFaceResources.getTextFont();
    private static final Font BOLDFONT = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
    private static final Map<Integer, Color> COLORCACHE = new HashMap<Integer, Color>();

    private ExtdocUtils() {
    }

    public static void disposeChildren(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    public static void setInfoBackgroundColor(Control c) {
        Display display = c.getDisplay();
        Color color = display.getSystemColor(29);
        c.setBackground(color);
    }

    public static void setInfoForegroundColor(Control c) {
        Display display = c.getDisplay();
        Color color = display.getSystemColor(28);
        c.setForeground(color);
    }

    public static Composite createGridComposite(Composite parent, int columns, int hSpacing, int vSpacing, int hMargin, int vMargin) {
        Composite composite = new Composite(parent, 0);
        ExtdocUtils.setInfoBackgroundColor((Control)composite);
        GridLayout layout = GridLayoutFactory.swtDefaults().numColumns(columns).margins(hMargin, vMargin).spacing(hSpacing, vSpacing).create();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        return composite;
    }

    static void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
    }

    public static Table renderMethodDirectivesBlock(Composite parent, TreeBag<IMethodName> methods, int total, EventBus bus, JavaElementResolver resolver, String middlePhrase) {
        Table table = new Table(parent, 32768);
        table.setBackground(ExtdocUtils.createColor(29));
        table.setForeground(ExtdocUtils.createColor(28));
        table.setLayoutData((Object)GridDataFactory.fillDefaults().indent(10, 0).create());
        TableColumn column1 = new TableColumn(table, 0);
        TableColumn column2 = new TableColumn(table, 0);
        TableColumn column3 = new TableColumn(table, 0);
        TableColumn column4 = new TableColumn(table, 0);
        for (IMethodName method : methods.elementsOrderedByFrequency()) {
            int frequency = methods.count((Object)method);
            int percentage = (int)Math.round((double)frequency * 100.0 / (double)total);
            if ((double)percentage < 5.0) continue;
            String phraseText = ExtdocUtils.percentageToRecommendationPhrase(percentage);
            String stats = String.format(Messages.EXTDOC_PERCENTAGE_TIMES, percentage, frequency);
            Link bar = ExtdocUtils.createMethodLink((Composite)table, method, resolver, bus);
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{phraseText, middlePhrase, bar.getText(), stats});
            ExtdocUtils.bold(item, 0);
            TableEditor editor = new TableEditor(table);
            editor.grabVertical = true;
            editor.grabHorizontal = true;
            editor.setEditor((Control)bar, item, 2);
        }
        column1.pack();
        column2.pack();
        column3.pack();
        column4.pack();
        return table;
    }

    public static Link createMethodLink(Composite parent, final IMethod method, final EventBus workspaceBus) {
        String text = "<a>" + JavaElementLabels.getElementLabel((IJavaElement)method, (long)33L) + "</a>";
        String tooltip = JavaElementLabels.getElementLabel((IJavaElement)method, (long)JavaElementLabels.DEFAULT_QUALIFIED);
        Link link = new Link(parent, 0);
        link.setText(text);
        link.setBackground(ExtdocUtils.createColor(29));
        link.setToolTipText(tooltip);
        link.setFont(JFaceResources.getDialogFont());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSelectionEvent event = new JavaSelectionEvent((IJavaElement)method, JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION);
                workspaceBus.post((Object)event);
            }
        });
        return link;
    }

    public static Link createMethodLink(Composite parent, final IMethodName method, final JavaElementResolver resolver, final EventBus workspaceBus) {
        String text = "<a>" + Names.vm2srcSimpleMethod((IMethodName)method) + "</a>";
        String tooltip = Names.vm2srcQualifiedMethod((IMethodName)method);
        final Link link = new Link(parent, 0);
        link.setText(text);
        link.setBackground(ExtdocUtils.createColor(29));
        link.setFont(JFaceResources.getDialogFont());
        link.setToolTipText(tooltip);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Optional opt = resolver.toJdtMethod(method);
                if (opt.isPresent()) {
                    JavaSelectionEvent event = new JavaSelectionEvent((IJavaElement)opt.get(), JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION);
                    workspaceBus.post((Object)event);
                } else {
                    link.setEnabled(false);
                }
            }
        });
        return link;
    }

    public static Label createLabel(Composite parent, String text, boolean wrap) {
        return ExtdocUtils.createLabel(parent, text, false, false, 28, wrap);
    }

    public static Label createLabel(Composite parent, String text, boolean bold, boolean code, int color, boolean wrap) {
        Label label = new Label(parent, 64);
        label.setText(text);
        ExtdocUtils.setInfoBackgroundColor((Control)label);
        if (code) {
            label.setFont(CODEFONT);
        } else if (bold) {
            label.setFont(BOLDFONT);
        }
        label.setForeground(ExtdocUtils.createColor(color));
        if (wrap) {
            label.setLayoutData((Object)new GridData(4, 128, true, false));
        }
        return label;
    }

    public static CLabel createCLabel(Composite parent, String text, boolean bold, Image image) {
        CLabel label = new CLabel(parent, 0);
        ExtdocUtils.setInfoBackgroundColor((Control)label);
        label.setText(text);
        if (bold) {
            label.setFont(BOLDFONT);
        }
        label.setImage(image);
        return label;
    }

    public static Text createText(Composite parent, String text, int width) {
        Text textComponent = new Text(parent, 2052);
        textComponent.setText(text);
        GridData gridData = new GridData(4, 128, false, false);
        gridData.widthHint = width;
        textComponent.setLayoutData((Object)gridData);
        return textComponent;
    }

    public static Text createTextArea(Composite parent, String text, int height, int width) {
        Text textComponent = new Text(parent, 2626);
        textComponent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(width, height).create());
        textComponent.setText(text);
        return textComponent;
    }

    public static StyledText createStyledText(Composite parent, String text, int color, boolean grabExcessHorizontalSpace) {
        StyledText styledText = new StyledText(parent, 64);
        styledText.setEnabled(false);
        styledText.setDoubleClickEnabled(false);
        styledText.setLayoutData((Object)new GridData(4, 0x1000000, grabExcessHorizontalSpace, false));
        styledText.setEditable(false);
        styledText.setText(text);
        styledText.setForeground(ExtdocUtils.createColor(color));
        return styledText;
    }

    public static void createStyleRange(StyledText styledText, int start, int length, int fontStyle, boolean makeBlue, boolean makeCodeFont) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = length;
        styleRange.fontStyle = fontStyle;
        if (makeBlue) {
            styleRange.foreground = ExtdocUtils.createColor(9);
        }
        if (makeCodeFont) {
            styleRange.font = CODEFONT;
        }
        styledText.setStyleRange(styleRange);
    }

    public static StyleRange createStyleRange(int start, int length, int fontStyle, boolean makeBlue, boolean makeCodeFont) {
        StyleRange range = new StyleRange();
        range.start = start;
        range.length = length;
        range.fontStyle = fontStyle;
        if (makeBlue) {
            range.foreground = ExtdocUtils.createColor(9);
        }
        if (makeCodeFont) {
            range.font = CODEFONT;
        }
        return range;
    }

    public static Font bold(Font src, Display d) {
        FontData[] fD = src.getFontData();
        fD[0].setStyle(1);
        return new Font((Device)d, fD[0]);
    }

    public static void bold(TableItem item, int index) {
        item.setFont(index, ExtdocUtils.bold(item.getFont(), item.getDisplay()));
    }

    public static void bold(Control item) {
        item.setFont(ExtdocUtils.bold(item.getFont(), item.getDisplay()));
    }

    public static CLabel createLink(Composite parent, String text, String tooltip, Image image, boolean blueColor, MouseListener listener) {
        final CLabel link = new CLabel(parent, 0);
        link.setText(text);
        if (tooltip != null) {
            link.setToolTipText(tooltip);
        }
        if (blueColor) {
            link.setForeground(ExtdocUtils.createColor(9));
        }
        link.setImage(image);
        link.addMouseListener(listener);
        link.setCursor(new Cursor((Device)parent.getDisplay(), 21));
        if (blueColor) {
            link.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent event) {
                    link.setForeground(ExtdocUtils.createColor(9));
                }

                public void mouseEnter(MouseEvent event) {
                    link.setForeground(ExtdocUtils.createColor(10));
                }
            });
        }
        return link;
    }

    public static String percentageToRecommendationPhrase(int percentage) {
        if (percentage >= 95) {
            return Messages.EXTDOC_ALWAYS;
        }
        if (percentage >= 65) {
            return Messages.EXTDOC_USUALLY;
        }
        if (percentage >= 25) {
            return Messages.EXTDOC_SOMETIMES;
        }
        if (percentage >= 10) {
            return Messages.EXTDOC_OCCASIONALLY;
        }
        return Messages.EXTDOC_RARELY;
    }

    public static SourceCodeArea createSourceCodeArea(Composite parent, String snippet) {
        SourceCodeArea area = new SourceCodeArea(parent);
        area.setCode(snippet);
        return area;
    }

    public static Button createButton(Composite parent, String text, SelectionListener selectionListener) {
        Button button = new Button(parent, 0);
        button.setText(text);
        button.addSelectionListener(selectionListener);
        return button;
    }

    public static Color createColor(int swtColor) {
        Integer color = swtColor;
        if (!COLORCACHE.containsKey(color)) {
            COLORCACHE.put(color, Display.getCurrent().getSystemColor(swtColor));
        }
        return COLORCACHE.get(color);
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        Composite container = new Composite(parent, 0);
        ExtdocUtils.setInfoBackgroundColor((Control)container);
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 0).spacing(0, 0).numColumns(numColumns).create());
        container.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        return container;
    }
}

