/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.injection;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.recommenders.internal.injection.InjectionDescriptor;

public final class InjectionService {
    private static InjectionService instance = new InjectionService(1);
    private Injector lazyInjector;
    ReentrantLock lock = new ReentrantLock();

    public static InjectionService getInstance() {
        return instance;
    }

    private InjectionService(int blockDI) {
    }

    public synchronized Injector getInjector() {
        if (this.lock.isLocked()) {
            throw new IllegalStateException("reentrant access during injector creation is prohibited! Check your plug-in startup behavior");
        }
        try {
            this.lock.lock();
            if (this.lazyInjector == null) {
                List<Module> modules = InjectionDescriptor.createModules();
                this.lazyInjector = Guice.createInjector(modules);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.lazyInjector;
    }

    public void injectMembers(Object obj) {
        this.getInjector().injectMembers(obj);
    }

    public <T> T requestInstance(Class<T> clazz) {
        return (T)this.getInjector().getInstance(clazz);
    }
}

