/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RemoteSelectionCombo;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySelectionPage
extends WizardPage
implements IRepositorySearchResult {
    private static final String EMPTY_STRING = "";
    private static final String USED_URIS_PREF = "RepositorySelectionPage.UsedUris";
    private final List<RemoteConfig> configuredRemotes;
    private final boolean sourceSelection;
    private final String presetUri;
    private Group authGroup;
    private Text uriText;
    private Text hostText;
    private Text pathText;
    private Text userText;
    private Text passText;
    private Button storeCheckbox;
    private Combo scheme;
    private Text portText;
    private int eventDepth;
    private URIish uri = new URIish();
    private RemoteConfig remoteConfig;
    private RepositorySelection selection;
    private Composite remotePanel;
    private Button remoteButton;
    private RemoteSelectionCombo remoteCombo;
    private Composite uriPanel;
    private Button uriButton;
    private UIUtils.IPreviousValueProposalHandler uriProposalHandler;
    private String user = "";
    private String password = "";
    private boolean storeInSecureStore;
    private String helpContext = null;

    public RepositorySelectionPage(boolean sourceSelection, List<RemoteConfig> configuredRemotes, String presetUri) {
        super(RepositorySelectionPage.class.getName());
        this.sourceSelection = sourceSelection;
        String preset = presetUri;
        if (presetUri == null) {
            Clipboard clippy = new Clipboard(Display.getCurrent());
            String text = (String)clippy.getContents((Transfer)TextTransfer.getInstance());
            try {
                if (text != null) {
                    URIish u;
                    int index = (text = text.trim()).indexOf(32);
                    if (index > 0) {
                        text = text.substring(0, index);
                    }
                    if (this.canHandleProtocol(u = new URIish(text)) && (Protocol.GIT.handles(u) || Protocol.SSH.handles(u) || text.endsWith(".git"))) {
                        preset = text;
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            clippy.dispose();
        }
        this.presetUri = preset;
        this.configuredRemotes = this.getUsableConfigs(configuredRemotes);
        this.selection = RepositorySelection.INVALID_SELECTION;
        if (sourceSelection) {
            this.setTitle(UIText.RepositorySelectionPage_sourceSelectionTitle);
            this.setDescription(UIText.RepositorySelectionPage_sourceSelectionDescription);
        } else {
            this.setTitle(UIText.RepositorySelectionPage_destinationSelectionTitle);
            this.setDescription(UIText.RepositorySelectionPage_destinationSelectionDescription);
        }
        this.storeInSecureStore = this.getPreferenceStore().getBoolean("CloneWizard_StoreInSecureStore");
    }

    public RepositorySelectionPage(boolean sourceSelection, String presetUri) {
        this(sourceSelection, null, presetUri);
    }

    public RepositorySelectionPage() {
        this(true, null);
    }

    public RepositorySelection getSelection() {
        return this.selection;
    }

    public boolean selectionEquals(RepositorySelection s) {
        return this.selection.equals(s);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        if (this.configuredRemotes != null) {
            this.createRemotePanel(panel);
        } else {
            this.createRemoteNamePanel(panel);
        }
        this.createUriPanel(panel);
        if (this.presetUri != null) {
            this.updateFields(this.presetUri);
        }
        this.updateRemoteAndURIPanels();
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
        this.checkPage();
    }

    private boolean canHandleProtocol(URIish u) {
        for (TransportProtocol proto : Transport.getTransportProtocols()) {
            if (!proto.canHandle(u)) continue;
            return true;
        }
        return false;
    }

    private void createRemotePanel(Composite parent) {
        this.remoteButton = new Button(parent, 16);
        this.remoteButton.setText(String.valueOf(UIText.RepositorySelectionPage_configuredRemoteChoice) + ":");
        this.remoteButton.setSelection(true);
        this.remotePanel = new Composite(parent, 0);
        this.remotePanel.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.remotePanel.setLayoutData((Object)gd);
        RemoteSelectionCombo.SelectionType selectionType = this.sourceSelection ? RemoteSelectionCombo.SelectionType.FETCH : RemoteSelectionCombo.SelectionType.PUSH;
        this.remoteCombo = new RemoteSelectionCombo(this.remotePanel, 0, selectionType);
        this.remoteConfig = this.remoteCombo.setItems(this.configuredRemotes);
        this.remoteCombo.addRemoteSelectionListener(new RemoteSelectionCombo.IRemoteSelectionListener(){

            public void remoteSelected(RemoteConfig rc) {
                RepositorySelectionPage.this.remoteConfig = rc;
                RepositorySelectionPage.this.checkPage();
            }
        });
    }

    protected void createRemoteNamePanel(Composite panel) {
    }

    private void createUriPanel(Composite parent) {
        if (this.configuredRemotes != null) {
            this.uriButton = new Button(parent, 16);
            this.uriButton.setText(String.valueOf(UIText.RepositorySelectionPage_uriChoice) + ":");
            this.uriButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositorySelectionPage.this.updateRemoteAndURIPanels();
                    RepositorySelectionPage.this.checkPage();
                }
            });
        }
        this.uriPanel = new Composite(parent, 0);
        this.uriPanel.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.uriPanel.setLayoutData((Object)gd);
        this.createLocationGroup(this.uriPanel);
        this.createConnectionGroup(this.uriPanel);
        this.authGroup = this.createAuthenticationGroup(this.uriPanel);
    }

    private void createLocationGroup(Composite parent) {
        Group g = this.createGroup(parent, UIText.RepositorySelectionPage_groupLocation);
        g.setLayout((Layout)new GridLayout(3, false));
        this.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptURI) + ":");
        this.uriText = new Text((Composite)g, 2048);
        if (this.presetUri != null) {
            this.uriText.setText(this.presetUri);
            this.uriText.selectAll();
        }
        this.uriText.setLayoutData((Object)this.createFieldGridData());
        this.uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.updateFields(RepositorySelectionPage.this.uriText.getText());
            }
        });
        this.uriProposalHandler = UIUtils.addPreviousValuesContentProposalToText(this.uriText, USED_URIS_PREF);
        Button browseButton = new Button((Composite)g, 0);
        browseButton.setText(UIText.RepositorySelectionPage_BrowseLocalFile);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String result;
                DirectoryDialog dialog = new DirectoryDialog(RepositorySelectionPage.this.getShell());
                if (!RepositorySelectionPage.this.uriText.getText().equals(RepositorySelectionPage.EMPTY_STRING)) {
                    try {
                        File testFile = new File(RepositorySelectionPage.this.uriText.getText());
                        if (testFile.exists()) {
                            dialog.setFilterPath(testFile.getPath());
                        } else {
                            URIish testUri = new URIish(RepositorySelectionPage.this.uriText.getText());
                            if (testUri.getScheme().equals(Protocol.FILE.defaultScheme) && (testFile = new File(RepositorySelectionPage.this.uri.getPath())).exists()) {
                                dialog.setFilterPath(testFile.getPath());
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                if (RepositorySelectionPage.EMPTY_STRING.equals(dialog.getFilterPath())) {
                    dialog.setFilterPath(UIUtils.getDefaultRepositoryDir());
                }
                if ((result = dialog.open()) != null) {
                    RepositorySelectionPage.this.uriText.setText("file:///" + result);
                }
            }
        });
        this.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptHost) + ":");
        this.hostText = new Text((Composite)g, 2048);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.hostText);
        this.hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setHost(RepositorySelectionPage.this.nullString(RepositorySelectionPage.this.hostText.getText())));
            }
        });
        this.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptPath) + ":");
        this.pathText = new Text((Composite)g, 2048);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.pathText);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setPath(RepositorySelectionPage.this.nullString(RepositorySelectionPage.this.pathText.getText())));
            }
        });
    }

    private Group createAuthenticationGroup(Composite parent) {
        Group g = this.createGroup(parent, UIText.RepositorySelectionPage_groupAuthentication);
        this.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptUser) + ":");
        this.userText = new Text((Composite)g, 2048);
        this.userText.setLayoutData((Object)this.createFieldGridData());
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Protocol protocol = RepositorySelectionPage.this.getProtocol();
                if (protocol != Protocol.HTTP && protocol != Protocol.HTTPS) {
                    RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setUser(RepositorySelectionPage.this.nullString(RepositorySelectionPage.this.userText.getText())));
                }
                RepositorySelectionPage.this.user = RepositorySelectionPage.this.userText.getText();
            }
        });
        this.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptPassword) + ":");
        this.passText = new Text((Composite)g, 0x400800);
        this.passText.setLayoutData((Object)this.createFieldGridData());
        this.passText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setPass(null));
                RepositorySelectionPage.this.password = RepositorySelectionPage.this.passText.getText();
            }
        });
        this.newLabel(g, UIText.RepositorySelectionPage_storeInSecureStore);
        this.storeCheckbox = new Button((Composite)g, 32);
        this.storeCheckbox.setSelection(this.storeInSecureStore);
        this.storeCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionPage.this.storeInSecureStore = RepositorySelectionPage.this.storeCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RepositorySelectionPage.this.storeInSecureStore = RepositorySelectionPage.this.storeCheckbox.getSelection();
            }
        });
        return g;
    }

    private void createConnectionGroup(Composite parent) {
        Group g = this.createGroup(parent, UIText.RepositorySelectionPage_groupConnection);
        this.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptScheme) + ":");
        this.scheme = new Combo((Composite)g, 12);
        Protocol[] protocolArray = Protocol.values();
        int n = protocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            Protocol p = protocolArray[n2];
            this.scheme.add(p.getDefaultScheme());
            ++n2;
        }
        this.scheme.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = RepositorySelectionPage.this.scheme.getSelectionIndex();
                if (idx < 0) {
                    RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setScheme(null));
                    RepositorySelectionPage.this.scheme.setToolTipText(RepositorySelectionPage.EMPTY_STRING);
                } else {
                    RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setScheme(RepositorySelectionPage.this.nullString(RepositorySelectionPage.this.scheme.getItem(idx))));
                    RepositorySelectionPage.this.scheme.setToolTipText(Protocol.values()[idx].getTooltip());
                }
                RepositorySelectionPage.this.updateAuthGroup();
            }
        });
        this.newLabel(g, String.valueOf(UIText.RepositorySelectionPage_promptPort) + ":");
        this.portText = new Text((Composite)g, 2048);
        this.portText.addVerifyListener(new VerifyListener(){
            final Pattern p = Pattern.compile("^(?:[1-9][0-9]*)?$");

            public void verifyText(VerifyEvent e) {
                String v = RepositorySelectionPage.this.portText.getText();
                e.doit = this.p.matcher(String.valueOf(v.substring(0, e.start)) + e.text + v.substring(e.end)).matches();
            }
        });
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String val = RepositorySelectionPage.this.nullString(RepositorySelectionPage.this.portText.getText());
                if (val == null) {
                    RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setPort(-1));
                } else {
                    try {
                        RepositorySelectionPage.this.setURI(RepositorySelectionPage.this.uri.setPort(Integer.parseInt(val)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        });
    }

    private Group createGroup(Composite parent, String text) {
        Group g = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        g.setLayout((Layout)layout);
        g.setText(text);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        g.setLayoutData((Object)gd);
        return g;
    }

    private void newLabel(Group g, String text) {
        new Label((Composite)g, 0).setText(text);
    }

    private GridData createFieldGridData() {
        return new GridData(4, -1, true, false);
    }

    private String nullString(String value) {
        if (value == null) {
            return null;
        }
        String v = value.trim();
        return v.length() == 0 ? null : v;
    }

    private void safeSet(Text text, String value) {
        text.setText(value != null ? value : EMPTY_STRING);
    }

    private boolean isURISelected() {
        return this.uriButton == null || this.uriButton.getSelection();
    }

    private void setURI(URIish u) {
        try {
            ++this.eventDepth;
            if (this.eventDepth == 1) {
                this.uri = u;
                this.uriText.setText(this.uri.toString());
                this.checkPage();
            }
        }
        finally {
            --this.eventDepth;
        }
    }

    private List<RemoteConfig> getUsableConfigs(List<RemoteConfig> remotes) {
        if (remotes == null) {
            return null;
        }
        ArrayList<RemoteConfig> result = new ArrayList<RemoteConfig>();
        for (RemoteConfig config : remotes) {
            if ((!this.sourceSelection || config.getURIs().isEmpty()) && (this.sourceSelection || config.getPushURIs().isEmpty() && config.getURIs().isEmpty())) continue;
            result.add(config);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    protected void checkPage() {
        if (this.isURISelected()) {
            assert (this.uri != null);
            if (this.uriText.getText().length() == 0) {
                this.selectionIncomplete(null);
                return;
            }
            if (this.uriText.getText().endsWith(" ")) {
                this.selectionIncomplete(UIText.RepositorySelectionPage_UriMustNotHaveTrailingSpacesMessage);
                return;
            }
            try {
                URIish finalURI = new URIish(this.uriText.getText().trim());
                String proto = finalURI.getScheme();
                if (proto == null && this.scheme.getSelectionIndex() >= 0) {
                    proto = this.scheme.getItem(this.scheme.getSelectionIndex());
                }
                if (this.uri.getPath() == null) {
                    this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldRequired, (Object)this.unamp(UIText.RepositorySelectionPage_promptPath), (Object)proto));
                    return;
                }
                if (Protocol.FILE.handles(finalURI)) {
                    String badField = null;
                    if (this.uri.getHost() != null) {
                        badField = UIText.RepositorySelectionPage_promptHost;
                    } else if (this.uri.getUser() != null) {
                        badField = UIText.RepositorySelectionPage_promptUser;
                    } else if (this.uri.getPass() != null) {
                        badField = UIText.RepositorySelectionPage_promptPassword;
                    }
                    if (badField != null) {
                        this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldNotSupported, (Object)this.unamp(badField), (Object)proto));
                        return;
                    }
                    File d = FS.DETECTED.resolve(new File("."), this.uri.getPath());
                    if (!d.exists()) {
                        this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fileNotFound, (Object)d.getAbsolutePath()));
                        return;
                    }
                    this.selectionComplete(finalURI, null);
                    return;
                }
                if (this.uri.getHost() == null) {
                    this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldRequired, (Object)this.unamp(UIText.RepositorySelectionPage_promptHost), (Object)proto));
                    return;
                }
                if (Protocol.GIT.handles(finalURI)) {
                    String badField = null;
                    if (this.uri.getUser() != null) {
                        badField = UIText.RepositorySelectionPage_promptUser;
                    } else if (this.uri.getPass() != null) {
                        badField = UIText.RepositorySelectionPage_promptPassword;
                    }
                    if (badField != null) {
                        this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldNotSupported, (Object)this.unamp(badField), (Object)proto));
                        return;
                    }
                }
                this.selectionComplete(finalURI, null);
                return;
            }
            catch (URISyntaxException e) {
                this.selectionIncomplete(e.getReason());
                return;
            }
            catch (Exception e) {
                Activator.logError(NLS.bind((String)UIText.RepositorySelectionPage_errorValidating, (Object)this.getClass().getName()), e);
                this.selectionIncomplete(UIText.RepositorySelectionPage_internalError);
                return;
            }
        }
        assert (this.remoteButton.getSelection());
        this.selectionComplete(null, this.remoteConfig);
    }

    private String unamp(String s) {
        return s.replace("&", EMPTY_STRING);
    }

    private void selectionIncomplete(String errorMessage) {
        this.setExposedSelection(null, null);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(false);
    }

    private void selectionComplete(URIish u, RemoteConfig rc) {
        this.setExposedSelection(u, rc);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void setExposedSelection(URIish u, RemoteConfig rc) {
        RepositorySelection newSelection = new RepositorySelection(u, rc);
        if (newSelection.equals(this.selection)) {
            return;
        }
        this.selection = newSelection;
    }

    private void updateRemoteAndURIPanels() {
        UIUtils.setEnabledRecursively((Control)this.uriPanel, this.isURISelected());
        if (this.uriPanel.getEnabled()) {
            this.updateAuthGroup();
        }
        if (this.configuredRemotes != null) {
            UIUtils.setEnabledRecursively((Control)this.remotePanel, !this.isURISelected());
        }
    }

    private void updateAuthGroup() {
        Protocol p = this.getProtocol();
        if (p != null) {
            this.hostText.setEnabled(p.hasHost());
            this.portText.setEnabled(p.hasPort());
            UIUtils.setEnabledRecursively((Control)this.authGroup, p.canAuthenticate());
        }
    }

    private Protocol getProtocol() {
        int idx = this.scheme.getSelectionIndex();
        if (idx >= 0) {
            return Protocol.values()[idx];
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.uriText.setFocus();
        }
    }

    public void saveUriInPrefs() {
        this.uriProposalHandler.updateProposals();
    }

    public UserPasswordCredentials getCredentials() {
        if (!(this.user != null && this.user.length() != 0 || this.password != null && this.password.length() != 0)) {
            return null;
        }
        return new UserPasswordCredentials(this.user, this.password);
    }

    public boolean getStoreInSecureStore() {
        return this.storeInSecureStore;
    }

    public void setHelpContext(String id) {
        this.helpContext = id;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContext);
    }

    private void updateFields(String text) {
        block8: {
            ++this.eventDepth;
            if (this.eventDepth == 1) break block8;
            --this.eventDepth;
            return;
        }
        try {
            try {
                URIish u = new URIish(text);
                this.safeSet(this.hostText, u.getHost());
                this.safeSet(this.pathText, u.getPath());
                this.safeSet(this.userText, u.getUser());
                this.safeSet(this.passText, u.getPass());
                if (u.getPort() > 0) {
                    this.portText.setText(Integer.toString(u.getPort()));
                } else {
                    this.portText.setText(EMPTY_STRING);
                }
                if (u.getScheme() != null) {
                    this.scheme.select(this.scheme.indexOf(u.getScheme()));
                    this.scheme.notifyListeners(13, new Event());
                }
                this.updateAuthGroup();
                this.uri = u;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.uri = new URIish();
                this.hostText.setText(EMPTY_STRING);
                this.pathText.setText(EMPTY_STRING);
                this.userText.setText(EMPTY_STRING);
                this.passText.setText(EMPTY_STRING);
                this.portText.setText(EMPTY_STRING);
                this.scheme.select(-1);
                --this.eventDepth;
            }
        }
        catch (Throwable throwable) {
            --this.eventDepth;
            throw throwable;
        }
        --this.eventDepth;
        this.checkPage();
    }

    private IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    @Override
    public GitRepositoryInfo getGitRepositoryInfo() {
        GitRepositoryInfo info = new GitRepositoryInfo(this.uri.toString());
        info.setCredentials(this.user, this.password);
        info.setShouldSaveCredentialsInSecureStore(this.storeInSecureStore);
        this.uriProposalHandler.updateProposals();
        return info;
    }

    public static class Protocol {
        private static final TreeMap<String, Protocol> protocols = new TreeMap();
        public static final Protocol GIT = new Protocol("git", UIText.RepositorySelectionPage_tip_git, true, true, false);
        public static final Protocol SSH = new Protocol("ssh", UIText.RepositorySelectionPage_tip_ssh, true, true, true){

            public boolean handles(URIish uri) {
                if (!uri.isRemote()) {
                    return false;
                }
                String scheme = uri.getScheme();
                if (this.getDefaultScheme().equals(scheme)) {
                    return true;
                }
                if ("ssh+git".equals(scheme)) {
                    return true;
                }
                if ("git+ssh".equals(scheme)) {
                    return true;
                }
                return scheme == null && uri.getHost() != null && uri.getPath() != null;
            }
        };
        public static final Protocol SFTP = new Protocol("sftp", UIText.RepositorySelectionPage_tip_sftp, true, true, true);
        public static final Protocol HTTP = new Protocol("http", UIText.RepositorySelectionPage_tip_http, true, true, true);
        public static final Protocol HTTPS = new Protocol("https", UIText.RepositorySelectionPage_tip_https, true, true, true);
        public static final Protocol FTP = new Protocol("ftp", UIText.RepositorySelectionPage_tip_ftp, true, true, true);
        public static final Protocol FILE = new Protocol("file", UIText.RepositorySelectionPage_tip_file, false, false, false){

            public boolean handles(URIish uri) {
                if (this.getDefaultScheme().equals(uri.getScheme())) {
                    return true;
                }
                if (uri.getHost() != null || uri.getPort() > 0 || uri.getUser() != null || uri.getPass() != null || uri.getPath() == null) {
                    return false;
                }
                if (uri.getScheme() == null) {
                    return FS.DETECTED.resolve(new File("."), uri.getPath()).isDirectory();
                }
                return false;
            }
        };
        private final String defaultScheme;
        private final String tooltip;
        private final boolean hasHost;
        private final boolean hasPort;
        private final boolean canAuthenticate;

        private Protocol(String defaultScheme, String tooltip, boolean hasHost, boolean hasPort, boolean canAuthenticate) {
            this.defaultScheme = defaultScheme;
            this.tooltip = tooltip;
            this.hasHost = hasHost;
            this.hasPort = hasPort;
            this.canAuthenticate = canAuthenticate;
            protocols.put(defaultScheme, this);
        }

        public boolean handles(URIish uri) {
            return this.getDefaultScheme().equals(uri.getScheme());
        }

        public String getDefaultScheme() {
            return this.defaultScheme;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public boolean hasHost() {
            return this.hasHost;
        }

        public boolean hasPort() {
            return this.hasPort;
        }

        public boolean canAuthenticate() {
            return this.canAuthenticate;
        }

        public static Protocol[] values() {
            return protocols.values().toArray(new Protocol[protocols.size()]);
        }

        public static Protocol fromDefaultScheme(String scheme) {
            return protocols.get(scheme);
        }

        public static Protocol fromUri(URIish uri) {
            for (Protocol p : protocols.values()) {
                if (!p.handles(uri)) continue;
                return p;
            }
            return null;
        }
    }
}

