/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.CreateRepositoryPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewRepositoryWizard
extends Wizard
implements INewWizard {
    private final CreateRepositoryPage myCreatePage;
    private Repository newRepo;

    public NewRepositoryWizard() {
        this(false);
    }

    public NewRepositoryWizard(boolean hideBareOption) {
        this.myCreatePage = new CreateRepositoryPage(hideBareOption);
    }

    public void addPages() {
        this.setWindowTitle(UIText.NewRepositoryWizard_WizardTitle);
        this.setHelpAvailable(false);
        this.addPage((IWizardPage)this.myCreatePage);
    }

    public boolean performFinish() {
        RepositoryCache cache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
        try {
            File repoFile = new File(this.myCreatePage.getDirectory());
            if (!this.myCreatePage.getBare()) {
                repoFile = new File(repoFile, ".git");
            }
            Repository repoToCreate = cache.lookupRepository(repoFile);
            repoToCreate.create(this.myCreatePage.getBare());
            org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil().addConfiguredRepository(repoFile);
            this.newRepo = repoToCreate;
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, false);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public Repository getCreatedRepository() {
        return this.newRepo;
    }
}

