/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.util.BidirectionalMap;

public class BayesNet {
    private List<BayesNode> nodes = new ArrayList<BayesNode>();
    private BidirectionalMap<String, BayesNode> nodeMap = new BidirectionalMap();

    public int addNode(BayesNode node) {
        node.setId(this.nodes.size());
        this.nodes.add(node);
        if (this.nodeMap.containsKey(node.getName())) {
            throw new IllegalStateException("Name conflict: " + node.getName() + " already present");
        }
        this.nodeMap.put(node.getName(), node);
        return node.getId();
    }

    public BayesNode getNode(String name) {
        return this.nodeMap.get(name);
    }

    public BayesNode getNode(int id) {
        return this.nodes.get(id);
    }

    public List<BayesNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }
}

