/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.recommenders.jayes.util.AddressCalc;

public class Factor
implements Cloneable {
    protected int[] dimensions = new int[0];
    private int[] dimensionIDs = new int[0];
    private double[] values = new double[1];
    protected int[] selections = new int[0];
    private Cut cut = new Cut();
    private boolean isCutValid = false;
    private boolean isLogScale = false;

    public void setValues(double[] values) {
        this.values = values;
    }

    public double[] getValues() {
        return this.values;
    }

    public void fill(double d) {
        Arrays.fill(this.values, d);
    }

    public void setDimensions(int[] dimensions) {
        this.dimensions = Arrays.copyOf(dimensions, dimensions.length);
        this.selections = new int[dimensions.length];
        this.resetSelections();
        int length = 1;
        int[] nArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            length *= i;
            ++n2;
        }
        if (length > this.values.length) {
            this.values = new double[length];
        }
        this.dimensionIDs = Arrays.copyOf(this.dimensionIDs, dimensions.length);
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensionIDs(int[] ids) {
        this.dimensionIDs = (int[])ids.clone();
    }

    public int[] getDimensionIDs() {
        return this.dimensionIDs;
    }

    private int getDimensionFromID(int id) {
        int i = 0;
        while (i < this.dimensionIDs.length) {
            if (this.dimensionIDs[i] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void select(int dimensionID, int index) {
        int dim = this.getDimensionFromID(dimensionID);
        if (this.selections[dim] != index) {
            this.selections[dim] = index;
            this.isCutValid = false;
        }
    }

    public void resetSelections() {
        Arrays.fill(this.selections, -1);
        this.isCutValid = false;
    }

    public void setLogScale(boolean isLogScale) {
        this.isLogScale = isLogScale;
    }

    public boolean isLogScale() {
        return this.isLogScale;
    }

    public double[] sum(int sumDimensionID) {
        if (sumDimensionID == -1) {
            sumDimensionID = this.dimensionIDs[this.dimensionIDs.length - 1];
        }
        int sumDimension = this.getDimensionFromID(sumDimensionID);
        double[] result = new double[this.dimensions[sumDimension]];
        this.sumDim(sumDimension, result);
        return result;
    }

    private void sumDim(int sumDimension, double[] acc) {
        this.validateCut();
        int divisor = 1;
        int i = this.dimensions.length - 1;
        while (i > sumDimension) {
            divisor *= this.dimensions[i];
            --i;
        }
        this.sumToBucket(this.cut, 0, divisor, acc);
    }

    private void sumToBucket(Cut cut, int offset, int divisor, double[] result) {
        if (cut.subCut == null) {
            int last = cut.index + offset + cut.length;
            double[] val = this.values;
            int i = cut.index + offset;
            while (i < last) {
                int n = i / divisor % result.length;
                result[n] = result[n] + val[i];
                i += cut.stepSize;
            }
        } else {
            Cut c = cut.subCut;
            int i = 0;
            while (i < cut.length) {
                this.sumToBucket(c, offset + i, divisor, result);
                i += cut.subtreeStepsize;
            }
        }
    }

    public void multiplyCompatible(Factor compatible) {
        int[] positions = this.prepareMultiplication(compatible);
        this.multiplyPrepared(compatible.values, positions);
    }

    public void multiplyPrepared(double[] compatibleValues, int[] positions) {
        this.validateCut();
        if (!this.isLogScale) {
            this.multiplyPrepared(this.cut, 0, compatibleValues, positions);
        } else {
            this.multiplyPreparedLog(this.cut, 0, compatibleValues, positions);
        }
    }

    private void multiplyPrepared(Cut cut, int offset, double[] compatibleValues, int[] positions) {
        if (cut.subCut == null) {
            int last = Math.min(this.values.length, cut.length + cut.index + offset);
            int i = cut.index + offset;
            while (i < last) {
                int n = i;
                this.values[n] = this.values[n] * compatibleValues[positions[i]];
                i += cut.stepSize;
            }
        } else {
            Cut c = cut.subCut;
            int i = 0;
            while (i < cut.length) {
                this.multiplyPrepared(c, offset + i, compatibleValues, positions);
                i += cut.subtreeStepsize;
            }
        }
    }

    public void sumPrepared(double[] compatibleFactorValues, int[] preparedOperation) {
        Arrays.fill(compatibleFactorValues, 0.0);
        this.validateCut();
        if (!this.isLogScale) {
            this.sumPrepared(this.cut, 0, compatibleFactorValues, preparedOperation);
        } else {
            this.sumPreparedLog(compatibleFactorValues, preparedOperation);
        }
    }

    private void sumPrepared(Cut cut, int offset, double[] compatibleValues, int[] positions) {
        if (cut.subCut == null) {
            int last = Math.min(this.values.length, cut.length + cut.index + offset);
            int i = cut.index + offset;
            while (i < last) {
                int n = positions[i];
                compatibleValues[n] = compatibleValues[n] + this.values[i];
                i += cut.stepSize;
            }
        } else {
            Cut c = cut.subCut;
            int i = 0;
            while (i < cut.length) {
                this.sumPrepared(c, offset + i, compatibleValues, positions);
                i += cut.subtreeStepsize;
            }
        }
    }

    private void sumPreparedLog(double[] compatible, int[] positions) {
        double max = this.findMax(this.cut, 0, 0.0);
        this.sumPreparedLog(this.cut, 0, compatible, positions, max);
        int i = 0;
        while (i < compatible.length) {
            compatible[i] = Math.log(compatible[i]) + max;
            ++i;
        }
    }

    private double findMax(Cut cut, int offset, double max) {
        if (cut.subCut == null) {
            int last = Math.min(this.values.length, cut.length + cut.index + offset);
            int i = cut.index + offset;
            while (i < last) {
                if (this.values[i] != Double.NEGATIVE_INFINITY && Math.abs(this.values[i]) > Math.abs(max)) {
                    max = this.values[i];
                }
                i += cut.stepSize;
            }
        } else {
            Cut c = cut.subCut;
            int i = 0;
            while (i < cut.length) {
                double pot = this.findMax(c, offset + i, max);
                if (pot != Double.NEGATIVE_INFINITY && Math.abs(pot) > Math.abs(max)) {
                    max = pot;
                }
                i += cut.subtreeStepsize;
            }
        }
        return max;
    }

    private void sumPreparedLog(Cut cut, int offset, double[] compatibleValues, int[] positions, double max) {
        if (cut.subCut == null) {
            int last = Math.min(this.values.length, cut.length + cut.index + offset);
            int i = cut.index + offset;
            while (i < last) {
                int n = positions[i];
                compatibleValues[n] = compatibleValues[n] + Math.exp(this.values[i] - max);
                i += cut.stepSize;
            }
        } else {
            Cut c = cut.subCut;
            int i = 0;
            while (i < cut.length) {
                this.sumPreparedLog(c, offset + i, compatibleValues, positions, max);
                i += cut.subtreeStepsize;
            }
        }
    }

    private void multiplyPreparedLog(Cut cut, int offset, double[] compatibleValues, int[] positions) {
        if (cut.subCut == null) {
            int last = Math.min(this.values.length, cut.length + cut.index + offset);
            int i = cut.index + offset;
            while (i < last) {
                int n = i;
                this.values[n] = this.values[n] + compatibleValues[positions[i]];
                i += cut.stepSize;
            }
        } else {
            Cut c = cut.subCut;
            int i = 0;
            while (i < cut.length) {
                this.multiplyPreparedLog(c, offset + i, compatibleValues, positions);
                i += cut.subtreeStepsize;
            }
        }
    }

    private void validateCut() {
        if (!this.isCutValid) {
            this.cut.initialize();
            this.isCutValid = true;
        }
    }

    public int[] prepareMultiplication(Factor compatible) {
        int[] positions = new int[this.values.length];
        int[] counter = new int[this.dimensions.length];
        Map<Integer, Integer> foreignIdToIndex = this.computeIdToDimensionIndexMap(compatible);
        counter[counter.length - 1] = -1;
        int i = 0;
        while (i < this.values.length) {
            AddressCalc.incrementMultiDimensionalCounter(counter, this.dimensions, this.dimensions.length - 1);
            positions[i] = this.computeForeignPosition(compatible, counter, foreignIdToIndex);
            ++i;
        }
        return positions;
    }

    private Map<Integer, Integer> computeIdToDimensionIndexMap(Factor factor) {
        HashMap<Integer, Integer> foreignIds = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < factor.dimensionIDs.length) {
            foreignIds.put(factor.dimensionIDs[i], i);
            ++i;
        }
        return foreignIds;
    }

    private int computeForeignPosition(Factor compatible, int[] counter, Map<Integer, Integer> foreignIdToIndex) {
        if (compatible.dimensions.length == 0) {
            return 0;
        }
        int[] foreignPos = this.transformLocalToForeignPosition(counter, foreignIdToIndex);
        return AddressCalc.realAddr(compatible.getDimensions(), foreignPos);
    }

    private int[] transformLocalToForeignPosition(int[] localPosition, Map<Integer, Integer> foreignIdToIndex) {
        int[] foreignPosition = new int[foreignIdToIndex.size()];
        int i = 0;
        while (i < this.dimensions.length) {
            Integer foreignDim = foreignIdToIndex.get(this.dimensionIDs[i]);
            if (foreignDim != null) {
                foreignPosition[foreignDim.intValue()] = localPosition[i];
            }
            ++i;
        }
        return foreignPosition;
    }

    public Factor clone() {
        Factor f = null;
        try {
            f = (Factor)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            exception.printStackTrace();
        }
        f.values = (double[])this.values.clone();
        f.selections = (int[])this.selections.clone();
        f.cut = f.new Cut();
        f.isCutValid = false;
        return f;
    }

    public void multiplyCompatibleToLog(Factor factor) {
        int[] positions = this.prepareMultiplication(factor);
        int i = 0;
        while (i < this.values.length) {
            int n = i;
            this.values[n] = this.values[n] + Math.log(factor.values[positions[i]]);
            ++i;
        }
    }

    private class Cut
    implements Cloneable {
        private int index;
        private int stepSize;
        private int length;
        private int subtreeStepsize;
        private int rootDimension;
        private int leafDimension;
        private Cut subCut;

        public void initialize() {
            this.length = Factor.this.values.length;
            this.index = 0;
            this.stepSize = 1;
            this.subtreeStepsize = Factor.this.values.length / Factor.this.dimensions[0];
            this.rootDimension = 0;
            this.leafDimension = Factor.this.dimensions.length - 1;
            this.subCut = null;
            this.leafCut();
            this.rootCut();
            this.createSubcut();
        }

        public Cut clone() {
            try {
                return (Cut)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }

        private void rootCut() {
            while (this.rootDimension < this.leafDimension && Factor.this.selections[this.rootDimension] != -1) {
                this.descendSelectedDimension();
            }
            while (this.rootDimension < this.leafDimension && Factor.this.selections[this.rootDimension + 1] == -1) {
                this.descendUnselectedDimension();
            }
        }

        private void descendSelectedDimension() {
            this.length /= Factor.this.dimensions[this.rootDimension];
            this.index += this.subtreeStepsize * Factor.this.selections[this.rootDimension];
            this.descendUnselectedDimension();
        }

        private void descendUnselectedDimension() {
            ++this.rootDimension;
            this.subtreeStepsize /= Factor.this.dimensions[this.rootDimension];
        }

        private void leafCut() {
            while (this.leafDimension >= 0 && Factor.this.selections[this.leafDimension] != -1) {
                this.ascendSelectedDimension();
            }
        }

        private void ascendSelectedDimension() {
            this.index += Factor.this.selections[this.leafDimension] * this.stepSize;
            this.length -= Factor.this.selections[this.leafDimension] * this.stepSize;
            this.stepSize *= Factor.this.dimensions[this.leafDimension];
            --this.leafDimension;
        }

        private void createSubcut() {
            if (this.needsSplit()) {
                this.subCut = null;
                this.subCut = this.clone();
                this.subCut.descendUnselectedDimension();
                this.subCut.length = this.subtreeStepsize;
                this.subCut.rootCut();
                this.subCut.createSubcut();
            }
        }

        private boolean needsSplit() {
            if (this.length < this.subtreeStepsize) {
                return false;
            }
            int i = this.rootDimension;
            while (i < this.leafDimension) {
                if (Factor.this.selections[i] != -1) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

