/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.inference;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.IBayesInferer;

public abstract class AbstractInferer
implements IBayesInferer {
    protected Map<BayesNode, String> evidence = new HashMap<BayesNode, String>();
    protected BayesNet net;
    protected double[][] beliefs;
    protected boolean beliefsValid;

    @Override
    public void addEvidence(BayesNode node, String outcome) {
        this.evidence.put(node, outcome);
        this.beliefsValid = false;
    }

    @Override
    public double[] getBeliefs(BayesNode node) {
        if (!this.beliefsValid) {
            this.beliefsValid = true;
            this.updateBeliefs();
        }
        return this.beliefs[node.getId()];
    }

    @Override
    public void setNetwork(BayesNet bayesNet) {
        this.net = bayesNet;
        this.beliefs = new double[this.net.getNodes().size()][];
        for (BayesNode n : this.net.getNodes()) {
            this.beliefs[n.getId()] = new double[n.getOutcomeCount()];
        }
    }

    @Override
    public void setEvidence(Map<BayesNode, String> evidence) {
        this.evidence = evidence;
        this.beliefsValid = false;
    }

    @Override
    public Map<BayesNode, String> getEvidence() {
        return this.evidence;
    }

    protected abstract void updateBeliefs();
}

