/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.inference.junctionTree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.junctionTree.JunctionTree;
import org.eclipse.recommenders.jayes.util.Graph;
import org.eclipse.recommenders.jayes.util.OrderIgnoringPair;
import org.eclipse.recommenders.jayes.util.Pair;
import org.eclipse.recommenders.jayes.util.UnionFindSet;

public class JunctionTreeBuilder {
    private final BayesNet net;
    private final Graph moral;
    private JunctionTree junctionTree = new JunctionTree(new Graph());

    public static JunctionTree fromNet(BayesNet net) {
        return new JunctionTreeBuilder(net).getJunctionTree();
    }

    protected JunctionTreeBuilder(BayesNet net) {
        this.net = net;
        this.moral = new Graph();
        this.buildMoralGraph();
        this.junctionTree.setClusters(this.triangulateGraphAndFindCliques());
        this.junctionTree.setSepSets(this.computeSepsets());
    }

    private Graph buildMoralGraph() {
        this.moral.initialize(this.net.getNodes().size());
        HashSet<OrderIgnoringPair<BayesNode>> connected = new HashSet<OrderIgnoringPair<BayesNode>>();
        for (BayesNode node : this.net.getNodes()) {
            this.addMoralEdges(connected, node);
        }
        return this.moral;
    }

    private void addMoralEdges(Set<OrderIgnoringPair<BayesNode>> connected, BayesNode node) {
        ListIterator<BayesNode> it = node.getParents().listIterator();
        while (it.hasNext()) {
            BayesNode parent = it.next();
            ListIterator<BayesNode> remainingParentsIt = node.getParents().listIterator(it.nextIndex());
            while (remainingParentsIt.hasNext()) {
                BayesNode otherParent = remainingParentsIt.next();
                this.connect(connected, parent, otherParent);
            }
            this.connect(connected, node, parent);
        }
    }

    private void connect(Set<OrderIgnoringPair<BayesNode>> connected, BayesNode node1, BayesNode node2) {
        OrderIgnoringPair<BayesNode> pair = new OrderIgnoringPair<BayesNode>(node1, node2);
        if (!connected.contains(pair)) {
            connected.add(pair);
            this.moral.addEdge(node1.getId(), node2.getId());
        }
    }

    private List<List<Integer>> triangulateGraphAndFindCliques() {
        List<Integer> moralNodes = this.getNodeList();
        ArrayList<List<Integer>> cliques = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < this.moral.getAdjacency().size()) {
            int nextNode = this.nextTriangulationNode(moralNodes);
            List<Integer> clique = this.createClique(nextNode);
            if (!this.containsSuperset(cliques, clique)) {
                cliques.add(clique);
            }
            moralNodes.remove((Object)nextNode);
            this.virtualRemoveNode(nextNode);
            ++i;
        }
        return cliques;
    }

    private List<Integer> getNodeList() {
        ArrayList<Integer> moralNodes = new ArrayList<Integer>();
        int i = 0;
        while (i < this.moral.getAdjacency().size()) {
            moralNodes.add(i);
            ++i;
        }
        return moralNodes;
    }

    private List<Integer> createClique(int centerNode) {
        ArrayList<Integer> clique = new ArrayList<Integer>();
        clique.add(centerNode);
        for (Graph.Edge e : this.moral.getIncidentEdges(centerNode)) {
            this.connectToAll((Integer)e.getSecond(), clique);
            clique.add((Integer)e.getSecond());
        }
        return clique;
    }

    private void connectToAll(Integer node, List<Integer> others) {
        for (int other : others) {
            Graph.Edge newEdge = new Graph.Edge(node, other);
            if (this.moral.getIncidentEdges(node).contains(newEdge)) continue;
            this.moral.addEdge(node, other);
        }
    }

    private boolean containsSuperset(Collection<? extends Collection<Integer>> sets, Collection<Integer> set) {
        boolean isSubsetOfOther = false;
        for (Collection<Integer> collection : sets) {
            if (!collection.containsAll(set)) continue;
            isSubsetOfOther = true;
            break;
        }
        return isSubsetOfOther;
    }

    private void virtualRemoveNode(int node) {
        while (!this.moral.getIncidentEdges(node).isEmpty()) {
            this.moral.removeEdge(this.moral.getIncidentEdges(node).get(0));
        }
    }

    private int nextTriangulationNode(List<Integer> moralNodes) {
        int minFillIn = Integer.MAX_VALUE;
        int nextClusterSize = Integer.MAX_VALUE;
        int returnNode = 0;
        for (int node : moralNodes) {
            Set<Integer> neighbors;
            int predictedFillIn = this.predictFillIn(node, neighbors = this.getNeighbors(node));
            if (predictedFillIn > minFillIn) continue;
            int clusterSize = this.computeClusterSize(node, neighbors);
            if (predictedFillIn >= minFillIn && clusterSize >= nextClusterSize) continue;
            returnNode = node;
            minFillIn = predictedFillIn;
            nextClusterSize = clusterSize;
        }
        return returnNode;
    }

    private int computeClusterSize(int node, Set<Integer> neighborsOfNode) {
        int clSize = this.net.getNode(node).getOutcomeCount();
        for (int neighbor : neighborsOfNode) {
            clSize *= this.net.getNode(neighbor).getOutcomeCount();
        }
        return clSize;
    }

    private int predictFillIn(int node, Set<Integer> neighborsOfNode) {
        int fillIn = 0;
        for (Graph.Edge e : this.moral.getIncidentEdges(node)) {
            Set<Integer> neighbors2 = this.getNeighbors((Integer)e.getSecond());
            neighborsOfNode.remove(e.getSecond());
            neighbors2.retainAll(neighborsOfNode);
            fillIn += neighborsOfNode.size() - neighbors2.size();
            neighborsOfNode.add((Integer)e.getSecond());
        }
        return fillIn;
    }

    private Set<Integer> getNeighbors(int node) {
        HashSet<Integer> neighbors = new HashSet<Integer>();
        for (Graph.Edge e : this.moral.getIncidentEdges(node)) {
            neighbors.add((Integer)e.getSecond());
        }
        return neighbors;
    }

    private List<Pair<Graph.Edge, List<Integer>>> computeSepsets() {
        List<Pair<Graph.Edge, List<Integer>>> candidates = this.enumerateCandidateSepSets();
        return this.computeMaxSpanningTree(candidates);
    }

    private List<Pair<Graph.Edge, List<Integer>>> enumerateCandidateSepSets() {
        ArrayList<Pair<Graph.Edge, List<Integer>>> sepSets = new ArrayList<Pair<Graph.Edge, List<Integer>>>();
        ListIterator<List<Integer>> it = this.junctionTree.getClusters().listIterator();
        while (it.hasNext()) {
            List<Integer> clique1 = it.next();
            ListIterator<List<Integer>> remainingIt = this.junctionTree.getClusters().listIterator(it.nextIndex());
            while (remainingIt.hasNext()) {
                ArrayList clique2 = new ArrayList(remainingIt.next());
                clique2.retainAll(clique1);
                sepSets.add(new Pair(new Graph.Edge(it.nextIndex() - 1, remainingIt.nextIndex() - 1), clique2));
            }
        }
        return sepSets;
    }

    private List<Pair<Graph.Edge, List<Integer>>> computeMaxSpanningTree(List<Pair<Graph.Edge, List<Integer>>> candidateSepSets) {
        Collections.sort(candidateSepSets, new SepsetComparator());
        ArrayDeque<Pair<Graph.Edge, List<Integer>>> pq = new ArrayDeque<Pair<Graph.Edge, List<Integer>>>(candidateSepSets);
        int vertexCount = this.junctionTree.getGraph().getAdjacency().size();
        UnionFindSet[] sets = UnionFindSet.createArray(vertexCount);
        ArrayList<Pair<Graph.Edge, List<Integer>>> leftSepSets = new ArrayList<Pair<Graph.Edge, List<Integer>>>();
        while (leftSepSets.size() < vertexCount - 1) {
            boolean bothEndsInSameTree;
            Pair<Graph.Edge, List<Integer>> sep = pq.poll();
            boolean bl = bothEndsInSameTree = sets[(Integer)sep.getFirst().getFirst()].find() == sets[(Integer)sep.getFirst().getSecond()].find();
            if (bothEndsInSameTree) continue;
            sets[(Integer)sep.getFirst().getFirst()].merge(sets[(Integer)sep.getFirst().getSecond()]);
            leftSepSets.add(sep);
            this.junctionTree.getGraph().addEdge((Integer)sep.getFirst().getFirst(), (Integer)sep.getFirst().getSecond());
        }
        return leftSepSets;
    }

    public JunctionTree getJunctionTree() {
        return this.junctionTree;
    }

    private final class SepsetComparator
    implements Comparator<Pair<Graph.Edge, List<Integer>>> {
        private SepsetComparator() {
        }

        @Override
        public int compare(Pair<Graph.Edge, List<Integer>> sepSet1, Pair<Graph.Edge, List<Integer>> sepSet2) {
            int compareNumberOfVariables = this.compare(sepSet1.getSecond().size(), sepSet2.getSecond().size());
            if (compareNumberOfVariables != 0) {
                return -compareNumberOfVariables;
            }
            int tableSize1 = this.getTableSize(sepSet1.getSecond());
            int tableSize2 = this.getTableSize(sepSet2.getSecond());
            return this.compare(tableSize1, tableSize2);
        }

        private int getTableSize(List<Integer> cluster) {
            int tableSize = 1;
            for (int id : cluster) {
                tableSize *= JunctionTreeBuilder.this.net.getNode(id).getOutcomeCount();
            }
            return tableSize;
        }

        @Override
        private int compare(int i1, int i2) {
            return i1 - i2;
        }
    }
}

