/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.ArrayShortList;
import org.apache.commons.collections.primitives.ShortIterator;
import org.apache.commons.collections.primitives.ShortList;
import org.apache.commons.collections.primitives.ShortListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableShortIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableShortList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableShortListIterator;

public final class ShortCollections {
    public static final ShortList EMPTY_SHORT_LIST = ShortCollections.unmodifiableShortList(new ArrayShortList(0));
    public static final ShortIterator EMPTY_SHORT_ITERATOR = ShortCollections.unmodifiableShortIterator(EMPTY_SHORT_LIST.iterator());
    public static final ShortListIterator EMPTY_SHORT_LIST_ITERATOR = ShortCollections.unmodifiableShortListIterator(EMPTY_SHORT_LIST.listIterator());

    public static ShortList singletonShortList(short value) {
        ArrayShortList list = new ArrayShortList(1);
        list.add(value);
        return UnmodifiableShortList.wrap(list);
    }

    public static ShortIterator singletonShortIterator(short value) {
        return ShortCollections.singletonShortList(value).iterator();
    }

    public static ShortListIterator singletonShortListIterator(short value) {
        return ShortCollections.singletonShortList(value).listIterator();
    }

    public static ShortList unmodifiableShortList(ShortList list) throws NullPointerException {
        if (list == null) {
            throw new NullPointerException();
        }
        return UnmodifiableShortList.wrap(list);
    }

    public static ShortIterator unmodifiableShortIterator(ShortIterator iter) {
        if (iter == null) {
            throw new NullPointerException();
        }
        return UnmodifiableShortIterator.wrap(iter);
    }

    public static ShortListIterator unmodifiableShortListIterator(ShortListIterator iter) {
        if (iter == null) {
            throw new NullPointerException();
        }
        return UnmodifiableShortListIterator.wrap(iter);
    }

    public static ShortList getEmptyShortList() {
        return EMPTY_SHORT_LIST;
    }

    public static ShortIterator getEmptyShortIterator() {
        return EMPTY_SHORT_ITERATOR;
    }

    public static ShortListIterator getEmptyShortListIterator() {
        return EMPTY_SHORT_LIST_ITERATOR;
    }
}

