/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.CharList;
import org.apache.commons.collections.primitives.CharListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionCharCollection;
import org.apache.commons.collections.primitives.adapters.CharCollectionCollection;
import org.apache.commons.collections.primitives.adapters.ListCharList;
import org.apache.commons.collections.primitives.adapters.ListIteratorCharListIterator;

abstract class AbstractListCharList
extends AbstractCollectionCharCollection
implements CharList {
    AbstractListCharList() {
    }

    @Override
    public void add(int index, char element) {
        this.getList().add(index, new Character(element));
    }

    @Override
    public boolean addAll(int index, CharCollection collection) {
        return this.getList().addAll(index, CharCollectionCollection.wrap(collection));
    }

    @Override
    public char get(int index) {
        return ((Character)this.getList().get(index)).charValue();
    }

    @Override
    public int indexOf(char element) {
        return this.getList().indexOf(new Character(element));
    }

    @Override
    public int lastIndexOf(char element) {
        return this.getList().lastIndexOf(new Character(element));
    }

    @Override
    public CharListIterator listIterator() {
        return ListIteratorCharListIterator.wrap(this.getList().listIterator());
    }

    @Override
    public CharListIterator listIterator(int index) {
        return ListIteratorCharListIterator.wrap(this.getList().listIterator(index));
    }

    @Override
    public char removeElementAt(int index) {
        return ((Character)this.getList().remove(index)).charValue();
    }

    @Override
    public char set(int index, char element) {
        return this.getList().set(index, new Character(element)).charValue();
    }

    @Override
    public CharList subList(int fromIndex, int toIndex) {
        return ListCharList.wrap(this.getList().subList(fromIndex, toIndex));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CharList) {
            CharList that = (CharList)obj;
            if (this == that) {
                return true;
            }
            if (this.size() != that.size()) {
                return false;
            }
            CharIterator thisiter = this.iterator();
            CharIterator thatiter = that.iterator();
            while (thisiter.hasNext()) {
                if (thisiter.next() == thatiter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getList().hashCode();
    }

    @Override
    protected final Collection getCollection() {
        return this.getList();
    }

    protected abstract List getList();
}

