/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.models;

import com.google.common.base.Optional;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.internal.rcp.models.IModelArchive;
import org.eclipse.recommenders.internal.rcp.repo.RepositoryUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class ModelArchiveMetadata<K, V> {
    public static final String P_COORDINATE = "coordinate";
    public static final String P_STATUS = "status";
    public static final String P_ERROR = "error";
    public static final String P_MODEL = "model";
    public static final String P_LOCATION = "location";
    public static final ModelArchiveMetadata NULL = new ModelArchiveMetadata(){
        {
            this.coordinate = "";
            this.status = ModelArchiveResolutionStatus.UNINITIALIZED;
        }
    };
    protected String coordinate;
    protected File location;
    protected ModelArchiveResolutionStatus status;
    protected String error;
    private transient boolean resolutionRequestedSinceStartup;
    protected transient Artifact artifact;
    protected transient IModelArchive<K, V> modelArchive;
    private transient PropertyChangeSupport chg = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.chg.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.chg.removePropertyChangeListener(listener);
    }

    public String getCoordinate() {
        return this.coordinate;
    }

    public Optional<Artifact> getArtifact() {
        if (this.artifact == null && !StringUtils.isEmpty((CharSequence)this.coordinate)) {
            this.artifact = new DefaultArtifact(this.coordinate);
        }
        return Optional.fromNullable((Object)this.artifact);
    }

    public void setCoordinate(String newCoordinates) {
        this.checkStringFormat(newCoordinates);
        this.artifact = null;
        this.coordinate = newCoordinates;
        this.chg.firePropertyChange(P_COORDINATE, this.coordinate, this.coordinate);
    }

    private void checkStringFormat(String newCoordinates) {
        if (newCoordinates != null) {
            RepositoryUtils.newArtifact(newCoordinates);
        }
    }

    public ModelArchiveResolutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ModelArchiveResolutionStatus newStatus) {
        this.status = newStatus;
        this.chg.firePropertyChange(P_STATUS, (Object)this.status, (Object)this.status);
    }

    public String getError() {
        return this.error;
    }

    public void setError(String newError) {
        this.error = newError;
        this.chg.firePropertyChange(P_ERROR, this.error, this.error);
    }

    public IModelArchive<K, V> getModelArchive() {
        return this.modelArchive;
    }

    public void setModelArchive(IModelArchive<K, V> newModel) {
        this.modelArchive = newModel;
        this.chg.firePropertyChange(P_MODEL, this.modelArchive, this.modelArchive);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File newLocation) {
        this.location = newLocation;
        this.chg.firePropertyChange(P_MODEL, this.location, this.location);
    }

    public boolean isResolutionRequestedSinceStartup() {
        return this.resolutionRequestedSinceStartup;
    }

    public void setResolutionRequestedSinceStartup(boolean tested) {
        this.resolutionRequestedSinceStartup = tested;
    }

    public static enum ArchiveModelUpdatePolicy {
        MANUAL,
        DEFAULT,
        NEVER;

    }

    public static enum ModelArchiveResolutionStatus {
        RESOLVED,
        MANUAL,
        PROHIBITED,
        FAILED,
        UNRESOLVED,
        UNINITIALIZED;

    }
}

