/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.repo;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.recommenders.internal.rcp.repo.RepositoryUtils;
import org.eclipse.recommenders.internal.rcp.wiring.RecommendersModule;
import org.eclipse.recommenders.rcp.repo.IModelRepositoryIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;

public class ModelRepositoryIndex
implements Closeable,
IModelRepositoryIndex {
    public static final Artifact INDEX_ARTIFACT = RepositoryUtils.newArtifact("org.eclipse.recommenders:index:zip:0.0.0");
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Directory directory;
    private IndexReader reader;
    private final File location;

    @Inject
    public ModelRepositoryIndex(@RecommendersModule.ModelRepositoryIndexLocation File location) throws IOException {
        this.location = location;
    }

    @Override
    public void open() {
        try {
            this.directory = FSDirectory.open((File)this.location);
            this.reader = IndexReader.open((Directory)this.directory);
        }
        catch (Exception e) {
            this.log.error("Failed to open search index.", (Throwable)e);
        }
    }

    @Override
    public void close() {
        Closeables.closeQuietly((Closeable)this.reader);
        Closeables.closeQuietly((Closeable)this.directory);
    }

    public boolean exists() {
        return this.location.exists();
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public Optional<Artifact> searchByFingerprint(String fingerprint, String classifier) {
        Term t1 = new Term("fingerprints", fingerprint);
        Term t2 = new Term("classifier", classifier);
        return this.findByTerm(classifier, t1, t2);
    }

    @Override
    public Optional<Artifact> searchByArtifactId(String artifactId, String classifier) {
        Term t1 = new Term("symbolic-names", artifactId);
        Term t2 = new Term("classifier", classifier);
        return this.findByTerm(classifier, t1, t2);
    }

    public List<Artifact> searchByClassifier(String classifier) {
        LinkedList res = Lists.newLinkedList();
        try {
            Term t = new Term("classifier", classifier);
            IndexSearcher searcher = new IndexSearcher(this.reader);
            TopDocs matches = searcher.search((Query)new TermQuery(t), Integer.MAX_VALUE);
            searcher.close();
            ScoreDoc[] scoreDocArray = matches.scoreDocs;
            int n = matches.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc doc = scoreDocArray[n2];
                String value = this.reader.document(doc.doc).get(classifier);
                if (value != null) {
                    res.add(RepositoryUtils.newArtifact(value));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.log.error("Searching index failed with exception", (Throwable)e);
        }
        return res;
    }

    private Optional<Artifact> findByTerm(String classifier, Term ... terms) {
        if (this.reader == null) {
            return Optional.absent();
        }
        BooleanQuery query = new BooleanQuery();
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            TermQuery q = new TermQuery(t);
            query.add((Query)q, BooleanClause.Occur.MUST);
            ++n2;
        }
        try {
            Document doc;
            String modelCoordinate;
            IndexSearcher searcher = new IndexSearcher(this.reader);
            TopDocs matches = searcher.search((Query)query, 5);
            searcher.close();
            if (matches.totalHits == 0) {
                return Optional.absent();
            }
            if (matches.totalHits > 1) {
                this.log.warn("More than one potential match for query {} found. Inconsistency in model store?", (Object)query);
            }
            if ((modelCoordinate = (doc = this.reader.document(matches.scoreDocs[0].doc)).get(classifier)) == null) {
                return Optional.absent();
            }
            return Optional.of((Object)RepositoryUtils.newArtifact(modelCoordinate));
        }
        catch (Exception e) {
            this.log.error("Searching index failed with exception", (Throwable)e);
            return Optional.absent();
        }
    }
}

