/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.repo;

import com.google.common.net.InternetDomainName;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class RepositoryUtils {
    public static String EXTENSION_MODELS = "zip";
    public static String CLASSIFIER_COMPLETION_CALLS = "call";
    public static String CLASSIFIER_COMPLETION_OVERRIDES = "ovrd";
    public static String CLASSIFIER_EXTDOC_OVERRIDE = "extdoc-ovrd";
    public static String CLASSIFIER_EXTDOC_OVERRIDE_PATTERNS = "extodc-ovrdp";
    public static String CLASSIFIER_EXTDOC_SELF_CALLS = "extdoc-self";

    public static Artifact newArtifact(String coordinate) {
        return new DefaultArtifact(coordinate);
    }

    public static String asCoordinate(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":");
        if (artifact.getExtension() != null) {
            sb.append(artifact.getExtension()).append(":");
        }
        if (artifact.getClassifier() != null) {
            sb.append(artifact.getClassifier()).append(":");
        }
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    public static String guessGroupId(String reverseDomainName) {
        Object[] segments = StringUtils.split((String)reverseDomainName, (String)".");
        RepositoryUtils.removeSlashes((String[])segments);
        Object[] reverse = RepositoryUtils.copyAndReverse((String[])segments);
        InternetDomainName name = InternetDomainName.from((String)StringUtils.join((Object[])reverse, (String)"."));
        if (!name.isUnderPublicSuffix()) {
            return segments[0];
        }
        InternetDomainName topPrivateDomain = name.topPrivateDomain();
        int size = topPrivateDomain.parts().size();
        int end = Math.min(segments.length, size + 1);
        return StringUtils.join((Object[])ArrayUtils.subarray((Object[])segments, (int)0, (int)end), (String)".");
    }

    private static String[] copyAndReverse(String[] segments) {
        Object[] reverse = (String[])segments.clone();
        ArrayUtils.reverse((Object[])reverse);
        return reverse;
    }

    private static void removeSlashes(String[] segments) {
        int i = segments.length;
        while (i-- > 0) {
            segments[i] = StringUtils.replace((String)segments[i], (String)"/", (String)"");
        }
    }

    public static String toArtifactFileName(Artifact artifact) {
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        String classifier = artifact.getClassifier();
        String extension = artifact.getExtension();
        StringBuilder sb = new StringBuilder();
        sb.append(artifactId).append('-').append(version);
        if (!StringUtils.isEmpty((CharSequence)classifier)) {
            sb.append('-').append(classifier);
        }
        sb.append('.').append(extension);
        return sb.toString();
    }

    public static Artifact pom(Artifact a) {
        DefaultArtifact pom = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), null, "pom", a.getVersion());
        return pom;
    }

    public static Artifact newClassifierAndExtension(Artifact a, String classifier, String extension) {
        DefaultArtifact res = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), classifier, extension, a.getVersion());
        return res;
    }
}

