/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.internal.commons.workbench.CommonsWorkbenchPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public class WorkbenchUtil {
    public static final String GROUP_EDIT = "group.edit";
    public static final String GROUP_FILE = "group.file";
    public static final String GROUP_REFRESH = "group.refresh";
    public static final String GROUP_FILTER = "group.filter";
    public static final String GROUP_NAVIGATE = "group.navigate";
    public static final String GROUP_NEW = "group.new";
    public static final String GROUP_OPEN = "group.open";
    public static final String GROUP_PREFERENCES = "group.preferences";
    public static final String GROUP_PROPERTIES = "group.properties";
    public static final String GROUP_RUN = "group.run";
    public static final QualifiedName SHOW_IN_TASKBAR_ICON_PROPERTY = new QualifiedName("org.eclipse.ui.workbench.progress", "inTaskBarIcon");

    public static IViewPart findViewInActiveWindow(String viewId) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.findView(viewId);
        }
        return null;
    }

    public static void closeViewInActiveWindow(String viewId) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            page.hideView(page.findView(viewId));
        }
    }

    public static IViewPart showViewInActiveWindow(String viewId) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                return page.showView(viewId);
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    private static Shell getModalShellExcluding(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            int style;
            Shell shell2 = shellArray[n2];
            if (shell2.equals(shell)) break;
            if (shell2.isVisible() && ((style = shell2.getStyle()) & modal) != 0) {
                return shell2;
            }
            ++n2;
        }
        return null;
    }

    public static Shell getShell() {
        if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        Shell modal = WorkbenchUtil.getModalShellExcluding(null);
        if (modal != null) {
            return modal;
        }
        return WorkbenchUtil.getNonModalShell();
    }

    private static Shell getNonModalShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static final boolean isFiltering() {
        return !PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds().isEmpty();
    }

    public static boolean allowUseOf(Object object) {
        IPluginContribution contribution;
        if (!WorkbenchUtil.isFiltering()) {
            return true;
        }
        if (object instanceof IPluginContribution && (contribution = (IPluginContribution)object).getPluginId() != null) {
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchUtil.createUnifiedId(contribution));
            return identifier.isEnabled();
        }
        if (object instanceof String) {
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier((String)object);
            return identifier.isEnabled();
        }
        return true;
    }

    private static final String createUnifiedId(IPluginContribution contribution) {
        if (contribution.getPluginId() != null) {
            return String.valueOf(contribution.getPluginId()) + '/' + contribution.getLocalId();
        }
        return contribution.getLocalId();
    }

    public static void addDefaultGroups(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator(GROUP_NEW));
        menuManager.add((IContributionItem)new Separator(GROUP_OPEN));
        menuManager.add((IContributionItem)new Separator(GROUP_EDIT));
        menuManager.add((IContributionItem)new Separator(GROUP_FILE));
        menuManager.add((IContributionItem)new Separator(GROUP_RUN));
        menuManager.add((IContributionItem)new Separator(GROUP_NAVIGATE));
        menuManager.add((IContributionItem)new Separator(GROUP_REFRESH));
        menuManager.add((IContributionItem)new Separator(GROUP_FILTER));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator(GROUP_PROPERTIES));
    }

    public static Object openProperties(IServiceLocator serviceLocator) {
        IHandlerService service = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        if (service != null) {
            try {
                return service.executeCommand("org.eclipse.ui.file.properties", null);
            }
            catch (NotEnabledException notEnabledException) {
            }
            catch (Exception e) {
                CommonsWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.workbench", "Opening repository properties failed", (Throwable)e));
            }
        }
        return 8;
    }

    public static void busyCursorWhile(final ICoreRunnable runnable) throws OperationCanceledException, CoreException {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            runnable.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runner);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            CommonsWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.workbench", "Unexpected exception", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    public static void runInUi(ICoreRunnable runnable, ISchedulingRule rule) throws CoreException {
        WorkbenchUtil.runInUi((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), runnable, rule);
    }

    public static void runInUi(IRunnableContext context, final ICoreRunnable runnable, ISchedulingRule rule) throws CoreException {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            runnable.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().runInUI(context, runner, rule);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            CommonsWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.workbench", "Unexpected exception", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    public static Image getWorkbenchShellImage(int maximumHeight) {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null && windows.length > 0 && (workbenchWindow = windows[0]) != null && !workbenchWindow.getShell().isDisposed()) {
            Image image = WorkbenchUtil.getShell().getImage();
            int diff = Integer.MAX_VALUE;
            if (image != null && image.getBounds().height <= maximumHeight) {
                diff = maximumHeight - image.getBounds().height;
            } else {
                image = null;
            }
            Image[] images = WorkbenchUtil.getShell().getImages();
            if (images != null && images.length > 0) {
                Image[] imageArray = images;
                int n = images.length;
                int n2 = 0;
                while (n2 < n) {
                    Image image2 = imageArray[n2];
                    int newDiff = maximumHeight - image2.getBounds().height;
                    if (newDiff >= 0 && newDiff <= diff) {
                        diff = newDiff;
                        image = image2;
                    }
                    ++n2;
                }
            }
            return image;
        }
        return null;
    }
}

