/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.recommenders.utils.HashBag;

public class TreeBag<T>
extends HashBag<T> {
    private Comparator<T> comparator;

    public static <E extends Comparable<E>> TreeBag<E> newTreeBag() {
        return new TreeBag();
    }

    public static <E> TreeBag<E> newTreeBag(Comparator<E> comparator) {
        return new TreeBag<E>(comparator);
    }

    public static <E extends Comparable<E>> TreeBag<E> newTreeBag(Map<E, Integer> values) {
        TreeBag<E> res = new TreeBag<E>();
        res.addAll(values);
        return res;
    }

    protected TreeBag() {
        this.index = new TreeMap();
    }

    protected TreeBag(Comparator<T> comparator) {
        this.comparator = comparator;
        this.index = new TreeMap(comparator);
    }

    @Override
    public TreeSet<T> elements() {
        TreeSet<Object> result = this.comparator == null ? new TreeSet() : new TreeSet<T>(this.comparator);
        result.addAll(this.index.keySet());
        return result;
    }
}

