/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.parser;

import com.google.common.base.Optional;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Version;
import org.eclipse.recommenders.utils.parser.IVersionParser;
import org.eclipse.recommenders.utils.parser.MavenVersionParser;
import org.eclipse.recommenders.utils.parser.OsgiVersionParser;

public class VersionParserFactory {
    private static final IVersionParser[] knownParser = new IVersionParser[]{new OsgiVersionParser(), new MavenVersionParser()};

    public static Optional<IVersionParser> getCompatibleParser(String version) {
        IVersionParser[] iVersionParserArray = knownParser;
        int n = knownParser.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionParser parser = iVersionParserArray[n2];
            if (parser.canParse(version)) {
                return Optional.of((Object)parser);
            }
            ++n2;
        }
        return Optional.absent();
    }

    public static Version parse(String version) {
        Optional<IVersionParser> opt = VersionParserFactory.getCompatibleParser(version);
        Checks.ensureIsTrue(opt.isPresent(), "Given version string '%s' has unknown format and can not be parsed.", version);
        return ((IVersionParser)opt.get()).parse(version);
    }
}

