/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.archetype;

import java.util.Properties;
import org.apache.maven.archetype.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArchetypeCatalogFactory {
    private static final Logger log = LoggerFactory.getLogger(ArchetypeCatalogFactory.class);
    private final String id;
    private final String description;
    private final boolean editable;

    public ArchetypeCatalogFactory(String id, String description, boolean editable) {
        this.id = id;
        this.description = description;
        this.editable = editable;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public abstract ArchetypeCatalog getArchetypeCatalog() throws CoreException;

    public String toString() {
        return this.getId();
    }

    protected Archetype getArchetyper() {
        return MavenPluginActivator.getDefault().getArchetype();
    }

    public static class DefaultLocalCatalogFactory
    extends ArchetypeCatalogFactory {
        public static final String ID = "defaultLocal";

        public DefaultLocalCatalogFactory() {
            super(ID, Messages.ArchetypeCatalogFactory_default_local, false);
        }

        @Override
        public ArchetypeCatalog getArchetypeCatalog() {
            return this.getArchetyper().getDefaultLocalCatalog();
        }
    }

    public static class InternalCatalogFactory
    extends ArchetypeCatalogFactory {
        public static final String ID = "internal";

        public InternalCatalogFactory() {
            super(ID, Messages.ArchetypeCatalogFactory_internal, false);
        }

        @Override
        public ArchetypeCatalog getArchetypeCatalog() {
            return this.getArchetyper().getInternalCatalog();
        }
    }

    public static class LocalCatalogFactory
    extends ArchetypeCatalogFactory {
        public LocalCatalogFactory(String path, String description, boolean editable) {
            super(path, description == null || description.trim().length() == 0 ? NLS.bind((String)Messages.ArchetypeCatalogFactory_local, (Object)path) : description, editable);
        }

        @Override
        public ArchetypeCatalog getArchetypeCatalog() {
            return this.getArchetyper().getLocalCatalog(this.getId());
        }
    }

    public static class NexusIndexerCatalogFactory
    extends ArchetypeCatalogFactory {
        public static final String ID = "nexusIndexer";

        public NexusIndexerCatalogFactory() {
            super(ID, Messages.ArchetypeCatalogFactory_indexer_catalog, false);
        }

        @Override
        public ArchetypeCatalog getArchetypeCatalog() throws CoreException {
            try {
                ArchetypeDataSource source = MavenPluginActivator.getDefault().getArchetypeDataSource("nexus");
                return source.getArchetypeCatalog(new Properties());
            }
            catch (ArchetypeDataSourceException ex) {
                String msg = NLS.bind((String)Messages.ArchetypeCatalogFactory_error_missing_catalog, (Object)ex.getMessage());
                log.error(msg, (Throwable)ex);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg, (Throwable)ex));
            }
        }
    }

    public static class RemoteCatalogFactory
    extends ArchetypeCatalogFactory {
        private String repositoryUrl = null;

        public RemoteCatalogFactory(String url, String description, boolean editable) {
            super(url, description == null || description.trim().length() == 0 ? NLS.bind((String)Messages.ArchetypeCatalogFactory_remote, (Object)url) : description, editable);
            this.repositoryUrl = this.parseCatalogUrl(url);
        }

        private String parseCatalogUrl(String url) {
            if (url == null) {
                return null;
            }
            int length = url.length();
            if (length > 1 && url.endsWith("/")) {
                return url.substring(0, url.length() - 1);
            }
            int idx = url.lastIndexOf("/");
            int n = idx = idx > 0 ? idx : 0;
            if (url.lastIndexOf(".") >= idx) {
                return url.substring(0, idx);
            }
            return url;
        }

        @Override
        public ArchetypeCatalog getArchetypeCatalog() {
            String url = this.getId();
            int idx = url.lastIndexOf("/archetype-catalog.xml");
            if (idx > -1) {
                url = url.substring(0, idx);
            }
            return this.getArchetyper().getRemoteCatalog(url);
        }

        public String getRepositoryUrl() {
            return this.repositoryUrl;
        }
    }
}

