/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.exclude;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.editing.AddDependencyOperation;
import org.eclipse.m2e.core.ui.internal.editing.AddExclusionOperation;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.m2e.core.ui.internal.editing.RemoveDependencyOperation;
import org.eclipse.m2e.refactoring.Messages;
import org.eclipse.osgi.util.NLS;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;

public class ExcludeArtifactRefactoring
extends Refactoring {
    private static final String PLUGIN_ID = "org.eclipse.m2e.refactoring";
    private ArtifactKey[] keys;
    private IFile pomFile;
    private MavenProject exclusionPoint;
    private List<MavenProject> hierarchy;
    private List<Change> changes;

    public ExcludeArtifactRefactoring(IFile pomFile, ArtifactKey[] keys) {
        this.pomFile = pomFile;
        this.keys = keys;
    }

    public void setExclusionPoint(MavenProject exclusionPoint) {
        this.exclusionPoint = exclusionPoint;
    }

    public void setHierarchy(List<MavenProject> hierarchy) {
        this.hierarchy = hierarchy;
    }

    public IMavenProjectFacade getSource() {
        return this.getMavenProjectFacade(this.pomFile);
    }

    protected IMavenProjectFacade getMavenProjectFacade(IFile pom) {
        return MavenPlugin.getMavenProjectRegistry().create(pom, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected IMavenProjectFacade getMavenProjectFacade(MavenProject mavenProject) {
        return MavenPlugin.getMavenProjectRegistry().getMavenProject(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        ArtifactKey[] artifactKeyArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactKey key = artifactKeyArray[n2];
            sb.append(key.toString()).append(',');
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return NLS.bind((String)Messages.MavenExcludeWizard_title, (Object)sb.toString());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.exclusionPoint = this.getMavenProjectFacade(this.pomFile).getMavenProject(pm);
        if (this.exclusionPoint == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.ExcludeArtifactRefactoring_unableToLocateProject);
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.changes = new ArrayList<Change>();
        HashSet locatedKeys = new HashSet();
        ArrayList<Status> statuses = new ArrayList<Status>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)this.getHierarchy().size());
        ArrayList<Object> exclusionOp = new ArrayList<Object>();
        Visitor visitor = this.locate(this.exclusionPoint, (IProgressMonitor)monitor.newChild(1));
        for (Map.Entry<Dependency, Set<ArtifactKey>> entry : visitor.getSourceMap().entrySet()) {
            locatedKeys.addAll(entry.getValue());
            Dependency dependency = entry.getKey();
            if (ExcludeArtifactRefactoring.contains(entry.getValue(), dependency)) {
                exclusionOp.add(new RemoveDependencyOperation(dependency));
                continue;
            }
            for (ArtifactKey artifactKey : entry.getValue()) {
                if (ExcludeArtifactRefactoring.hasExclusion(this.exclusionPoint, dependency, artifactKey)) continue;
                exclusionOp.add(new AddExclusionOperation(dependency, artifactKey));
            }
        }
        for (MavenProject project : this.getDescendants()) {
            visitor = this.locate(project, (IProgressMonitor)monitor.newChild(1));
            ArrayList<RemoveDependencyOperation> operations = new ArrayList<RemoveDependencyOperation>();
            for (Map.Entry entry : visitor.getSourceMap().entrySet()) {
                locatedKeys.addAll((Collection)entry.getValue());
                Dependency dependency = (Dependency)entry.getKey();
                operations.add(new RemoveDependencyOperation(dependency));
                if (ExcludeArtifactRefactoring.contains((Set)entry.getValue(), dependency)) continue;
                if (!this.hasDependency(this.exclusionPoint, dependency)) {
                    exclusionOp.add(new AddDependencyOperation(dependency));
                }
                for (ArtifactKey key : (Set)entry.getValue()) {
                    if (ExcludeArtifactRefactoring.hasExclusion(this.exclusionPoint, dependency, key)) continue;
                    exclusionOp.add(new AddExclusionOperation(dependency, key));
                }
            }
            if (operations.size() <= 0) continue;
            IFile iFile = this.getFile(project);
            this.changes.add((Change)PomHelper.createChange((IFile)iFile, (PomEdits.Operation)new PomEdits.CompoundOperation(operations.toArray(new PomEdits.Operation[operations.size()])), (String)this.getName(iFile)));
        }
        for (MavenProject project : this.getAncestors()) {
            visitor = this.locate(project, (IProgressMonitor)monitor.newChild(1));
            for (Map.Entry<Dependency, Set<ArtifactKey>> entry : this.locate(project, (IProgressMonitor)monitor.newChild(1)).getSourceMap().entrySet()) {
                locatedKeys.addAll(entry.getValue());
                Dependency dependency = entry.getKey();
                if (ExcludeArtifactRefactoring.contains(entry.getValue(), dependency)) {
                    if (project.getFile() == null) continue;
                    statuses.add(new Status(1, PLUGIN_ID, NLS.bind((String)Messages.ExcludeArtifactRefactoring_removeDependencyFrom, (Object)ExcludeArtifactRefactoring.toString(dependency), (Object)this.getMavenProjectFacade(project).getPom().getFullPath())));
                    IFile pom = this.getFile(project);
                    this.changes.add((Change)PomHelper.createChange((IFile)this.getFile(project), (PomEdits.Operation)new RemoveDependencyOperation(dependency), (String)this.getName(pom)));
                    continue;
                }
                exclusionOp.add(new AddDependencyOperation(dependency));
                for (ArtifactKey key : entry.getValue()) {
                    if (ExcludeArtifactRefactoring.hasExclusion(this.exclusionPoint, dependency, key)) continue;
                    exclusionOp.add(new AddExclusionOperation(dependency, key));
                }
            }
        }
        if (!exclusionOp.isEmpty()) {
            IFile pom = this.getFile(this.exclusionPoint);
            this.changes.add((Change)PomHelper.createChange((IFile)pom, (PomEdits.Operation)new PomEdits.CompoundOperation(exclusionOp.toArray(new PomEdits.Operation[exclusionOp.size()])), (String)this.getName(pom)));
        }
        if (statuses.size() == 1) {
            return RefactoringStatus.create((IStatus)((IStatus)statuses.get(0)));
        }
        if (statuses.size() > 1) {
            return RefactoringStatus.create((IStatus)new MultiStatus(PLUGIN_ID, 0, statuses.toArray(new IStatus[statuses.size()]), Messages.ExcludeArtifactRefactoring_errorCreatingRefactoring, null));
        }
        if (locatedKeys.isEmpty()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.ExcludeArtifactRefactoring_noTargets);
        }
        if (locatedKeys.size() != this.keys.length) {
            StringBuilder sb = new StringBuilder();
            Iterator<Object> iterator = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                Iterator<Object> key = iterator[n2];
                if (!locatedKeys.contains(key)) {
                    sb.append(key.toString()).append(',');
                }
                ++n2;
            }
            sb.deleteCharAt(sb.length() - 1);
            return RefactoringStatus.createErrorStatus((String)NLS.bind((String)Messages.ExcludeArtifactRefactoring_failedToLocateArtifact, (Object)sb.toString()));
        }
        return new RefactoringStatus();
    }

    private String getName(IFile file) {
        return file.getName() + " - " + file.getProject().getName();
    }

    private Visitor locate(MavenProject project, IProgressMonitor monitor) throws CoreException {
        DependencyNode root = MavenPlugin.getMavenModelManager().readDependencyTree(project, "test", monitor);
        Visitor visitor = new Visitor(project);
        root.accept((DependencyVisitor)visitor);
        return visitor;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.ExcludeArtifactRefactoring_changeTitle);
        change.addAll(this.changes.toArray(new Change[this.changes.size()]));
        return change;
    }

    private static boolean matches(Dependency d, ArtifactKey a) {
        return d.getArtifactId().equals(a.getArtifactId()) && d.getGroupId().equals(a.getGroupId());
    }

    private static boolean contains(Set<ArtifactKey> keys, Dependency d) {
        for (ArtifactKey key : keys) {
            if (!ExcludeArtifactRefactoring.matches(d, key)) continue;
            return true;
        }
        return false;
    }

    private Collection<MavenProject> getHierarchy() {
        return this.hierarchy;
    }

    private IFile getFile(MavenProject project) throws CoreException {
        IFile res = M2EUtils.getPomFile((MavenProject)project);
        if (res == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)Messages.ExcludeArtifactRefactoring_failedToLocatePom, (Object)project.toString())));
        }
        return res;
    }

    private Collection<MavenProject> getDescendants() {
        ArrayList<MavenProject> descendants = new ArrayList<MavenProject>();
        for (MavenProject project : this.getHierarchy()) {
            if (project == this.exclusionPoint) break;
            descendants.add(project);
        }
        return descendants;
    }

    private Collection<MavenProject> getAncestors() {
        ArrayList<MavenProject> ancestors = new ArrayList<MavenProject>();
        boolean add = false;
        for (MavenProject project : this.getHierarchy()) {
            if (project == this.exclusionPoint) {
                add = !add;
                continue;
            }
            if (!add) continue;
            ancestors.add(project);
        }
        return ancestors;
    }

    private static String toString(Dependency dependency) {
        return NLS.bind((String)"{0}:{1}:{2}", (Object[])new String[]{dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()});
    }

    private boolean hasDependency(MavenProject project, Dependency dependency) {
        if (project.getOriginalModel().getDependencies() == null) {
            return false;
        }
        for (Dependency dep : project.getOriginalModel().getDependencies()) {
            if (!dep.getArtifactId().equals(dependency.getArtifactId()) || !dep.getGroupId().equals(dependency.getGroupId()) || dep.getVersion() != null && !dep.getVersion().equals(dependency.getVersion())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExclusion(MavenProject project, Dependency d, ArtifactKey exclusion) {
        if (project.getOriginalModel().getDependencies() == null) {
            return false;
        }
        Dependency dependency = null;
        for (Dependency dep : project.getOriginalModel().getDependencies()) {
            if (!dep.getArtifactId().equals(d.getArtifactId()) || !dep.getGroupId().equals(d.getGroupId()) || dep.getVersion() != null && !dep.getVersion().equals(d.getVersion())) continue;
            dependency = dep;
            break;
        }
        if (dependency == null || dependency.getExclusions() == null) {
            return false;
        }
        for (Exclusion ex : dependency.getExclusions()) {
            if (!ex.getArtifactId().equals(exclusion.getArtifactId()) || !ex.getGroupId().equals(exclusion.getGroupId())) continue;
            return true;
        }
        return false;
    }

    private class Visitor
    implements DependencyVisitor {
        private List<Dependency> dependencies;
        private Map<Dependency, Set<ArtifactKey>> sourceMap = new HashMap<Dependency, Set<ArtifactKey>>();
        private int depth;
        private DependencyNode topLevel;

        Visitor(MavenProject project) {
            this.dependencies = new ArrayList<Dependency>();
            this.dependencies.addAll(project.getOriginalModel().getDependencies());
        }

        Map<Dependency, Set<ArtifactKey>> getSourceMap() {
            return this.sourceMap;
        }

        public boolean visitLeave(DependencyNode node) {
            --this.depth;
            return true;
        }

        public boolean visitEnter(DependencyNode node) {
            if (this.depth == 1) {
                this.topLevel = node;
            }
            ++this.depth;
            if (node.getDependency() != null) {
                Artifact a = node.getDependency().getArtifact();
                ArtifactKey[] artifactKeyArray = ExcludeArtifactRefactoring.this.keys;
                int n = artifactKeyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtifactKey key = artifactKeyArray[n2];
                    if (a.getGroupId().equals(key.getGroupId()) && a.getArtifactId().equals(key.getArtifactId())) {
                        Dependency dependency;
                        if (this.topLevel != null && (dependency = this.findDependency(this.topLevel)) != null) {
                            this.put(dependency, key);
                        }
                        return true;
                    }
                    ++n2;
                }
            }
            return true;
        }

        private void put(Dependency dep, ArtifactKey key) {
            Set<ArtifactKey> keys = this.sourceMap.get(dep);
            if (keys == null) {
                keys = new HashSet<ArtifactKey>();
                this.sourceMap.put(dep, keys);
            }
            keys.add(key);
        }

        private Dependency findDependency(String groupId, String artifactId) {
            for (Dependency d : this.dependencies) {
                if (!d.getGroupId().equals(groupId) || !d.getArtifactId().equals(artifactId)) continue;
                return d;
            }
            return null;
        }

        private Dependency findDependency(DependencyNode node) {
            Artifact artifact = node.getRelocations().isEmpty() ? node.getDependency().getArtifact() : (Artifact)node.getRelocations().get(0);
            return this.findDependency(artifact.getGroupId(), artifact.getArtifactId());
        }
    }
}

