/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.subwords.l10n;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class Utilities {
    public static final String PREFERENCE_PAGE_EXTENTIONPOINT_ID = "org.eclipse.ui.preferencePages";

    public static String createLinkLabelToPreferencePage(String preferencePageID) {
        String text = Utilities.getNameOfPreferencePage(preferencePageID);
        String categoryID = Utilities.getCategoryOfPreferencePage(preferencePageID);
        while (categoryID != null) {
            text = String.valueOf(Utilities.getNameOfPreferencePage(categoryID)) + " > " + text;
            categoryID = Utilities.getCategoryOfPreferencePage(categoryID);
        }
        if (text == null) {
            return "";
        }
        return text;
    }

    private static String getNameOfPreferencePage(String preferencePageID) {
        return Utilities.getAttributeOfPreferencePage(preferencePageID, "name");
    }

    private static String getCategoryOfPreferencePage(String preferencePageID) {
        return Utilities.getAttributeOfPreferencePage(preferencePageID, "category");
    }

    private static String getAttributeOfPreferencePage(String preferencePageID, String attribute) {
        IConfigurationElement[] elements;
        if (preferencePageID != null && (elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PREFERENCE_PAGE_EXTENTIONPOINT_ID)) != null) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String configId = e.getAttribute("id");
                if (preferencePageID.equalsIgnoreCase(configId)) {
                    String value = e.getAttribute(attribute);
                    return value;
                }
                ++n2;
            }
        }
        return null;
    }
}

