/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.subwords;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContextFactory;
import org.eclipse.recommenders.completion.rcp.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.SessionProcessor;
import org.eclipse.recommenders.internal.completion.rcp.subwords.LCSS;
import org.eclipse.recommenders.internal.completion.rcp.subwords.SubwordsUtils;
import org.eclipse.ui.IEditorPart;

public class SubwordsSessionProcessor
extends SessionProcessor {
    private IRecommendersCompletionContextFactory computer;

    @Inject
    public SubwordsSessionProcessor(IRecommendersCompletionContextFactory ctxFactory) {
        this.computer = ctxFactory;
    }

    public void startSession(IRecommendersCompletionContext crContext) {
        int length = crContext.getPrefix().length();
        if (length == 0) {
            return;
        }
        TreeSet triggerlocations = Sets.newTreeSet();
        ASTNode completionNode = (ASTNode)crContext.getCompletionNode().orNull();
        ASTNode completionNodeParent = (ASTNode)crContext.getCompletionNodeParent().orNull();
        int offset = crContext.getInvocationOffset();
        if (completionNode instanceof CompletionOnSingleTypeReference && completionNodeParent instanceof LocalDeclaration && length > 1) {
            triggerlocations.add(offset - length + 1);
        }
        if (completionNode instanceof CompletionOnSingleNameReference && completionNodeParent instanceof MessageSend && length > 1) {
            triggerlocations.add(offset - length + 1);
        }
        if (completionNode instanceof CompletionOnSingleNameReference && completionNodeParent == null && length > 1) {
            triggerlocations.add(offset - length);
            triggerlocations.add(offset - length + 1);
        } else {
            triggerlocations.add(offset - length);
        }
        JavaContentAssistInvocationContext javaContext = crContext.getJavaContext();
        ICompilationUnit cu = crContext.getCompilationUnit();
        ITextViewer viewer = javaContext.getViewer();
        IEditorPart editor = EditorUtility.isOpenInEditor((Object)cu);
        Map baseProposals = crContext.getProposals();
        HashSet sortkeys = Sets.newHashSet();
        for (IJavaCompletionProposal p : baseProposals.keySet()) {
            sortkeys.add(p.getDisplayString());
        }
        Iterator<Object> iterator = triggerlocations.iterator();
        while (iterator.hasNext()) {
            int trigger = (Integer)iterator.next();
            JavaContentAssistInvocationContext newJavaContext = new JavaContentAssistInvocationContext(viewer, trigger, editor);
            IRecommendersCompletionContext newCrContext = this.computer.create(newJavaContext);
            Map newProposals = newCrContext.getProposals();
            for (IJavaCompletionProposal p : newProposals.keySet()) {
                String displayString = p.getDisplayString();
                String completion = SubwordsUtils.getTokensBetweenLastWhitespaceAndFirstOpeningBracket(displayString);
                if (sortkeys.contains(displayString) || !LCSS.containsSubsequence(completion, crContext.getPrefix())) continue;
                baseProposals.put(p, (CompletionProposal)newProposals.get(p));
                sortkeys.add(p.getDisplayString());
            }
        }
    }

    public void process(IProcessableProposal proposal) {
        proposal.getProposalProcessorManager().addProcessor(new ProposalProcessor(proposal){
            int[] bestSequence = new int[0];
            String matchingArea;
            String prefix;
            {
                this.matchingArea = SubwordsUtils.getTokensBetweenLastWhitespaceAndFirstOpeningBracket(iProcessableProposal.getDisplayString());
            }

            public boolean isPrefix(String prefix) {
                this.prefix = prefix;
                this.bestSequence = LCSS.bestSubsequence(this.matchingArea, prefix);
                return prefix.isEmpty() || this.bestSequence.length > 0;
            }

            public void modifyDisplayString(StyledString displayString) {
                int[] nArray = this.bestSequence;
                int n = this.bestSequence.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    displayString.setStyle(index, 1, StyledString.COUNTER_STYLER);
                    ++n2;
                }
            }

            public int modifyRelevance() {
                if (ArrayUtils.isEmpty((int[])this.bestSequence)) {
                    return 0;
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)this.matchingArea, (CharSequence)this.prefix)) {
                    return 0x40000000;
                }
                return LCSS.scoreSubsequence(this.bestSequence);
            }
        });
    }
}

