/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.IndexListener;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.nexus.IndexedArtifactGroup;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndex;
import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.OpenPomAction;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.m2e.core.ui.internal.views.RepositoryViewContentProvider;
import org.eclipse.m2e.core.ui.internal.views.RepositoryViewLabelProvider;
import org.eclipse.m2e.core.ui.internal.views.nodes.AbstractIndexedRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.IArtifactNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.IndexedArtifactFileNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.LocalRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.RepositoryNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRepositoryView
extends ViewPart {
    private static final String MENU_OPEN_GRP = "open";
    private static final String MENU_UPDATE_GRP = "update";
    private static final Logger log = LoggerFactory.getLogger(MavenRepositoryView.class);
    private static final String ENABLE_FULL = Messages.MavenRepositoryView_enable_full;
    private static final String ENABLED_FULL = Messages.MavenRepositoryView_enabled_full;
    private static final String DISABLE_DETAILS = Messages.MavenRepositoryView_disable_details;
    private static final String DISABLED_DETAILS = Messages.MavenRepositoryView_details_disabled;
    private static final String ENABLE_MIN = Messages.MavenRepositoryView_enable_minimum;
    private static final String ENABLED_MIN = Messages.MavenRepositoryView_minimum_enabled;
    private static final String MENU_ID = ".repositoryViewMenu";
    private IndexManager indexManager = MavenPlugin.getIndexManager();
    private IAction collapseAllAction;
    private IAction reloadSettings;
    BaseSelectionListenerAction openPomAction;
    private BaseSelectionListenerAction updateAction;
    private BaseSelectionListenerAction rebuildAction;
    private DisableIndexAction disableAction;
    private EnableMinIndexAction enableMinAction;
    private EnableFullIndexAction enableFullAction;
    private BaseSelectionListenerAction copyUrlAction;
    TreeViewer viewer;
    private RepositoryViewContentProvider contentProvider;
    private DrillDownAdapter drillDownAdapter;
    private IndexListener indexListener;

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.contentProvider = new RepositoryViewContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        RepositoryViewLabelProvider labelProvider = new RepositoryViewLabelProvider(this.viewer.getTree().getFont());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        this.viewer.setInput((Object)this.getViewSite());
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MavenRepositoryView.this.openPomAction.run();
            }
        });
        this.contributeToActionBars();
        this.indexListener = new IndexListener(){

            public void indexAdded(IRepository repository) {
                MavenRepositoryView.this.refreshView();
            }

            public void indexChanged(IRepository repository) {
                MavenRepositoryView.this.refreshView();
            }

            public void indexRemoved(IRepository repository) {
                MavenRepositoryView.this.refreshView();
            }

            public void indexUpdating(IRepository repository) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).MavenRepositoryView.this.viewer.refresh(true);
                    }
                });
            }
        };
        this.indexManager.addIndexListener(this.indexListener);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu-.repositoryViewMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MavenRepositoryView.this.fillContextMenu(manager);
                manager.update();
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.m2e.core.ui.repositoryViewMenu", menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add(this.collapseAllAction);
        manager.add(this.reloadSettings);
    }

    protected List<AbstractIndexedRepositoryNode> getSelectedRepositoryNodes(List elements) {
        ArrayList<AbstractIndexedRepositoryNode> list = new ArrayList<AbstractIndexedRepositoryNode>();
        if (elements != null) {
            int i = 0;
            while (i < elements.size()) {
                Object elem = elements.get(i);
                if (elem instanceof AbstractIndexedRepositoryNode) {
                    list.add((AbstractIndexedRepositoryNode)elem);
                }
                ++i;
            }
        }
        return list;
    }

    protected List<IArtifactNode> getArtifactNodes(List elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        ArrayList<IArtifactNode> list = new ArrayList<IArtifactNode>();
        int i = 0;
        while (i < elements.size()) {
            Object elem = elements.get(i);
            if (elem instanceof IArtifactNode) {
                IArtifactNode node = (IArtifactNode)elem;
                list.add(node);
            }
            ++i;
        }
        return list;
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator(MENU_OPEN_GRP));
        manager.add((IContributionItem)new Separator(MENU_UPDATE_GRP));
        manager.add((IContributionItem)new Separator("import"));
        manager.prependToGroup(MENU_OPEN_GRP, (IAction)this.copyUrlAction);
        manager.prependToGroup(MENU_OPEN_GRP, (IAction)this.openPomAction);
        manager.prependToGroup(MENU_UPDATE_GRP, (IAction)this.updateAction);
        manager.prependToGroup(MENU_UPDATE_GRP, (IAction)this.rebuildAction);
        manager.add((IAction)this.disableAction);
        manager.add((IAction)this.enableMinAction);
        manager.add((IAction)this.enableFullAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add(this.collapseAllAction);
        manager.add(this.reloadSettings);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.collapseAllAction = new Action(Messages.MavenRepositoryView_btnCollapse){

            public void run() {
                MavenRepositoryView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(Messages.MavenRepositoryView_btnCollapse_tooltip);
        this.collapseAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        this.reloadSettings = new Action(Messages.MavenRepositoryView_action_reload){

            public void run() {
                String msg = Messages.MavenRepositoryView_reload_msg;
                boolean res = MessageDialog.openConfirm((Shell)MavenRepositoryView.this.getViewSite().getShell(), (String)Messages.MavenRepositoryView_reload_title, (String)msg);
                if (res) {
                    WorkspaceJob job = new WorkspaceJob(Messages.MavenRepositoryView_job_reloading){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            try {
                                MavenPlugin.getMaven().reloadSettings();
                            }
                            catch (CoreException ex) {
                                return ex.getStatus();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        };
        this.reloadSettings.setImageDescriptor(MavenImages.REFRESH);
        this.updateAction = new BaseSelectionListenerAction(Messages.MavenRepositoryView_action_update){

            public void run() {
                List<AbstractIndexedRepositoryNode> nodes = MavenRepositoryView.this.getSelectedRepositoryNodes(this.getStructuredSelection().toList());
                for (AbstractIndexedRepositoryNode node : nodes) {
                    if (!(node instanceof RepositoryNode)) continue;
                    ((RepositoryNode)node).getIndex().scheduleIndexUpdate(false);
                }
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                int indexCount = 0;
                for (AbstractIndexedRepositoryNode node : MavenRepositoryView.this.getSelectedRepositoryNodes(selection.toList())) {
                    if (!(node instanceof RepositoryNode) || !node.isEnabledIndex()) continue;
                    ++indexCount;
                }
                if (indexCount > 1) {
                    this.setText(Messages.MavenRepositoryView_update_more);
                } else {
                    this.setText(Messages.MavenRepositoryView_update_one);
                }
                return indexCount > 0;
            }
        };
        this.updateAction.setToolTipText(Messages.MavenRepositoryView_btnUpdate_tooltip);
        this.updateAction.setImageDescriptor(MavenImages.UPD_INDEX);
        this.rebuildAction = new BaseSelectionListenerAction(Messages.MavenRepositoryView_action_rebuild){

            public void run() {
                new Job(Messages.MavenRepositoryView_rebuild_indexes){

                    protected IStatus run(IProgressMonitor monitor) {
                        MavenRepositoryView.this.indexManager.removeIndexListener(MavenRepositoryView.this.indexListener);
                        try {
                            List<AbstractIndexedRepositoryNode> nodes = MavenRepositoryView.this.getSelectedRepositoryNodes(this.getStructuredSelection().toList());
                            if (nodes.size() > 0) {
                                final String title = nodes.size() == 1 ? Messages.MavenRepositoryView_rebuild_title : Messages.MavenRepositoryView_rebuild_title;
                                final String msg = nodes.size() == 1 ? NLS.bind((String)Messages.MavenRepositoryView_rebuild_msg, (Object)nodes.get(0).getIndex().getRepositoryUrl()) : Messages.MavenRepositoryView_rebuild_msg2;
                                final boolean[] result = new boolean[1];
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        result[0] = MessageDialog.openConfirm((Shell)MavenRepositoryView.this.getViewSite().getShell(), (String)title, (String)msg);
                                    }
                                });
                                if (result[0]) {
                                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)nodes.size());
                                    try {
                                        for (AbstractIndexedRepositoryNode node : nodes) {
                                            NexusIndex index = node.getIndex();
                                            if (index != null) {
                                                try {
                                                    index.updateIndex(true, (IProgressMonitor)mon.newChild(1));
                                                }
                                                catch (CoreException ex) {
                                                    log.error(ex.getMessage(), (Throwable)ex);
                                                }
                                                continue;
                                            }
                                            mon.worked(1);
                                        }
                                    }
                                    finally {
                                        mon.done();
                                    }
                                }
                            }
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        finally {
                            MavenRepositoryView.this.indexManager.addIndexListener(MavenRepositoryView.this.indexListener);
                            MavenRepositoryView.this.refreshView();
                        }
                    }
                }.schedule();
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                int indexCount = 0;
                for (AbstractIndexedRepositoryNode node : MavenRepositoryView.this.getSelectedRepositoryNodes(selection.toList())) {
                    if (!(node instanceof LocalRepositoryNode) && !node.isEnabledIndex()) continue;
                    ++indexCount;
                }
                if (indexCount > 1) {
                    this.setText(Messages.MavenRepositoryView_rebuild_many);
                } else {
                    this.setText(Messages.MavenRepositoryView_rebuild_one);
                }
                return indexCount > 0;
            }
        };
        this.rebuildAction.setToolTipText(Messages.MavenRepositoryView_action_rebuild_tooltip);
        this.rebuildAction.setImageDescriptor(MavenImages.REBUILD_INDEX);
        this.disableAction = new DisableIndexAction();
        this.disableAction.setToolTipText(Messages.MavenRepositoryView_action_disable_tooltip);
        this.disableAction.setImageDescriptor(MavenImages.REBUILD_INDEX);
        this.enableMinAction = new EnableMinIndexAction();
        this.enableMinAction.setToolTipText(Messages.MavenRepositoryView_action_enable_tooltip);
        this.enableMinAction.setImageDescriptor(MavenImages.REBUILD_INDEX);
        this.enableFullAction = new EnableFullIndexAction();
        this.enableFullAction.setToolTipText(Messages.MavenRepositoryView_action_enableFull_tooltip);
        this.enableFullAction.setImageDescriptor(MavenImages.REBUILD_INDEX);
        this.openPomAction = new BaseSelectionListenerAction(Messages.MavenRepositoryView_action_open){

            public void run() {
                ISelection selection = MavenRepositoryView.this.viewer.getSelection();
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element instanceof IndexedArtifactFileNode) {
                    IndexedArtifactFile f = ((IndexedArtifactFileNode)element).getIndexedArtifactFile();
                    OpenPomAction.openEditor(f.group, f.artifact, f.version, null);
                }
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                return selection.getFirstElement() instanceof IndexedArtifactFile;
            }
        };
        this.openPomAction.setToolTipText(Messages.MavenRepositoryView_action_open_tooltip);
        this.openPomAction.setImageDescriptor(MavenImages.POM);
        this.copyUrlAction = new BaseSelectionListenerAction(Messages.MavenRepositoryView_action_copy){

            public void run() {
                Object element = this.getStructuredSelection().getFirstElement();
                String url = null;
                if (element instanceof RepositoryNode) {
                    url = ((RepositoryNode)element).getRepositoryUrl();
                } else if (element instanceof IndexedArtifactGroup) {
                    IndexedArtifactGroup group = (IndexedArtifactGroup)element;
                    String repositoryUrl = group.getRepository().getUrl();
                    if (!repositoryUrl.endsWith("/")) {
                        repositoryUrl = String.valueOf(repositoryUrl) + "/";
                    }
                    url = String.valueOf(repositoryUrl) + group.getPrefix().replace('.', '/');
                } else if (!(element instanceof IndexedArtifact)) {
                    boolean cfr_ignored_0 = element instanceof IndexedArtifactFile;
                }
                if (url != null) {
                    Clipboard clipboard = new Clipboard(Display.getCurrent());
                    clipboard.setContents((Object[])new String[]{url}, new Transfer[]{TextTransfer.getInstance()});
                    clipboard.dispose();
                }
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                Object element = selection.getFirstElement();
                return element instanceof RepositoryNode;
            }
        };
        this.copyUrlAction.setToolTipText(Messages.MavenRepositoryView_action_copy_tooltip);
        this.copyUrlAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.openPomAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.updateAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.disableAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.enableMinAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.enableFullAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.rebuildAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.copyUrlAction);
    }

    protected void setIndexDetails(AbstractIndexedRepositoryNode node, String details) {
        if (node != null && node.getIndex() != null) {
            try {
                node.getIndex().setIndexDetails(details);
            }
            catch (CoreException ex) {
                M2EUIUtils.showErrorDialog(this.getViewSite().getShell(), Messages.MavenRepositoryView_error_title, Messages.MavenRepositoryView_error_message, (Exception)((Object)ex));
            }
        }
    }

    protected AbstractIndexedRepositoryNode getSelectedRepositoryNode(IStructuredSelection selection) {
        List elements = selection.toList();
        if (elements.size() != 1) {
            return null;
        }
        Object element = elements.get(0);
        return element instanceof AbstractIndexedRepositoryNode ? (AbstractIndexedRepositoryNode)element : null;
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.copyUrlAction);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.rebuildAction);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.disableAction);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.enableMinAction);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.enableFullAction);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.updateAction);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.openPomAction);
        this.indexManager.removeIndexListener(this.indexListener);
        super.dispose();
    }

    void refreshView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] expandedElems = MavenRepositoryView.this.viewer.getExpandedElements();
                if (!MavenRepositoryView.this.viewer.getControl().isDisposed()) {
                    MavenRepositoryView.this.viewer.setInput((Object)MavenRepositoryView.this.getViewSite());
                    if (expandedElems != null && expandedElems.length > 0) {
                        MavenRepositoryView.this.viewer.setExpandedElements(expandedElems);
                    }
                }
            }
        });
    }

    abstract class AbstractIndexAction
    extends Action
    implements ISelectionChangedListener {
        protected abstract String getDetailsValue();

        protected abstract String getActionText();

        public AbstractIndexAction(String text, int style) {
            super(text, style);
        }

        public void run() {
            IStructuredSelection sel = (IStructuredSelection)MavenRepositoryView.this.viewer.getSelection();
            MavenRepositoryView.this.setIndexDetails(MavenRepositoryView.this.getSelectedRepositoryNode(sel), this.getDetailsValue());
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            this.updateSelection(sel);
        }

        protected void updateSelection(IStructuredSelection selection) {
            AbstractIndexedRepositoryNode node = MavenRepositoryView.this.getSelectedRepositoryNode(selection);
            this.updateIndexDetails(node);
            this.setText(this.getActionText());
            boolean enabled = node != null && node instanceof RepositoryNode;
            this.setEnabled(enabled);
        }

        protected void updateIndexDetails(AbstractIndexedRepositoryNode node) {
            if (node == null || node.getIndex() == null) {
                return;
            }
            NexusIndex index = node.getIndex();
            this.setChecked(this.getDetailsValue().equals(index.getIndexDetails()));
        }
    }

    class DisableIndexAction
    extends AbstractIndexAction {
        public DisableIndexAction() {
            super(DISABLE_DETAILS, 2);
        }

        @Override
        protected String getDetailsValue() {
            return "off";
        }

        @Override
        protected String getActionText() {
            return this.isChecked() ? DISABLED_DETAILS : DISABLE_DETAILS;
        }
    }

    class EnableFullIndexAction
    extends AbstractIndexAction {
        public EnableFullIndexAction() {
            super(ENABLE_FULL, 2);
        }

        @Override
        protected String getDetailsValue() {
            return "full";
        }

        @Override
        protected String getActionText() {
            return this.isChecked() ? ENABLED_FULL : ENABLE_FULL;
        }
    }

    class EnableMinIndexAction
    extends AbstractIndexAction {
        public EnableMinIndexAction() {
            super(ENABLE_MIN, 2);
        }

        @Override
        protected String getDetailsValue() {
            return "min";
        }

        @Override
        protected String getActionText() {
            return this.isChecked() ? ENABLED_MIN : ENABLE_MIN;
        }
    }
}

