/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import org.apache.maven.model.Model;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.conversion.IProjectConversionEnabler;
import org.eclipse.m2e.core.project.conversion.IProjectConversionManager;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenArtifactComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class MavenPomWizardPage
extends AbstractMavenWizardPage {
    private Text projectText;
    private ISelection selection;
    private MavenArtifactComponent pomComponent;
    private IProjectConversionEnabler projectConversionEnabler;

    public MavenPomWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.MavenPomWizardPage_title);
        this.setDescription(Messages.MavenPomWizardPage_desc);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        ModifyListener modifyingListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenPomWizardPage.this.dialogChanged();
            }
        };
        Label label = new Label(container, 0);
        label.setText(Messages.MavenPomWizardPage_lblProject);
        this.projectText = new Text(container, 2060);
        this.projectText.setEditable(false);
        this.projectText.setLayoutData((Object)new GridData(768));
        this.projectText.addModifyListener(modifyingListener);
        this.pomComponent = new MavenArtifactComponent(container, 0);
        this.pomComponent.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.pomComponent.setModifyingListener(modifyingListener);
        this.addFieldWithHistory("groupId", this.pomComponent.getGroupIdCombo());
        this.addFieldWithHistory("artifactId", this.pomComponent.getArtifactIdCombo());
        this.addFieldWithHistory("version", this.pomComponent.getVersionCombo());
        this.addFieldWithHistory("name", this.pomComponent.getNameCombo());
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        String packagingToUse = "jar";
        String[] availablePackagingTypes = MavenArtifactComponent.PACKAGING_OPTIONS;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.projectText.setText(container.getFullPath().toString());
                this.pomComponent.setArtifactId(container.getName());
                this.pomComponent.setGroupId(container.getName());
                if (container instanceof IProject) {
                    IProjectConversionManager pcm = MavenPlugin.getProjectConversionManager();
                    this.projectConversionEnabler = pcm.getConversionEnablerForProject((IProject)container);
                    if (this.projectConversionEnabler != null) {
                        availablePackagingTypes = this.projectConversionEnabler.getPackagingTypes((IProject)container);
                        packagingToUse = availablePackagingTypes[0];
                    }
                }
            }
        }
        this.pomComponent.setVersion("0.0.1-SNAPSHOT");
        this.pomComponent.setPackagingTypes(availablePackagingTypes);
        this.pomComponent.setPackaging(packagingToUse);
        this.pomComponent.setFocus();
    }

    void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.MavenPomWizardPage_dialog_title);
        dialog.showClosedProjects(false);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.projectText.setText(((Path)result[0]).toString());
        }
    }

    void dialogChanged() {
        IStatus status;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getProject()));
        if (this.getProject().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_folder);
            return;
        }
        if (container == null || (container.getType() & 2 | 4) == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_folder2);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.MavenPomWizardPage_error_folder_write);
            return;
        }
        if (container instanceof IProject && this.projectConversionEnabler != null && (status = this.projectConversionEnabler.canBeConverted((IProject)container)).getSeverity() == 4) {
            this.updateStatus(status.getMessage());
            return;
        }
        if (this.pomComponent.getGroupId().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_grid);
        }
        if (this.pomComponent.getArtifactId().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_artid);
        }
        if (this.pomComponent.getVersion().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_version);
        }
        if (this.pomComponent.getPackaging().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_pack);
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getProject() {
        return this.projectText.getText();
    }

    public Model getModel() {
        return this.pomComponent.getModel();
    }
}

