/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.ui.wizards;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptorKind;
import org.eclipse.mylyn.internal.discovery.ui.DiscoveryUi;
import org.eclipse.mylyn.internal.discovery.ui.wizards.ConnectorDiscoveryWizardMainPage;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ConnectorDiscoveryWizard
extends Wizard {
    private ConnectorDiscoveryWizardMainPage mainPage;
    private final Map<ConnectorDescriptorKind, Boolean> connectorDescriptorKindToVisibility = new HashMap<ConnectorDescriptorKind, Boolean>();
    private boolean showConnectorDescriptorKindFilter;
    private boolean showConnectorDescriptorTextFilter;
    private Dictionary<Object, Object> environment;

    public ConnectorDiscoveryWizard() {
        ConnectorDescriptorKind[] connectorDescriptorKindArray = ConnectorDescriptorKind.values();
        int n = connectorDescriptorKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectorDescriptorKind kind = connectorDescriptorKindArray[n2];
            this.connectorDescriptorKindToVisibility.put(kind, true);
            ++n2;
        }
        this.showConnectorDescriptorKindFilter = false;
        this.showConnectorDescriptorTextFilter = true;
        this.setWindowTitle(Messages.ConnectorDiscoveryWizard_connectorDiscovery);
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(CommonImages.BANNER_DISOVERY);
        this.createEnvironment();
    }

    private void createEnvironment() {
        this.environment = new Hashtable<Object, Object>(System.getProperties());
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mylyn.tasks.core");
        Version version = CoreUtil.getVersion((Bundle)bundle);
        this.environment.put("org.eclipse.mylyn.version", version.toString());
        this.environment.put("org.eclipse.mylyn.version.major", version.getMajor());
        this.environment.put("org.eclipse.mylyn.version.minor", version.getMinor());
        this.environment.put("org.eclipse.mylyn.version.micro", version.getMicro());
    }

    public void addPages() {
        this.mainPage = new ConnectorDiscoveryWizardMainPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        return DiscoveryUi.install(this.mainPage.getInstallableConnectors(), (IRunnableContext)this.getContainer());
    }

    public void setVisibility(ConnectorDescriptorKind kind, boolean visible) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        this.connectorDescriptorKindToVisibility.put(kind, visible);
    }

    public boolean isVisible(ConnectorDescriptorKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        return this.connectorDescriptorKindToVisibility.get(kind);
    }

    public boolean isShowConnectorDescriptorKindFilter() {
        return this.showConnectorDescriptorKindFilter;
    }

    public void setShowConnectorDescriptorKindFilter(boolean showConnectorDescriptorKindFilter) {
        this.showConnectorDescriptorKindFilter = showConnectorDescriptorKindFilter;
    }

    public boolean isShowConnectorDescriptorTextFilter() {
        return this.showConnectorDescriptorTextFilter;
    }

    public void setShowConnectorDescriptorTextFilter(boolean showConnectorDescriptorTextFilter) {
        this.showConnectorDescriptorTextFilter = showConnectorDescriptorTextFilter;
    }

    public Dictionary<Object, Object> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Dictionary<Object, Object> environment) {
        if (environment == null) {
            throw new IllegalArgumentException();
        }
        this.environment = environment;
    }
}

