/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;

public class CreateLocalBranchOperation
implements IEGitOperation {
    private final String name;
    private final Repository repository;
    private final Ref ref;
    private final RevCommit commit;
    private final UpstreamConfig upstreamConfig;

    public CreateLocalBranchOperation(Repository repository, String name, Ref ref, UpstreamConfig config) {
        this.name = name;
        this.repository = repository;
        this.ref = ref;
        this.commit = null;
        this.upstreamConfig = config;
    }

    public CreateLocalBranchOperation(Repository repository, String name, RevCommit commit) {
        this.name = name;
        this.repository = repository;
        this.ref = null;
        this.commit = commit;
        this.upstreamConfig = null;
    }

    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                String taskName = NLS.bind((String)CoreText.CreateLocalBranchOperation_CreatingBranchMessage, (Object)CreateLocalBranchOperation.this.name);
                actMonitor.beginTask(taskName, 1);
                Git git = new Git(CreateLocalBranchOperation.this.repository);
                try {
                    if (CreateLocalBranchOperation.this.ref != null) {
                        CreateBranchCommand.SetupUpstreamMode mode = CreateLocalBranchOperation.this.upstreamConfig == UpstreamConfig.NONE ? CreateBranchCommand.SetupUpstreamMode.NOTRACK : CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM;
                        git.branchCreate().setName(CreateLocalBranchOperation.this.name).setStartPoint(CreateLocalBranchOperation.this.ref.getName()).setUpstreamMode(mode).call();
                    } else {
                        git.branchCreate().setName(CreateLocalBranchOperation.this.name).setStartPoint(CreateLocalBranchOperation.this.commit).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK).call();
                    }
                }
                catch (Exception e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
                if (UpstreamConfig.REBASE == CreateLocalBranchOperation.this.upstreamConfig) {
                    StoredConfig config = CreateLocalBranchOperation.this.repository.getConfig();
                    config.setBoolean("branch", CreateLocalBranchOperation.this.name, "rebase", true);
                    try {
                        config.save();
                    }
                    catch (IOException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                }
                actMonitor.worked(1);
                actMonitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpstreamConfig {
        REBASE,
        MERGE,
        NONE;


        public static UpstreamConfig getDefault(Repository repo, String upstreamRefName) {
            boolean setupRebase;
            boolean setupMerge;
            String autosetupMerge = repo.getConfig().getString("branch", null, "autosetupmerge");
            if (autosetupMerge == null) {
                autosetupMerge = "true";
            }
            boolean isLocalBranch = upstreamRefName.startsWith("refs/heads/");
            boolean isRemoteBranch = upstreamRefName.startsWith("refs/remotes/");
            if (!isLocalBranch && !isRemoteBranch) {
                return NONE;
            }
            boolean bl = setupMerge = autosetupMerge.equals("always") || isRemoteBranch && autosetupMerge.equals("true");
            if (!setupMerge) {
                return NONE;
            }
            String autosetupRebase = repo.getConfig().getString("branch", null, "autosetuprebase");
            if (autosetupRebase == null) {
                autosetupRebase = "never";
            }
            boolean bl2 = setupRebase = autosetupRebase.equals("always") || autosetupRebase.equals("local") && isLocalBranch || autosetupRebase.equals("remote") && isRemoteBranch;
            if (setupRebase) {
                return REBASE;
            }
            return MERGE;
        }
    }
}

