using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Enemy : MonoBehaviour
{
    [Header("Inscribed")]
    public float speed = 10f;
    public float fireRate = 0.3f;
    public float health = 10;
    public float score = 100;
    public float powerUpDropChance = 1f; // Chance to drop a PowerUp

    protected bool calledShipDestroyed = false;
    private BoundsCheck bndCheck;

    private void Awake()
    { 
        bndCheck = GetComponent<BoundsCheck>();
    }

    // Property: a method that looks like a field.
    public Vector3 pos
    {
        get
        {
            return this.transform.position;
        }
        set
        {
            this.transform.position = value;
        }
    }


    // Update is called once per frame
    void Update()
    {
        Move();

        // Destroy enemy if not on screen
        if (bndCheck.LocIs(BoundsCheck.eScreenLocs.offDown))
        {
            Destroy(gameObject);
        }
    }

    public virtual void Move()
    {
        // Adjust y value by speed
        Vector3 tempPos = pos;
        tempPos.y -= speed * Time.deltaTime;
        pos = tempPos;
    }

    private void OnCollisionEnter(Collision coll)
    {
        GameObject otherGO = coll.gameObject;

        ProjectileHero p = otherGO.GetComponent<ProjectileHero>();
        if (p != null) // if collided with a projectile
        {
            if (bndCheck.isOnScreen) // Only damage enemy if on screen
            {
                health -= Main.GET_WEAPON_DEFINITION(p.type).damageOnHit;
                if (health <= 0)
                {
                    if (!calledShipDestroyed)
                    {
                        calledShipDestroyed = true;
                        Main.SHIP_DESTROYED(this);
                    }
                    Destroy(this.gameObject);
                }
            }
            Destroy(otherGO); // Destroy projectile
        } 
        else
        {
            print("Enemy hit by non-ProjectileHero: " + otherGO.name);
        }

    }

}
