/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContextFactory;
import org.eclipse.recommenders.internal.completion.rcp.DisableContentAssistCategoryJob;
import org.eclipse.recommenders.internal.completion.rcp.ProcessableCompletionProposalComputer;
import org.eclipse.recommenders.internal.completion.rcp.SessionProcessorDescriptor;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableProposalFactory;

public class RecommendersAllCompletionProposalProcessor
extends ProcessableCompletionProposalComputer {
    private SessionProcessorDescriptor[] descriptors;
    static final String JDT_ALL_CATEGORY = "org.eclipse.jdt.ui.javaAllProposalCategory";
    static final String MYLYN_ALL_CATEGORY = "org.eclipse.mylyn.java.ui.javaAllProposalCategory";
    public static String CATEGORY_ID = "org.eclipse.recommenders.completion.rcp.category.completion.all";

    @Inject
    public RecommendersAllCompletionProposalProcessor(SessionProcessorDescriptor[] descriptors, ProcessableProposalFactory proposalFactory, IRecommendersCompletionContextFactory contextFactory) {
        super(new ProcessableProposalFactory(), contextFactory);
        this.descriptors = descriptors;
    }

    @Override
    public void sessionStarted() {
        super.sessionStarted();
        this.processors.clear();
        SessionProcessorDescriptor[] sessionProcessorDescriptorArray = this.descriptors;
        int n = this.descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            SessionProcessorDescriptor d = sessionProcessorDescriptorArray[n2];
            if (d.isEnabled()) {
                this.processors.add(d.getProcessor());
            }
            ++n2;
        }
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!this.shouldReturnResults()) {
            return Collections.emptyList();
        }
        return super.computeCompletionProposals(context, monitor);
    }

    @VisibleForTesting
    protected boolean shouldReturnResults() {
        HashSet cats = Sets.newHashSet((Object[])PreferenceConstants.getExcludedCompletionProposalCategories());
        if (cats.contains(CATEGORY_ID)) {
            return true;
        }
        if (this.isJdtAllEnabled(cats) || this.isMylynInstalledAndEnabled(cats)) {
            new DisableContentAssistCategoryJob(CATEGORY_ID).schedule(300L);
            return false;
        }
        return true;
    }

    private boolean isMylynInstalledAndEnabled(Set<String> cats) {
        return RecommendersAllCompletionProposalProcessor.isMylynInstalled() && !cats.contains(MYLYN_ALL_CATEGORY);
    }

    private boolean isJdtAllEnabled(Set<String> cats) {
        return !cats.contains(JDT_ALL_CATEGORY);
    }

    public static boolean isMylynInstalled() {
        CompletionProposalComputerRegistry reg = CompletionProposalComputerRegistry.getDefault();
        for (CompletionProposalCategory cat : reg.getProposalCategories()) {
            if (!cat.getId().equals(MYLYN_ALL_CATEGORY)) continue;
            return true;
        }
        return false;
    }
}

