/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp;

import com.google.common.base.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class CompilerBindings {
    public static Optional<ITypeName> toTypeName(Binding b) {
        if (b instanceof TypeBinding) {
            return CompilerBindings.toTypeName((TypeBinding)b);
        }
        if (b instanceof VariableBinding) {
            TypeBinding type = ((VariableBinding)b).type;
            return CompilerBindings.toTypeName(type);
        }
        return Optional.absent();
    }

    public static Optional<ITypeName> toTypeName(TypeBinding binding) {
        String signature;
        if (binding == null) {
            return Optional.absent();
        }
        binding.isBoundParameterizedType();
        binding.isParameterizedType();
        if (binding.isArrayType()) {
            int dimensions = binding.dimensions();
            TypeBinding leafComponentType = binding.leafComponentType();
            String arrayDimensions = StringUtils.repeat((String)"[", (int)dimensions);
            Optional<ITypeName> typeName = CompilerBindings.toTypeName(leafComponentType);
            if (!typeName.isPresent()) {
                return Optional.absent();
            }
            VmTypeName res = VmTypeName.get((String)(String.valueOf(arrayDimensions) + ((ITypeName)typeName.get()).getIdentifier()));
            return Optional.fromNullable((Object)res);
        }
        if (binding instanceof TypeVariableBinding) {
            TypeVariableBinding generic = (TypeVariableBinding)binding;
            if (generic.declaringElement instanceof TypeBinding) {
                binding = (TypeBinding)generic.declaringElement;
            } else if (generic.superclass != null) {
                binding = generic.superclass;
            }
        }
        if ((signature = String.valueOf(binding.genericTypeSignature())).length() != 1) {
            signature = signature.endsWith(";") ? StringUtils.substringBeforeLast((String)signature, (String)";") : "L" + SignatureUtil.stripSignatureToFQN((String)signature);
        }
        VmTypeName res = VmTypeName.get((String)signature);
        return Optional.fromNullable((Object)res);
    }

    public static Optional<IMethodName> toMethodName(MethodBinding binding) {
        if (binding == null) {
            return Optional.absent();
        }
        try {
            String uniqueKey = String.valueOf(binding.computeUniqueKey());
            String qualifiedMethodName = StringUtils.substringBefore((String)uniqueKey, (String)"(").replace(";.", ".");
            if (qualifiedMethodName.endsWith(".")) {
                qualifiedMethodName = String.valueOf(qualifiedMethodName) + new String(TypeConstants.INIT);
            }
            String[] parameterTypes = Signature.getParameterTypes((String)uniqueKey);
            String returnType = Signature.getReturnType((String)uniqueKey);
            StringBuilder sb = new StringBuilder();
            sb.append(qualifiedMethodName).append("(");
            String[] stringArray = parameterTypes;
            int n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                sb.append(parameter);
                ++n2;
            }
            sb.append(")").append(returnType);
            VmMethodName res = VmMethodName.get((String)sb.toString());
            return Optional.of((Object)res);
        }
        catch (RuntimeException runtimeException) {
            return Optional.absent();
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static Optional<ITypeName> toTypeName(TypeReference type) {
        return type == null ? Optional.absent() : CompilerBindings.toTypeName(type.resolvedType);
    }

    public static Optional<Binding> getBinding(ASTNode node) {
        FieldBinding b = null;
        if (node instanceof FieldDeclaration) {
            FieldDeclaration f = (FieldDeclaration)node;
            b = f.binding;
        } else if (node instanceof MethodDeclaration) {
            MethodDeclaration d = (MethodDeclaration)node;
            b = d.binding;
        } else if (node instanceof LocalDeclaration) {
            LocalDeclaration l = (LocalDeclaration)node;
            b = l.binding;
        } else if (node instanceof TypeParameter) {
            TypeParameter t = (TypeParameter)node;
            b = t.binding;
        }
        return Optional.fromNullable((Object)b);
    }

    public static Optional<String> getVariableName(Binding node) {
        if (node == null) {
            return Optional.absent();
        }
        switch (node.kind()) {
            case 1: 
            case 2: {
                return Optional.of((Object)String.valueOf(node.shortReadableName()));
            }
        }
        return Optional.absent();
    }
}

