/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaMonitorThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwningThread;

public class JavaContendedMonitor
extends PlatformObject
implements IDebugElement,
ITerminate,
ISuspendResume {
    private JavaMonitor fMonitor;
    private JavaOwningThread fOwningThread;
    private JavaOwningThread fParent;

    public JavaContendedMonitor(JavaMonitor monitor, JavaOwningThread parent) {
        this.fMonitor = monitor;
        monitor.addElement(this);
        this.fParent = parent;
    }

    public JavaMonitor getMonitor() {
        return this.fMonitor;
    }

    public Object getParent() {
        if (this.fParent.getParent() == null) {
            return this.fParent.getThread().getOriginalThread();
        }
        return this.fParent;
    }

    public JavaOwningThread getOwningThread() {
        JavaMonitorThread owningThread = this.fMonitor.getOwningThread0();
        if (owningThread == null) {
            this.fOwningThread = null;
        } else if (this.fOwningThread == null || this.fOwningThread.getThread() != owningThread) {
            this.fOwningThread = new JavaOwningThread(owningThread, this);
        }
        return this.fOwningThread;
    }

    public String getModelIdentifier() {
        return this.fMonitor.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fMonitor.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.fMonitor.getLaunch();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IDebugTarget.class) {
            return this.getDebugTarget();
        }
        if (adapter.equals(ILaunchConfiguration.class)) {
            return this.getLaunch().getLaunchConfiguration();
        }
        return super.getAdapter(adapter);
    }

    protected IThread getParentThread() {
        Object parent = this.getParent();
        IThread thread = null;
        if (parent instanceof IThread) {
            thread = (IThread)parent;
        } else if (parent instanceof JavaOwningThread) {
            thread = ((JavaOwningThread)((Object)parent)).getThread().getOriginalThread();
        }
        return thread;
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public boolean canResume() {
        IThread originalThread;
        JavaOwningThread owningThread = this.getOwningThread();
        if (owningThread != null && (originalThread = owningThread.getThread().getOriginalThread()) != null) {
            return originalThread.canResume();
        }
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        IThread originalThread;
        JavaOwningThread owningThread = this.getOwningThread();
        if (owningThread != null && (originalThread = owningThread.getThread().getOriginalThread()) != null) {
            return originalThread.isSuspended();
        }
        return false;
    }

    public void resume() throws DebugException {
        this.getOwningThread().getThread().getOriginalThread().resume();
    }

    public void suspend() throws DebugException {
        this.getOwningThread().getThread().getOriginalThread().suspend();
    }
}

