/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.AbstractFloatCollection;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.FloatList;
import org.apache.commons.collections.primitives.FloatListIterator;

public abstract class RandomAccessFloatList
extends AbstractFloatCollection
implements FloatList {
    private int _modCount = 0;

    protected RandomAccessFloatList() {
    }

    public abstract float get(int var1);

    public abstract int size();

    public float removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    public float set(int index, float element) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, float element) {
        throw new UnsupportedOperationException();
    }

    public boolean add(float element) {
        this.add(this.size(), element);
        return true;
    }

    public boolean addAll(int index, FloatCollection collection) {
        boolean modified = false;
        FloatIterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
            modified = true;
        }
        return modified;
    }

    public int indexOf(float element) {
        int i = 0;
        FloatIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(float element) {
        FloatListIterator iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            if (iter.previous() != element) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    public FloatIterator iterator() {
        return this.listIterator();
    }

    public FloatListIterator listIterator() {
        return this.listIterator(0);
    }

    public FloatListIterator listIterator(int index) {
        return new RandomAccessFloatListIterator(this, index);
    }

    public FloatList subList(int fromIndex, int toIndex) {
        return new RandomAccessFloatSubList(this, fromIndex, toIndex);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof FloatList) {
            FloatList thatList = (FloatList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            FloatIterator thatIter = thatList.iterator();
            FloatIterator thisIter = this.iterator();
            while (thisIter.hasNext()) {
                if (thisIter.next() == thatIter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        FloatIterator iter = this.iterator();
        while (iter.hasNext()) {
            hash = 31 * hash + Float.floatToIntBits(iter.next());
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        FloatIterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    private static class ComodChecker {
        private RandomAccessFloatList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessFloatList source) {
            this._source = source;
            this.resyncModCount();
        }

        protected RandomAccessFloatList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }

    protected static class RandomAccessFloatListIterator
    extends ComodChecker
    implements FloatListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessFloatListIterator(RandomAccessFloatList list, int index) {
            super(list);
            if (index < 0 || index > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + index + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = index;
            this.resyncModCount();
        }

        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        public float next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            float val = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return val;
        }

        public float previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            float val = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return val;
        }

        public void add(float value) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, value);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        public void remove() {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().removeElementAt(this._lastReturnedIndex);
            this._lastReturnedIndex = -1;
            --this._nextIndex;
            this.resyncModCount();
        }

        public void set(float value) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, value);
            this.resyncModCount();
        }
    }

    protected static class RandomAccessFloatSubList
    extends RandomAccessFloatList
    implements FloatList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessFloatList _list = null;
        private ComodChecker _comod = null;

        RandomAccessFloatSubList(RandomAccessFloatList list, int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > list.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException();
            }
            this._list = list;
            this._offset = fromIndex;
            this._limit = toIndex - fromIndex;
            this._comod = new ComodChecker(list);
            this._comod.resyncModCount();
        }

        public float get(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(index));
        }

        public float removeElementAt(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            float val = this._list.removeElementAt(this.toUnderlyingIndex(index));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return val;
        }

        public float set(int index, float element) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            float val = this._list.set(this.toUnderlyingIndex(index), element);
            this.incrModCount();
            this._comod.resyncModCount();
            return val;
        }

        public void add(int index, float element) {
            this.checkRangeIncludingEndpoint(index);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(index), element);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int index) {
            return index + this._offset;
        }
    }
}

