/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.FilterRepositorySystemSession;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.embedder.ReadonlyMavenExecutionRequest;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.transfer.TransferListener;

public class MavenExecutionContext
implements IMavenExecutionContext {
    private static final ThreadLocal<Deque<MavenExecutionContext>> context = new ThreadLocal();
    private final MavenImpl maven;
    private MavenExecutionRequest request;
    private ArtifactRepository localRepository;
    private FilterRepositorySystemSession repositorySession;
    private MavenSession mavenSession;

    public MavenExecutionContext(MavenImpl maven) {
        this.maven = maven;
    }

    @Override
    public MavenExecutionRequest getExecutionRequest() throws CoreException {
        if (this.request != null && this.mavenSession != null) {
            return new ReadonlyMavenExecutionRequest(this.request);
        }
        if (this.request == null) {
            this.request = this.newExecutionRequest();
        }
        return this.request;
    }

    protected MavenExecutionRequest newExecutionRequest() throws CoreException {
        MavenExecutionRequest request = null;
        Deque<MavenExecutionContext> stack = context.get();
        if (stack != null && !stack.isEmpty()) {
            MavenExecutionRequest parent = stack.peek().request;
            if (parent == null) {
                throw new IllegalStateException();
            }
            request = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)parent);
        }
        if (request == null) {
            request = this.maven.createExecutionRequest();
        }
        return request;
    }

    @Override
    public <V> V execute(ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        return this.execute(null, callable, monitor);
    }

    @Override
    public <V> V execute(MavenProject project, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        MavenExecutionContext parent;
        Deque<MavenExecutionContext> stack = context.get();
        if (stack == null) {
            stack = new ArrayDeque<MavenExecutionContext>();
            context.set(stack);
        }
        if (this == (parent = stack.peek())) {
            return this.executeBare(project, callable, monitor);
        }
        ArtifactRepository origlocalRepository = this.localRepository;
        FilterRepositorySystemSession origRepositorySession = this.repositorySession;
        MavenSession origMavenSession = this.mavenSession;
        MavenExecutionRequest origRequest = this.request;
        if (this.request == null && parent != null) {
            this.request = parent.request;
            this.localRepository = parent.localRepository;
            this.repositorySession = parent.repositorySession;
            this.mavenSession = parent.mavenSession;
        } else {
            if (this.request == null) {
                this.request = this.newExecutionRequest();
            }
            this.maven.populateDefaults(this.request);
            MavenExecutionContext.populateSystemProperties(this.request);
            this.localRepository = this.request.getLocalRepository();
            this.repositorySession = this.maven.createRepositorySession(this.request);
            if (parent != null) {
                this.repositorySession.setData(parent.repositorySession.getData());
            }
            DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
            this.mavenSession = new MavenSession(this.maven.getPlexusContainer(), (RepositorySystemSession)this.repositorySession, this.request, (MavenExecutionResult)result);
        }
        LegacySupport legacySupport = this.maven.lookup(LegacySupport.class);
        MavenSession origLegacySession = legacySupport.getSession();
        stack.push(this);
        legacySupport.setSession(this.mavenSession);
        try {
            V v = this.executeBare(project, callable, monitor);
            return v;
        }
        finally {
            stack.pop();
            if (stack.isEmpty()) {
                context.set(null);
            }
            legacySupport.setSession(origLegacySession);
            this.mavenSession = origMavenSession;
            this.repositorySession = origRepositorySession;
            this.localRepository = origlocalRepository;
            this.request = origRequest;
        }
    }

    private <V> V executeBare(MavenProject project, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        V v;
        TransferListener origTransferListener = this.repositorySession.setTransferListener(this.maven.createArtifactTransferListener(monitor));
        MavenProject origProject = this.mavenSession.getCurrentProject();
        List origProjects = this.mavenSession.getProjects();
        try {
            if (project != null) {
                this.mavenSession.setCurrentProject(project);
                this.mavenSession.setProjects(Collections.singletonList(project));
            }
            v = callable.call(this, monitor);
            this.repositorySession.setTransferListener(origTransferListener);
        }
        catch (Throwable throwable) {
            this.repositorySession.setTransferListener(origTransferListener);
            if (project != null) {
                this.mavenSession.setCurrentProject(origProject);
                this.mavenSession.setProjects(origProjects != null ? origProjects : Collections.emptyList());
            }
            throw throwable;
        }
        if (project != null) {
            this.mavenSession.setCurrentProject(origProject);
            this.mavenSession.setProjects(origProjects != null ? origProjects : Collections.emptyList());
        }
        return v;
    }

    @Override
    public MavenSession getSession() {
        if (this.mavenSession == null) {
            throw new IllegalStateException();
        }
        return this.mavenSession;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        if (this.mavenSession == null) {
            throw new IllegalStateException();
        }
        return this.localRepository;
    }

    @Override
    public RepositorySystemSession getRepositorySession() {
        if (this.mavenSession == null) {
            throw new IllegalStateException();
        }
        return this.repositorySession;
    }

    public static MavenExecutionContext getThreadContext() {
        Deque<MavenExecutionContext> stack = context.get();
        return stack != null ? stack.peek() : null;
    }

    public static void populateSystemProperties(MavenExecutionRequest request) {
        Properties systemProperties = new Properties();
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        systemProperties.putAll((Map<?, ?>)System.getProperties());
        request.setSystemProperties(systemProperties);
    }

    @Override
    public ProjectBuildingRequest newProjectBuildingRequest() {
        DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest();
        projectBuildingRequest.setLocalRepository(this.getLocalRepository());
        projectBuildingRequest.setRepositorySession(this.getRepositorySession());
        projectBuildingRequest.setSystemProperties(this.request.getSystemProperties());
        projectBuildingRequest.setUserProperties(this.request.getUserProperties());
        projectBuildingRequest.setRemoteRepositories(this.request.getRemoteRepositories());
        projectBuildingRequest.setPluginArtifactRepositories(this.request.getPluginArtifactRepositories());
        projectBuildingRequest.setActiveProfileIds(this.request.getActiveProfiles());
        projectBuildingRequest.setInactiveProfileIds(this.request.getInactiveProfiles());
        projectBuildingRequest.setProfiles(this.request.getProfiles());
        projectBuildingRequest.setProcessPlugins(true);
        projectBuildingRequest.setBuildStartTime(this.request.getStartTime());
        return projectBuildingRequest;
    }
}

