/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.utils.Version;

public class ClasspathEntryInfo {
    public static final ClasspathEntryInfo NULL = new ClasspathEntryInfo();
    public static final String P_LAST_MOD = "modificationDate";
    public static final String P_LOCATION = "location";
    public static final String P_FINGERPRINT = "fingerprint";
    public static final String P_VERSION = "version";
    public static final String P_SYMBOLIC_NAME = "symbolicName";
    private String symbolicName;
    private Version version = Version.UNKNOWN;
    private String jarFileFingerprint;
    private Date jarFileModificationDate;
    private File location;
    private transient PropertyChangeSupport chg = new PropertyChangeSupport(this);
    private boolean javaRuntime;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }

    public static ClasspathEntryInfo create(String symbolicName, Version version, String jarFingerprint, File location) {
        ClasspathEntryInfo res = new ClasspathEntryInfo();
        res.setSymbolicName(symbolicName);
        res.setVersion(version);
        res.setFingerprint(jarFingerprint);
        res.setLocation(location);
        return res;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.chg.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.chg.removePropertyChangeListener(listener);
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String newSymbolicName) {
        this.symbolicName = newSymbolicName;
        this.chg.firePropertyChange(P_SYMBOLIC_NAME, this.symbolicName, this.symbolicName);
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version newVersion) {
        this.version = newVersion;
        this.chg.firePropertyChange(P_VERSION, this.version, this.version);
    }

    public String getFingerprint() {
        return this.jarFileFingerprint;
    }

    public void setFingerprint(String newFingerprint) {
        this.jarFileFingerprint = newFingerprint;
        this.chg.firePropertyChange(P_FINGERPRINT, this.jarFileFingerprint, this.jarFileFingerprint);
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File newLocation) {
        this.location = newLocation;
        this.chg.firePropertyChange(P_LOCATION, this.location, this.location);
    }

    public Date getModificationDate() {
        return this.jarFileModificationDate;
    }

    public void setModificationDate(Date newModificationDate) {
        this.jarFileModificationDate = newModificationDate;
        this.chg.firePropertyChange(P_LAST_MOD, this.jarFileModificationDate, this.jarFileModificationDate);
    }

    public void setJavaRuntime(boolean partOfJavaRuntime) {
        this.javaRuntime = partOfJavaRuntime;
    }

    public boolean isJavaRuntime() {
        return this.javaRuntime;
    }
}

