/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.chain.ui;

import com.google.common.base.Joiner;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.recommenders.completion.rcp.chain.l10n.Messages;
import org.eclipse.recommenders.internal.completion.rcp.chain.ChainCompletionPlugin;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ChainPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID_MAX_CHAINS = "recommenders.chain.max_chains";
    public static final String ID_MIN_DEPTH = "recommenders.chain.min_chain_length";
    public static final String ID_MAX_DEPTH = "recommenders.chain.max_chain_length";
    public static final String ID_TIMEOUT = "recommenders.chain.timeout";
    public static final String ID_IGNORE_TYPES = "recommenders.chain.ignore_types";
    public static final char IGNORE_TYPES_SEPARATOR = '|';

    public ChainPreferencePage() {
        super(1);
        this.setPreferenceStore(ChainCompletionPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.PREFPAGE_DESCRIPTION);
    }

    protected void createFieldEditors() {
        this.addField(ID_MAX_CHAINS, Messages.PREFPAGE_MAX_CHAINS, 1, 99);
        this.addField(ID_MIN_DEPTH, Messages.PREFPAGE_MIN_CHAIN_DEPTH, 1, 10);
        this.addField(ID_MAX_DEPTH, Messages.PREFPAGE_MAX_CHAIN_DEPTH, 1, 10);
        this.addField(ID_TIMEOUT, Messages.PREFPAGE_SEARCH_TIMEOUT, 1, 99);
        this.addField((FieldEditor)new IgnoredTypesEditor(Messages.PREFPAGE_IGNORED_OBJECT_TYPES, this.getFieldEditorParent()));
        this.addText(Messages.PREFPAGE_IGNORE_CONSEQUENCES);
    }

    private void addField(String name, String labeltext, int min, int max) {
        IntegerFieldEditor field = new IntegerFieldEditor(name, labeltext, this.getFieldEditorParent());
        field.setValidRange(min, max);
        this.addField((FieldEditor)field);
    }

    private void addText(String text) {
        Label label = new Label(this.getFieldEditorParent(), 64);
        label.setText(text);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
    }

    public void init(IWorkbench workbench) {
    }

    private static final class IgnoredTypesEditor
    extends ListEditor {
        IgnoredTypesEditor(String label, Composite parent) {
            super(ChainPreferencePage.ID_IGNORE_TYPES, label, parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
        }

        protected String[] parseString(String stringList) {
            this.getUpButton().setVisible(false);
            this.getDownButton().setVisible(false);
            return stringList.split("\\|");
        }

        protected String getNewInputObject() {
            SelectionDialog dialog;
            block3: {
                try {
                    dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false);
                    if (dialog.open() != 1) break block3;
                    return null;
                }
                catch (JavaModelException e) {
                    Throws.throwIllegalArgumentException((String)e.getMessage());
                    return null;
                }
            }
            return ((IType)dialog.getResult()[0]).getFullyQualifiedName();
        }

        protected String createList(String[] items) {
            return Joiner.on((char)'|').join((Object[])items);
        }
    }
}

