/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.ArrayCharList;
import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.CharList;
import org.apache.commons.collections.primitives.CharListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableCharIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableCharList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableCharListIterator;

public final class CharCollections {
    public static final CharList EMPTY_CHAR_LIST = CharCollections.unmodifiableCharList(new ArrayCharList(0));
    public static final CharIterator EMPTY_CHAR_ITERATOR = CharCollections.unmodifiableCharIterator(EMPTY_CHAR_LIST.iterator());
    public static final CharListIterator EMPTY_CHAR_LIST_ITERATOR = CharCollections.unmodifiableCharListIterator(EMPTY_CHAR_LIST.listIterator());

    public static CharList singletonCharList(char value) {
        ArrayCharList list = new ArrayCharList(1);
        list.add(value);
        return UnmodifiableCharList.wrap(list);
    }

    public static CharIterator singletonCharIterator(char value) {
        return CharCollections.singletonCharList(value).iterator();
    }

    public static CharListIterator singletonCharListIterator(char value) {
        return CharCollections.singletonCharList(value).listIterator();
    }

    public static CharList unmodifiableCharList(CharList list) throws NullPointerException {
        if (list == null) {
            throw new NullPointerException();
        }
        return UnmodifiableCharList.wrap(list);
    }

    public static CharIterator unmodifiableCharIterator(CharIterator iter) {
        if (iter == null) {
            throw new NullPointerException();
        }
        return UnmodifiableCharIterator.wrap(iter);
    }

    public static CharListIterator unmodifiableCharListIterator(CharListIterator iter) {
        if (iter == null) {
            throw new NullPointerException();
        }
        return UnmodifiableCharListIterator.wrap(iter);
    }

    public static CharList getEmptyCharList() {
        return EMPTY_CHAR_LIST;
    }

    public static CharIterator getEmptyCharIterator() {
        return EMPTY_CHAR_ITERATOR;
    }

    public static CharListIterator getEmptyCharListIterator() {
        return EMPTY_CHAR_LIST_ITERATOR;
    }
}

