/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.adapters.FloatCollectionCollection;
import org.apache.commons.collections.primitives.adapters.IteratorFloatIterator;

abstract class AbstractCollectionFloatCollection
implements FloatCollection {
    protected AbstractCollectionFloatCollection() {
    }

    @Override
    public boolean add(float element) {
        return this.getCollection().add(new Float(element));
    }

    @Override
    public boolean addAll(FloatCollection c) {
        return this.getCollection().addAll(FloatCollectionCollection.wrap(c));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(float element) {
        return this.getCollection().contains(new Float(element));
    }

    @Override
    public boolean containsAll(FloatCollection c) {
        return this.getCollection().containsAll(FloatCollectionCollection.wrap(c));
    }

    public String toString() {
        return this.getCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    public FloatIterator iterator() {
        return IteratorFloatIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(float element) {
        return this.getCollection().remove(new Float(element));
    }

    @Override
    public boolean removeAll(FloatCollection c) {
        return this.getCollection().removeAll(FloatCollectionCollection.wrap(c));
    }

    @Override
    public boolean retainAll(FloatCollection c) {
        return this.getCollection().retainAll(FloatCollectionCollection.wrap(c));
    }

    @Override
    public int size() {
        return this.getCollection().size();
    }

    @Override
    public float[] toArray() {
        Object[] src = this.getCollection().toArray();
        float[] dest = new float[src.length];
        int i = 0;
        while (i < src.length) {
            dest[i] = ((Number)src[i]).floatValue();
            ++i;
        }
        return dest;
    }

    @Override
    public float[] toArray(float[] dest) {
        Object[] src = this.getCollection().toArray();
        if (dest.length < src.length) {
            dest = new float[src.length];
        }
        int i = 0;
        while (i < src.length) {
            dest[i] = ((Number)src[i]).floatValue();
            ++i;
        }
        return dest;
    }

    protected abstract Collection getCollection();
}

