/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongIterator;
import org.apache.commons.collections.primitives.LongList;
import org.apache.commons.collections.primitives.LongListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionLongCollection;
import org.apache.commons.collections.primitives.adapters.ListIteratorLongListIterator;
import org.apache.commons.collections.primitives.adapters.ListLongList;
import org.apache.commons.collections.primitives.adapters.LongCollectionCollection;

abstract class AbstractListLongList
extends AbstractCollectionLongCollection
implements LongList {
    AbstractListLongList() {
    }

    @Override
    public void add(int index, long element) {
        this.getList().add(index, new Long(element));
    }

    @Override
    public boolean addAll(int index, LongCollection collection) {
        return this.getList().addAll(index, LongCollectionCollection.wrap(collection));
    }

    @Override
    public long get(int index) {
        return ((Number)this.getList().get(index)).longValue();
    }

    @Override
    public int indexOf(long element) {
        return this.getList().indexOf(new Long(element));
    }

    @Override
    public int lastIndexOf(long element) {
        return this.getList().lastIndexOf(new Long(element));
    }

    @Override
    public LongListIterator listIterator() {
        return ListIteratorLongListIterator.wrap(this.getList().listIterator());
    }

    @Override
    public LongListIterator listIterator(int index) {
        return ListIteratorLongListIterator.wrap(this.getList().listIterator(index));
    }

    @Override
    public long removeElementAt(int index) {
        return ((Number)this.getList().remove(index)).longValue();
    }

    @Override
    public long set(int index, long element) {
        return ((Number)this.getList().set(index, new Long(element))).longValue();
    }

    @Override
    public LongList subList(int fromIndex, int toIndex) {
        return ListLongList.wrap(this.getList().subList(fromIndex, toIndex));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LongList) {
            LongList that = (LongList)obj;
            if (this == that) {
                return true;
            }
            if (this.size() != that.size()) {
                return false;
            }
            LongIterator thisiter = this.iterator();
            LongIterator thatiter = that.iterator();
            while (thisiter.hasNext()) {
                if (thisiter.next() == thatiter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getList().hashCode();
    }

    @Override
    protected final Collection getCollection() {
        return this.getList();
    }

    protected abstract List getList();
}

