/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import org.apache.commons.collections.primitives.FloatListIterator;
import org.apache.commons.collections.primitives.decorators.ProxyFloatListIterator;

public final class UnmodifiableFloatListIterator
extends ProxyFloatListIterator {
    private FloatListIterator proxied = null;

    UnmodifiableFloatListIterator(FloatListIterator iterator) {
        this.proxied = iterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This FloatListIterator is not modifiable.");
    }

    @Override
    public void add(float value) {
        throw new UnsupportedOperationException("This FloatListIterator is not modifiable.");
    }

    @Override
    public void set(float value) {
        throw new UnsupportedOperationException("This FloatListIterator is not modifiable.");
    }

    @Override
    protected FloatListIterator getListIterator() {
        return this.proxied;
    }

    public static final FloatListIterator wrap(FloatListIterator iterator) {
        if (iterator == null) {
            return null;
        }
        if (iterator instanceof UnmodifiableFloatListIterator) {
            return iterator;
        }
        return new UnmodifiableFloatListIterator(iterator);
    }
}

