Camel in Action 2nd Edition
===========================

This project hosts the source code for the examples of the [Camel in Action](https://www.manning.com/books/camel-in-action-second-edition) 2nd edition book written by [Claus Ibsen](https://twitter.com/davsclaus) and [Jonathan Anstey](https://twitter.com/jon_anstey). 

![Camel in Action 2nd ed cover](/docs/images/cia2-cover.png?raw=true)

Table of Contents
-----------------

Part 1 - First Steps

- 1 [Meeting Camel](chapter1)
- 2 [Routing with Camel](chapter2)

Part 2 - Core Camel

- 3 [Transforming data with Camel](chapter3)
- 4 [Using beans with Camel](chapter4)
- 5 [Enterprise integration patterns](chapter5)
- 6 [Using components](chapter6)

Part 3 - Developing and testing

- 7 [Microservices](chapter7)
- 8 [Developing Camel projects](chapter8)
- 9 [Testing](chapter9)
- 10 [RESTful web services](chapter10)

Part 4 - Going further with Camel

- 11 [Error handling](chapter11)
- 12 [Transactions and idempotency](chapter12)
- 13 [Parallel processing](chapter13)
- 14 [Securing Camel](chapter14)

Part 5 - Running and managing Camel

- 15 [Running and deploying Camel](chapter15)
- 16 [Management and monitoring](chapter16)

Part 6 - Out in the Wild

- 17 [Clustering](chapter17)
- 18 [Microservices with Docker and Kubernetes](chapter18)
- 19 [Camel tooling](chapter19)

Bonus Chapters

- 20 [Reactive Camel](chapter20)
- 21 Camel and the IoT by Henryk Konsek (has no source code)

Appendixes

- A Simple, the expression language
- B The Camel community


Downloading the source code
---------------------------

You can either download a .zip with all the source code from the [releases page](https://github.com/camelinaction/camelinaction2/releases), or use the github way of cloning the repository on your computer.


Up to date source code
----------------------

We the authors, intended to keep this source code up to date with future releases of Apache Camel. Giving our readers the best experience with the book and using the latest Camel releases. 


Errata
------
Any mistakes in the book can be reported to us via github issues tracker.
The errata can be [viewed here](errata.txt)

Getting in touch
----------------

To get in touch with the us the authors you can:

* write on the [Manning Author Online forum](https://forums.manning.com/forums/camel-in-action-second-edition)
* reach out to us on twitter: [@davsclaus](https://twitter.com/davsclaus), [@jon_anstey](https://twitter.com/jon_anstey)
* or use the [github issue tracker](https://github.com/camelinaction/camelinaction2/issues)


Happy reading and riding the Camel.

Claus Ibsen, and Jonathan Anstey
