package camelinaction;

import javax.jms.ConnectionFactory;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.junit.Test;

public class OrderRouterWithRecipientListAnnotationTest extends CamelTestSupport {

    @Override
    protected CamelContext createCamelContext() throws Exception {
        // create CamelContext
        CamelContext camelContext = super.createCamelContext();
        
        // connect to embedded ActiveMQ JMS broker
        ConnectionFactory connectionFactory = 
            new ActiveMQConnectionFactory("vm://localhost");
        camelContext.addComponent("jms",
            JmsComponent.jmsComponentAutoAcknowledge(connectionFactory));
        
        return camelContext;
    }
    
    @Test
    public void testPlacingOrders() throws Exception {
        getMockEndpoint("mock:accounting").expectedMessageCount(2);
        getMockEndpoint("mock:production").expectedMessageCount(1);
        assertMockEndpointsSatisfied();
    }
    
    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                // load file orders from src/data into the JMS queue
                from("file:src/data?noop=true").to("jms:incomingOrders");
        
                // content-based router
                from("jms:incomingOrders")
	                .choice()
	                    .when(header("CamelFileName").endsWith(".xml"))
	                        .to("jms:xmlOrders")  
	                    .when(header("CamelFileName").regex("^.*(csv|csl)$"))
	                        .to("jms:csvOrders")
	                    .otherwise()
	                        .to("jms:badOrders");        
                
                from("jms:xmlOrders").bean(AnnotatedRecipientList.class);
               
                from("jms:accounting")        
	                .log("Accounting received order: ${header.CamelFileName}")
	                .to("mock:accounting");                
                
                from("jms:production")        
	                .log("Production received order: ${header.CamelFileName}")
	                .to("mock:production");                
            }
        };
    }
}
