/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.dataformat.DataFormatEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;

public class DataFormatComponent
extends UriEndpointComponent {
    public DataFormatComponent() {
        super(DataFormatEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String name = ObjectHelper.before(remaining, ":");
        DataFormat df = this.getCamelContext().resolveDataFormat(name);
        if (df == null) {
            throw new IllegalArgumentException("Cannot find data format with name: " + name);
        }
        String operation = ObjectHelper.after(remaining, ":");
        if (!"marshal".equals(operation) && !"unmarshal".equals(operation)) {
            throw new IllegalArgumentException("Operation must be either marshal or unmarshal, was: " + operation);
        }
        EndpointHelper.setReferenceProperties(this.getCamelContext(), df, parameters);
        EndpointHelper.setProperties(this.getCamelContext(), df, parameters);
        DataFormatEndpoint endpoint = new DataFormatEndpoint(uri, this, df);
        endpoint.setOperation(operation);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }
}

