/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.Locale;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.processor.CamelLogProcessor;
import org.apache.camel.processor.DefaultExchangeFormatter;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.util.CamelLogger;

public class LogComponent
extends UriEndpointComponent {
    private ExchangeFormatter exchangeFormatter;

    public LogComponent() {
        super(LogEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AsyncProcessor logger;
        LoggingLevel level = this.getLoggingLevel(parameters);
        LogEndpoint endpoint = new LogEndpoint(uri, this);
        endpoint.setLevel(level.name());
        this.setProperties(endpoint, parameters);
        CamelLogger camelLogger = new CamelLogger(remaining, level, endpoint.getMarker());
        if (endpoint.getGroupSize() != null) {
            logger = new ThroughputLogger(camelLogger, endpoint.getGroupSize());
        } else if (endpoint.getGroupInterval() != null) {
            Boolean groupActiveOnly = endpoint.getGroupActiveOnly() != null ? endpoint.getGroupActiveOnly() : Boolean.TRUE;
            Long groupDelay = endpoint.getGroupDelay();
            logger = new ThroughputLogger(camelLogger, this.getCamelContext(), endpoint.getGroupInterval(), groupDelay, groupActiveOnly);
        } else {
            ExchangeFormatter localFormatter = this.exchangeFormatter;
            if (localFormatter == null && (localFormatter = this.getCamelContext().getRegistry().lookupByNameAndType("logFormatter", ExchangeFormatter.class)) != null) {
                this.exchangeFormatter = localFormatter;
                this.setProperties(this.exchangeFormatter, parameters);
            }
            if (localFormatter == null) {
                localFormatter = new DefaultExchangeFormatter();
                this.setProperties(localFormatter, parameters);
            }
            logger = new CamelLogProcessor(camelLogger, localFormatter);
        }
        endpoint.setLogger(logger);
        return endpoint;
    }

    protected LoggingLevel getLoggingLevel(Map<String, Object> parameters) {
        String levelText = this.getAndRemoveParameter(parameters, "level", String.class, "INFO");
        return LoggingLevel.valueOf(levelText.toUpperCase(Locale.ENGLISH));
    }

    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }
}

