/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.AttributeValueExp;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Route")
public class ManagedRoute
extends ManagedPerformanceCounter
implements TimerListener,
ManagedRouteMBean {
    public static final String VALUE_UNKNOWN = "Unknown";
    protected final Route route;
    protected final String description;
    protected final ModelCamelContext context;
    private final LoadTriplet load = new LoadTriplet();

    public ManagedRoute(ModelCamelContext context, Route route) {
        this.route = route;
        this.context = context;
        this.description = route.toString();
        boolean enabled = context.getManagementStrategy().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    public Route getRoute() {
        return this.route;
    }

    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public String getRouteId() {
        String id = this.route.getId();
        if (id == null) {
            id = VALUE_UNKNOWN;
        }
        return id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getEndpointUri() {
        if (this.route.getEndpoint() != null) {
            return this.route.getEndpoint().getEndpointUri();
        }
        return VALUE_UNKNOWN;
    }

    @Override
    public String getState() {
        ServiceStatus status = this.context.getRouteStatus(this.route.getId());
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @Override
    public Integer getInflightExchanges() {
        return this.context.getInflightRepository().size(this.route.getId());
    }

    @Override
    public String getCamelId() {
        return this.context.getName();
    }

    @Override
    public Boolean getTracing() {
        return this.route.getRouteContext().isTracing();
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.route.getRouteContext().setTracing(tracing);
    }

    @Override
    public Boolean getMessageHistory() {
        return this.route.getRouteContext().isMessageHistory();
    }

    @Override
    public String getRoutePolicyList() {
        List<RoutePolicy> policyList = this.route.getRouteContext().getRoutePolicyList();
        if (policyList == null || policyList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < policyList.size(); ++i) {
            RoutePolicy policy = policyList.get(i);
            sb.append(policy.getClass().getSimpleName());
            sb.append("(").append(ObjectHelper.getIdentityHashCode(policy)).append(")");
            if (i >= policyList.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String getLoad01() {
        return String.format("%.2f", this.load.getLoad1());
    }

    @Override
    public String getLoad05() {
        return String.format("%.2f", this.load.getLoad5());
    }

    @Override
    public String getLoad15() {
        return String.format("%.2f", this.load.getLoad15());
    }

    @Override
    public void onTimer() {
        this.load.update(this.getInflightExchanges());
    }

    @Override
    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.startRoute(this.getRouteId());
    }

    @Override
    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.stopRoute(this.getRouteId());
    }

    @Override
    public void stop(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.stopRoute(this.getRouteId(), timeout, TimeUnit.SECONDS);
    }

    @Override
    public boolean stop(Long timeout, Boolean abortAfterTimeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.stopRoute(this.getRouteId(), timeout, TimeUnit.SECONDS, abortAfterTimeout);
    }

    @Override
    public void shutdown() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        String routeId = this.getRouteId();
        this.context.stopRoute(routeId);
        this.context.removeRoute(routeId);
    }

    @Override
    public void shutdown(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        String routeId = this.getRouteId();
        this.context.stopRoute(routeId, timeout, TimeUnit.SECONDS);
        this.context.removeRoute(routeId);
    }

    @Override
    public boolean remove() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.removeRoute(this.getRouteId());
    }

    @Override
    public String dumpRouteAsXml() throws Exception {
        String id = this.route.getId();
        RouteDefinition def = this.context.getRouteDefinition(id);
        if (def != null) {
            return ModelHelper.dumpModelAsXml(def);
        }
        return null;
    }

    @Override
    public void updateRouteFromXml(String xml) throws Exception {
        RouteDefinition def = ModelHelper.createModelFromXml(xml, RouteDefinition.class);
        if (def == null) {
            return;
        }
        if (ObjectHelper.isEmpty(def.getId())) {
            def.setId(this.getRouteId());
        } else if (!def.getId().equals(this.getRouteId())) {
            throw new IllegalArgumentException("Cannot update route from XML as routeIds does not match. routeId: " + this.getRouteId() + ", routeId from XML: " + def.getId());
        }
        this.context.addRouteDefinition(def);
    }

    @Override
    public String dumpRouteStatsAsXml(boolean fullStats, boolean includeProcessors) throws Exception {
        long routeSelfTime;
        StringBuilder sb = new StringBuilder();
        Long processorAccumulatedTime = 0L;
        if (includeProcessors) {
            sb.append("  <processorStats>\n");
            MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
            if (server != null) {
                ObjectName query = ObjectName.getInstance("org.apache.camel:context=*/" + this.getContext().getManagementName() + ",type=processors,*");
                Set<ObjectName> names = server.queryNames(query, null);
                ArrayList<ManagedProcessorMBean> mps = new ArrayList<ManagedProcessorMBean>();
                for (ObjectName on : names) {
                    ManagedProcessorMBean processor = MBeanServerInvocationHandler.newProxyInstance(server, on, ManagedProcessorMBean.class, true);
                    if (!this.getRouteId().equals(processor.getRouteId())) continue;
                    mps.add(processor);
                }
                Collections.sort(mps, new OrderProcessorMBeans());
                HashMap<String, Long> accumulatedTimes = new HashMap<String, Long>();
                Collections.reverse(mps);
                for (ManagedProcessorMBean processor : mps) {
                    processorAccumulatedTime = processorAccumulatedTime + processor.getTotalProcessingTime();
                    accumulatedTimes.put(processor.getProcessorId(), processorAccumulatedTime);
                }
                Collections.reverse(mps);
                for (ManagedProcessorMBean processor : mps) {
                    sb.append("    <processorStat").append(String.format(" id=\"%s\" index=\"%s\"", processor.getProcessorId(), processor.getIndex()));
                    Long accTime = (Long)accumulatedTimes.get(processor.getProcessorId());
                    if (accTime != null) {
                        sb.append(" accumulatedProcessingTime=\"").append(accTime).append("\"");
                    }
                    sb.append(" ").append(processor.dumpStatsAsXml(fullStats).substring(7)).append("\n");
                }
            }
            sb.append("  </processorStats>\n");
        }
        if ((routeSelfTime = this.getTotalProcessingTime() - processorAccumulatedTime) < 0L) {
            routeSelfTime = 0L;
        }
        StringBuilder answer = new StringBuilder();
        answer.append("<routeStat").append(String.format(" id=\"%s\"", this.route.getId()));
        String stat = this.dumpStatsAsXml(fullStats);
        answer.append(" selfProcessingTime=\"").append(routeSelfTime).append("\"");
        answer.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
        if (includeProcessors) {
            answer.append((CharSequence)sb);
        }
        answer.append("</routeStat>");
        return answer.toString();
    }

    @Override
    public void reset(boolean includeProcessors) throws Exception {
        MBeanServer server;
        this.reset();
        if (includeProcessors && (server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer()) != null) {
            ObjectName query = ObjectName.getInstance("org.apache.camel:context=*/" + this.getContext().getManagementName() + ",type=processors,*");
            QueryExp queryExp = Query.match(new AttributeValueExp("RouteId"), new StringValueExp(this.getRouteId()));
            Set<ObjectName> names = server.queryNames(query, queryExp);
            for (ObjectName name : names) {
                server.invoke(name, "reset", null, null);
            }
        }
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.route.equals(((ManagedRoute)o).route);
    }

    public int hashCode() {
        return this.route.hashCode();
    }

    private static final class OrderProcessorMBeans
    implements Comparator<ManagedProcessorMBean> {
        private OrderProcessorMBeans() {
        }

        @Override
        public int compare(ManagedProcessorMBean o1, ManagedProcessorMBean o2) {
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }
}

