/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;

public class WeightedRoundRobinLoadBalancer
extends WeightedLoadBalancer {
    private int counter;

    public WeightedRoundRobinLoadBalancer(List<Integer> distributionRatios) {
        super(distributionRatios);
    }

    @Override
    protected synchronized Processor chooseProcessor(List<Processor> processors, Exchange exchange) {
        if (this.isRuntimeRatiosZeroed()) {
            this.resetRuntimeRatios();
            this.counter = 0;
        }
        boolean found = false;
        while (!found) {
            if (this.counter >= this.getRuntimeRatios().size()) {
                this.counter = 0;
            }
            if (this.getRuntimeRatios().get(this.counter).getRuntimeWeight() > 0) {
                this.getRuntimeRatios().get(this.counter).setRuntimeWeight(this.getRuntimeRatios().get(this.counter).getRuntimeWeight() - 1);
                found = true;
                continue;
            }
            ++this.counter;
        }
        return processors.get(this.counter++);
    }
}

