/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws.bean;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.spring.ws.type.EndpointMappingKey;
import org.apache.camel.component.spring.ws.type.EndpointMappingType;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.server.endpoint.mapping.AbstractEndpointMapping;
import org.springframework.ws.server.endpoint.support.PayloadRootUtils;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.SoapEndpointInvocationChain;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.xml.xpath.XPathExpression;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CamelEndpointMapping
extends AbstractEndpointMapping
implements InitializingBean {
    private static final String DOUBLE_QUOTE = "\"";
    private Map<EndpointMappingKey, MessageEndpoint> endpoints = new ConcurrentHashMap<EndpointMappingKey, MessageEndpoint>();
    private TransformerFactory transformerFactory;
    private XmlConverter xmlConverter;

    protected Object getEndpointInternal(MessageContext messageContext) throws Exception {
        for (EndpointMappingKey key : this.endpoints.keySet()) {
            String messageKey = null;
            switch (key.getType()) {
                case ROOT_QNAME: {
                    messageKey = this.getRootQName(messageContext);
                    break;
                }
                case SOAP_ACTION: {
                    messageKey = this.getSoapAction(messageContext);
                    break;
                }
                case XPATHRESULT: {
                    messageKey = this.getXPathResult(messageContext, key.getExpression());
                    break;
                }
                case URI: {
                    messageKey = this.getUri();
                    break;
                }
                default: {
                    throw new RuntimeCamelException("Invalid mapping type specified. Supported types are: root QName, SOAP action, XPath expression and URI");
                }
            }
            if (messageKey == null || !key.getLookupKey().equals(messageKey)) continue;
            return this.endpoints.get(key);
        }
        return null;
    }

    protected final EndpointInvocationChain createEndpointInvocationChain(MessageContext messageContext, Object endpoint, EndpointInterceptor[] interceptors) {
        for (EndpointMappingKey key : this.endpoints.keySet()) {
            String messageKey;
            if (!EndpointMappingType.SOAP_ACTION.equals((Object)key.getType()) || (messageKey = this.getSoapAction(messageContext)) == null || !key.getLookupKey().equals(messageKey)) continue;
            return new SoapEndpointInvocationChain(endpoint, interceptors);
        }
        return super.createEndpointInvocationChain(messageContext, endpoint, interceptors);
    }

    private String getSoapAction(MessageContext messageContext) {
        if (messageContext.getRequest() instanceof SoapMessage) {
            SoapMessage request = (SoapMessage)messageContext.getRequest();
            String soapAction = request.getSoapAction();
            if (StringUtils.hasLength((String)soapAction) && soapAction.startsWith(DOUBLE_QUOTE) && soapAction.endsWith(DOUBLE_QUOTE)) {
                return soapAction.substring(1, soapAction.length() - 1);
            }
            return soapAction;
        }
        return null;
    }

    private String getUri() throws URISyntaxException {
        WebServiceConnection webServiceConnection;
        TransportContext transportContext = TransportContextHolder.getTransportContext();
        if (transportContext != null && (webServiceConnection = transportContext.getConnection()) != null) {
            return webServiceConnection.getUri().toString();
        }
        return null;
    }

    private String getRootQName(MessageContext messageContext) throws TransformerException, XMLStreamException {
        QName qName = PayloadRootUtils.getPayloadRootQName((Source)messageContext.getRequest().getPayloadSource(), (TransformerFactory)this.transformerFactory);
        return qName != null ? qName.toString() : null;
    }

    private String getXPathResult(MessageContext messageContext, XPathExpression expression) throws TransformerException, XMLStreamException, ParserConfigurationException, IOException, SAXException {
        Node domNode;
        if (expression != null && (domNode = this.xmlConverter.toDOMNode(messageContext.getRequest().getPayloadSource())) != null) {
            return expression.evaluateAsString(domNode.getFirstChild());
        }
        return null;
    }

    public void addConsumer(EndpointMappingKey key, MessageEndpoint endpoint) {
        this.endpoints.put(key, endpoint);
    }

    public void removeConsumer(Object key) {
        this.endpoints.remove(key);
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.xmlConverter = new XmlConverter();
        if (this.transformerFactory != null) {
            this.xmlConverter.setTransformerFactory(this.transformerFactory);
        } else {
            this.transformerFactory = TransformerFactory.newInstance();
        }
    }
}

